/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.ObjectMatrix3D;
import cern.colt.matrix.tobject.impl.DelegateObjectMatrix2D;
import cern.colt.matrix.tobject.impl.DenseObjectMatrix1D;

public class WrapperObjectMatrix3D
extends ObjectMatrix3D {
    private static final long serialVersionUID = 1L;
    protected ObjectMatrix3D content;

    public WrapperObjectMatrix3D(ObjectMatrix3D newContent) {
        block3: {
            if (newContent != null) {
                try {
                    this.setUp(newContent.slices(), newContent.rows(), newContent.columns());
                }
                catch (IllegalArgumentException exc) {
                    if ("matrix too large".equals(exc.getMessage())) break block3;
                    throw exc;
                }
            }
        }
        this.content = newContent;
    }

    public Object elements() {
        return this.content.elements();
    }

    public synchronized Object getQuick(int slice, int row, int column) {
        return this.content.getQuick(slice, row, column);
    }

    public ObjectMatrix3D like(int slices, int rows, int columns) {
        return this.content.like(slices, rows, columns);
    }

    public synchronized void setQuick(int slice, int row, int column, Object value) {
        this.content.setQuick(slice, row, column, value);
    }

    public ObjectMatrix1D vectorize() {
        DenseObjectMatrix1D v = new DenseObjectMatrix1D((int)this.size());
        int length = this.rows * this.columns;
        for (int s = 0; s < this.slices; ++s) {
            v.viewPart(s * length, length).assign(this.viewSlice(s).vectorize());
        }
        return v;
    }

    public ObjectMatrix2D viewColumn(int column) {
        this.checkColumn(column);
        return new DelegateObjectMatrix2D(this, 2, column);
    }

    public ObjectMatrix3D viewColumnFlip() {
        if (this.columns == 0) {
            return this;
        }
        WrapperObjectMatrix3D view = new WrapperObjectMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized Object getQuick(int slice, int row, int column) {
                return this.content.getQuick(slice, row, this.columns - 1 - column);
            }

            public synchronized void setQuick(int slice, int row, int column, Object value) {
                this.content.setQuick(slice, row, this.columns - 1 - column, value);
            }

            public synchronized Object get(int slice, int row, int column) {
                return this.content.get(slice, row, this.columns - 1 - column);
            }

            public synchronized void set(int slice, int row, int column, Object value) {
                this.content.set(slice, row, this.columns - 1 - column, value);
            }
        };
        view.isNoView = false;
        return view;
    }

    public ObjectMatrix2D viewSlice(int slice) {
        this.checkSlice(slice);
        return new DelegateObjectMatrix2D(this, 0, slice);
    }

    public ObjectMatrix3D viewSliceFlip() {
        if (this.slices == 0) {
            return this;
        }
        WrapperObjectMatrix3D view = new WrapperObjectMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized Object getQuick(int slice, int row, int column) {
                return this.content.getQuick(this.slices - 1 - slice, row, column);
            }

            public synchronized void setQuick(int slice, int row, int column, Object value) {
                this.content.setQuick(this.slices - 1 - slice, row, column, value);
            }

            public synchronized Object get(int slice, int row, int column) {
                return this.content.get(this.slices - 1 - slice, row, column);
            }

            public synchronized void set(int slice, int row, int column, Object value) {
                this.content.set(this.slices - 1 - slice, row, column, value);
            }
        };
        view.isNoView = false;
        return view;
    }

    public ObjectMatrix3D viewDice(int axis0, int axis1, int axis2) {
        int d = 3;
        if (axis0 < 0 || axis0 >= d || axis1 < 0 || axis1 >= d || axis2 < 0 || axis2 >= d || axis0 == axis1 || axis0 == axis2 || axis1 == axis2) {
            throw new IllegalArgumentException("Illegal Axes: " + axis0 + ", " + axis1 + ", " + axis2);
        }
        WrapperObjectMatrix3D view = null;
        if (axis0 == 0 && axis1 == 1 && axis2 == 2) {
            view = new WrapperObjectMatrix3D(this);
        } else if (axis0 == 1 && axis1 == 0 && axis2 == 2) {
            view = new WrapperObjectMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized Object getQuick(int slice, int row, int column) {
                    return this.content.getQuick(row, slice, column);
                }

                public synchronized void setQuick(int slice, int row, int column, Object value) {
                    this.content.setQuick(row, slice, column, value);
                }

                public synchronized Object get(int slice, int row, int column) {
                    return this.content.get(row, slice, column);
                }

                public synchronized void set(int slice, int row, int column, Object value) {
                    this.content.set(row, slice, column, value);
                }
            };
        } else if (axis0 == 1 && axis1 == 2 && axis2 == 0) {
            view = new WrapperObjectMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized Object getQuick(int slice, int row, int column) {
                    return this.content.getQuick(row, column, slice);
                }

                public synchronized void setQuick(int slice, int row, int column, Object value) {
                    this.content.setQuick(row, column, slice, value);
                }

                public synchronized Object get(int slice, int row, int column) {
                    return this.content.get(row, column, slice);
                }

                public synchronized void set(int slice, int row, int column, Object value) {
                    this.content.set(row, column, slice, value);
                }
            };
        } else if (axis0 == 2 && axis1 == 1 && axis2 == 0) {
            view = new WrapperObjectMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized Object getQuick(int slice, int row, int column) {
                    return this.content.getQuick(column, row, slice);
                }

                public synchronized void setQuick(int slice, int row, int column, Object value) {
                    this.content.setQuick(column, row, slice, value);
                }

                public synchronized Object get(int slice, int row, int column) {
                    return this.content.get(column, row, slice);
                }

                public synchronized void set(int slice, int row, int column, Object value) {
                    this.content.set(column, row, slice, value);
                }
            };
        } else if (axis0 == 2 && axis1 == 0 && axis2 == 1) {
            view = new WrapperObjectMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized Object getQuick(int slice, int row, int column) {
                    return this.content.getQuick(column, slice, row);
                }

                public synchronized void setQuick(int slice, int row, int column, Object value) {
                    this.content.setQuick(column, slice, row, value);
                }

                public synchronized Object get(int slice, int row, int column) {
                    return this.content.get(column, slice, row);
                }

                public synchronized void set(int slice, int row, int column, Object value) {
                    this.content.set(column, slice, row, value);
                }
            };
        }
        int[] shape = this.shape();
        view.slices = shape[axis0];
        view.rows = shape[axis1];
        view.columns = shape[axis2];
        view.isNoView = false;
        return view;
    }

    public ObjectMatrix3D viewPart(final int slice, final int row, final int column, int depth, int height, int width) {
        this.checkBox(slice, row, column, depth, height, width);
        WrapperObjectMatrix3D view = new WrapperObjectMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized Object getQuick(int i, int j, int k) {
                return this.content.getQuick(slice + i, row + j, column + k);
            }

            public synchronized void setQuick(int i, int j, int k, Object value) {
                this.content.setQuick(slice + i, row + j, column + k, value);
            }

            public synchronized Object get(int i, int j, int k) {
                return this.content.get(slice + i, row + j, column + k);
            }

            public synchronized void set(int i, int j, int k, Object value) {
                this.content.set(slice + i, row + j, column + k, value);
            }
        };
        view.slices = depth;
        view.rows = height;
        view.columns = width;
        view.isNoView = false;
        return view;
    }

    public ObjectMatrix2D viewRow(int row) {
        this.checkRow(row);
        return new DelegateObjectMatrix2D(this, 1, row);
    }

    public ObjectMatrix3D viewRowFlip() {
        if (this.rows == 0) {
            return this;
        }
        WrapperObjectMatrix3D view = new WrapperObjectMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized Object getQuick(int slice, int row, int column) {
                return this.content.getQuick(slice, this.rows - 1 - row, column);
            }

            public synchronized void setQuick(int slice, int row, int column, Object value) {
                this.content.setQuick(slice, this.rows - 1 - row, column, value);
            }

            public synchronized Object get(int slice, int row, int column) {
                return this.content.get(slice, this.rows - 1 - row, column);
            }

            public synchronized void set(int slice, int row, int column, Object value) {
                this.content.set(slice, this.rows - 1 - row, column, value);
            }
        };
        view.isNoView = false;
        return view;
    }

    public ObjectMatrix3D viewSelection(int[] sliceIndexes, int[] rowIndexes, int[] columnIndexes) {
        int i;
        if (sliceIndexes == null) {
            sliceIndexes = new int[this.slices];
            i = this.slices;
            while (--i >= 0) {
                sliceIndexes[i] = i;
            }
        }
        if (rowIndexes == null) {
            rowIndexes = new int[this.rows];
            i = this.rows;
            while (--i >= 0) {
                rowIndexes[i] = i;
            }
        }
        if (columnIndexes == null) {
            columnIndexes = new int[this.columns];
            i = this.columns;
            while (--i >= 0) {
                columnIndexes[i] = i;
            }
        }
        this.checkSliceIndexes(sliceIndexes);
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        final int[] six = sliceIndexes;
        final int[] rix = rowIndexes;
        final int[] cix = columnIndexes;
        WrapperObjectMatrix3D view = new WrapperObjectMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized Object getQuick(int i, int j, int k) {
                return this.content.getQuick(six[i], rix[j], cix[k]);
            }

            public synchronized void setQuick(int i, int j, int k, Object value) {
                this.content.setQuick(six[i], rix[j], cix[k], value);
            }

            public synchronized Object get(int i, int j, int k) {
                return this.content.get(six[i], rix[j], cix[k]);
            }

            public synchronized void set(int i, int j, int k, Object value) {
                this.content.set(six[i], rix[j], cix[k], value);
            }
        };
        view.slices = sliceIndexes.length;
        view.rows = rowIndexes.length;
        view.columns = columnIndexes.length;
        view.isNoView = false;
        return view;
    }

    public ObjectMatrix3D viewStrides(final int _sliceStride, final int _rowStride, final int _columnStride) {
        if (_sliceStride <= 0 || _rowStride <= 0 || _columnStride <= 0) {
            throw new IndexOutOfBoundsException("illegal stride");
        }
        WrapperObjectMatrix3D view = new WrapperObjectMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized Object getQuick(int slice, int row, int column) {
                return this.content.getQuick(_sliceStride * slice, _rowStride * row, _columnStride * column);
            }

            public synchronized void setQuick(int slice, int row, int column, Object value) {
                this.content.setQuick(_sliceStride * slice, _rowStride * row, _columnStride * column, value);
            }

            public synchronized Object get(int slice, int row, int column) {
                return this.content.get(_sliceStride * slice, _rowStride * row, _columnStride * column);
            }

            public synchronized void set(int slice, int row, int column, Object value) {
                this.content.set(_sliceStride * slice, _rowStride * row, _columnStride * column, value);
            }
        };
        if (this.slices != 0) {
            view.slices = (this.slices - 1) / _sliceStride + 1;
        }
        if (this.rows != 0) {
            view.rows = (this.rows - 1) / _rowStride + 1;
        }
        if (this.columns != 0) {
            view.columns = (this.columns - 1) / _columnStride + 1;
        }
        view.isNoView = false;
        return view;
    }

    protected ObjectMatrix3D getContent() {
        return this.content;
    }

    public ObjectMatrix2D like2D(int rows, int columns) {
        throw new InternalError();
    }

    protected ObjectMatrix2D like2D(int rows, int columns, int rowZero, int columnZero, int rowStride, int columnStride) {
        throw new InternalError();
    }

    protected ObjectMatrix3D viewSelectionLike(int[] sliceOffsets, int[] rowOffsets, int[] columnOffsets) {
        throw new InternalError();
    }
}

