/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.colt.PersistentObject;
import cern.colt.Timer;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.jet.random.tdouble.AbstractDoubleDistribution;
import cern.jet.random.tdouble.Gamma;
import cern.jet.random.tdouble.Poisson;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;
import hep.aida.tdouble.bin.DynamicDoubleBin1D;

public class Benchmark
extends PersistentObject {
    private static final long serialVersionUID = -8509762371822439740L;
    protected DoubleRandomEngine randomGenerator;

    protected Benchmark() {
        throw new RuntimeException("Non instantiable");
    }

    public static void demo1() {
        double mean = 5.0;
        double variance = 1.5;
        double alpha = mean * mean / variance;
        double lambda = 1.0 / (variance / mean);
        DoubleMersenneTwister engine = new DoubleMersenneTwister();
        Gamma dist = new Gamma(alpha, lambda, engine);
        int size = 100000;
        DoubleArrayList numbers = new DoubleArrayList(size);
        for (int i = 0; i < size; ++i) {
            numbers.add(((AbstractDoubleDistribution)dist).nextDouble());
        }
        DynamicDoubleBin1D bin = new DynamicDoubleBin1D();
        bin.addAllOf(numbers);
        System.out.println(bin);
    }

    public static void main(String[] args) {
        int size = Integer.parseInt(args[0]);
        boolean print = new Boolean(args[1]);
        double mean = new Double(args[2]);
        String generatorName = args[3];
        Benchmark.random(size, print, mean, generatorName);
    }

    public static void random(int size, boolean print, double mean, String generatorName) {
        DoubleRandomEngine gen;
        System.out.println("Generating " + size + " random numbers per distribution...\n");
        try {
            gen = (DoubleRandomEngine)Class.forName(generatorName).newInstance();
        }
        catch (Exception exc) {
            throw new InternalError(exc.getMessage());
        }
        Benchmark.randomInstance(size, print, new Poisson(mean, (DoubleRandomEngine)gen.clone()));
    }

    public static void randomInstance(int size, boolean print, AbstractDoubleDistribution dist) {
        System.out.print("\n" + dist + " ...");
        Timer timer = new Timer().start();
        int i = size;
        while (--i >= 0) {
            double rand = dist.nextDouble();
            if (!print) continue;
            if ((size - i - 1) % 8 == 0) {
                System.out.println();
            }
            System.out.print((float)rand + ", ");
        }
        timer.stop();
        System.out.println("\n" + timer);
    }

    public static void test(int size, AbstractDoubleDistribution distribution) {
        int j = 0;
        int i = size;
        while (--i >= 0) {
            System.out.print(" " + distribution.nextDouble());
            if (j % 8 == 7) {
                System.out.println();
            }
            ++j;
        }
        System.out.println("\n\nGood bye.\n");
    }

    public static void test2(int size, AbstractDoubleDistribution distribution) {
        DynamicDoubleBin1D bin = new DynamicDoubleBin1D();
        int j = 0;
        int i = size;
        while (--i >= 0) {
            bin.add(distribution.nextDouble());
            ++j;
        }
        System.out.println(bin);
        System.out.println("\n\nGood bye.\n");
    }

    public static void test2(int size, AbstractDoubleDistribution a, AbstractDoubleDistribution b) {
        DynamicDoubleBin1D binA = new DynamicDoubleBin1D();
        DynamicDoubleBin1D binB = new DynamicDoubleBin1D();
        int j = 0;
        int i = size;
        while (--i >= 0) {
            binA.add(a.nextDouble());
            binB.add(b.nextDouble());
            ++j;
        }
        System.out.println("\n\nBenchmarking frequencies...\n");
        IntArrayList freq = new IntArrayList();
        DoubleArrayList distinct = new DoubleArrayList();
        Timer timer = new Timer();
        timer.reset();
        timer.start();
        binA.frequencies(distinct, freq);
        timer.stop().display();
        System.out.println("\n\nGood bye.\n");
    }
}

