/*
 * Decompiled with CFR 0.152.
 */
package binc.installer;

import binc.BinCallUtils;
import binc.Command;
import binc.installer.Installer;
import binc.installer.InstallerContext;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Downloader {
    private final File destination;
    private final List<URL> urls;

    public static Downloader downloader(File destination, URL url) {
        List<URL> urls = Collections.singletonList(url);
        return new Downloader(destination, urls);
    }

    public static Downloader downloader(File destination, String url) {
        try {
            return Downloader.downloader(destination, new URL(url));
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    public Downloader addMirror(URL mirror) {
        ArrayList urls = Lists.newArrayList(this.urls);
        urls.add(mirror);
        return new Downloader(this.destination, urls);
    }

    public Downloader addMirror(String mirror) {
        try {
            return this.addMirror(new URL(mirror));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private Downloader(File destination, List<URL> urls) {
        this.destination = destination;
        this.urls = urls;
    }

    public void download() {
        StringBuilder messages = new StringBuilder();
        for (URL url : this.urls) {
            try {
                Downloader.download(url, this.destination);
                return;
            }
            catch (Exception e) {
                messages.append(e.getMessage() + "\n");
            }
        }
        throw new RuntimeException("All download URLs failed (" + this.urls + "). Details:\n" + messages);
    }

    public static void download(URL website, File target) {
        try {
            ReadableByteChannel rbc = Channels.newChannel(website.openStream());
            FileOutputStream fos = new FileOutputStream(target);
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws IOException {
        Installer jagsInstaller = new Installer(){

            @Override
            public File install(InstallerContext context) {
                System.out.println(Command.cmd(new File(context.getInstallFolder(), "JAGS-3.4.0/configure")).ranIn(new File(context.getInstallFolder(), "JAGS-3.4.0")).call());
                return null;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        File testCtx = BinCallUtils.resolveUserHome("~/temp/installfolder");
        InstallerContext context = new InstallerContext(testCtx);
        jagsInstaller.install(context);
    }
}

