/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.reflect.declaration;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.Query;
import spoon.reflect.visitor.filter.ReferenceTypeFilter;
import spoon.support.compiler.SnippetCompilationHelper;
import spoon.support.reflect.declaration.CtElementImpl;
import spoon.support.reflect.declaration.CtNamedElementImpl;

public abstract class CtTypeImpl<T>
extends CtNamedElementImpl
implements CtType<T> {
    private static final long serialVersionUID = 1L;
    List<CtTypeReference<?>> formalTypeParameters = CtTypeImpl.EMPTY_LIST();
    Set<CtTypeReference<?>> interfaces = CtTypeImpl.EMPTY_SET();
    Set<CtMethod<?>> methods = CtTypeImpl.EMPTY_SET();
    private List<CtField<?>> fields = new ArrayList();
    Set<CtType<?>> nestedTypes = new TreeSet();
    Set<ModifierKind> modifiers = CtElementImpl.EMPTY_SET();

    @Override
    public <F> boolean addField(CtField<F> field) {
        if (!this.fields.contains(field)) {
            return this.fields.add(field);
        }
        return false;
    }

    @Override
    public <F> boolean removeField(CtField<F> field) {
        return this.fields.remove(field);
    }

    @Override
    public CtField<?> getField(String name) {
        for (CtField<?> f : this.fields) {
            if (!f.getSimpleName().equals(name)) continue;
            return f;
        }
        return null;
    }

    @Override
    public List<CtField<?>> getFields() {
        return this.fields;
    }

    @Override
    public <N> boolean addNestedType(CtType<N> nestedType) {
        return this.nestedTypes.add(nestedType);
    }

    @Override
    public <N> boolean removeNestedType(CtType<N> nestedType) {
        return this.nestedTypes.remove(nestedType);
    }

    @Override
    public Set<CtTypeReference<?>> getUsedTypes(boolean includeSamePackage) {
        HashSet typeRefs = new HashSet();
        for (CtTypeReference typeRef : Query.getReferences(this, new ReferenceTypeFilter(CtTypeReference.class))) {
            if (typeRef.isPrimitive() || typeRef instanceof CtArrayTypeReference || typeRef.toString().equals("<nulltype>") || typeRef.getPackage() != null && "java.lang".equals(typeRef.getPackage().toString()) || !includeSamePackage && typeRef.getPackage().equals(this.getPackage().getReference())) continue;
            typeRefs.add(typeRef);
        }
        return typeRefs;
    }

    @Override
    public Class<T> getActualClass() {
        return this.getFactory().Type().createReference(this).getActualClass();
    }

    @Override
    public CtType<?> getDeclaringType() {
        if (this.parent == null) {
            this.setRootElement(true);
        }
        return this.getParent(CtType.class);
    }

    @Override
    public <N extends CtType<?>> N getNestedType(final String name) {
        class NestedTypeScanner
        extends CtScanner {
            CtType<?> type;

            NestedTypeScanner() {
            }

            public void checkType(CtType<?> type) {
                if (type.getSimpleName().equals(name) && CtTypeImpl.this.equals(type.getDeclaringType())) {
                    this.type = type;
                }
            }

            public <U> void visitCtClass(CtClass<U> ctClass) {
                this.scan(ctClass.getNestedTypes());
                this.scan(ctClass.getConstructors());
                this.scan(ctClass.getMethods());
                this.checkType(ctClass);
            }

            public <U> void visitCtInterface(CtInterface<U> intrface) {
                this.scan(intrface.getNestedTypes());
                this.scan(intrface.getMethods());
                this.checkType(intrface);
            }

            public <U extends Enum<?>> void visitCtEnum(CtEnum<U> ctEnum) {
                this.scan(ctEnum.getNestedTypes());
                this.scan(ctEnum.getConstructors());
                this.scan(ctEnum.getMethods());
                this.checkType(ctEnum);
            }

            @Override
            public <A extends Annotation> void visitCtAnnotationType(CtAnnotationType<A> annotationType) {
                this.scan(annotationType.getNestedTypes());
                this.checkType(annotationType);
            }

            CtType<?> getType() {
                return this.type;
            }
        }
        NestedTypeScanner scanner = new NestedTypeScanner();
        scanner.scan(this);
        return (N)scanner.getType();
    }

    @Override
    public Set<CtType<?>> getNestedTypes() {
        return this.nestedTypes;
    }

    @Override
    public CtPackage getPackage() {
        if (this.parent instanceof CtPackage) {
            return (CtPackage)this.parent;
        }
        if (this.parent instanceof CtType) {
            return ((CtType)this.parent).getPackage();
        }
        return null;
    }

    @Override
    public CtTypeReference<T> getReference() {
        return this.getFactory().Type().createReference(this);
    }

    @Override
    public boolean isTopLevel() {
        return this.getDeclaringType() == null && this.getPackage() != null;
    }

    @Override
    public void compileAndReplaceSnippets() {
        SnippetCompilationHelper.compileAndReplaceSnippetsIn(this);
    }

    @Override
    public void setParent(CtElement parentElement) {
        super.setParent(parentElement);
        if (parentElement instanceof CtPackage) {
            CtPackage pack = (CtPackage)parentElement;
            Set<CtType<?>> types = pack.getTypes();
            types.add(this);
        }
    }

    @Override
    public Set<ModifierKind> getModifiers() {
        return this.modifiers;
    }

    @Override
    public boolean hasModifier(ModifierKind modifier) {
        return this.getModifiers().contains((Object)modifier);
    }

    @Override
    public void setModifiers(Set<ModifierKind> modifiers) {
        this.modifiers = modifiers;
    }

    @Override
    public boolean addModifier(ModifierKind modifier) {
        if (this.modifiers == CtElementImpl.EMPTY_SET()) {
            this.modifiers = new TreeSet<ModifierKind>();
        }
        return this.modifiers.add(modifier);
    }

    @Override
    public boolean removeModifier(ModifierKind modifier) {
        return this.modifiers.remove((Object)modifier);
    }

    @Override
    public void setVisibility(ModifierKind visibility) {
        if (this.modifiers == CtElementImpl.EMPTY_SET()) {
            this.modifiers = new TreeSet<ModifierKind>();
        }
        this.getModifiers().remove((Object)ModifierKind.PUBLIC);
        this.getModifiers().remove((Object)ModifierKind.PROTECTED);
        this.getModifiers().remove((Object)ModifierKind.PRIVATE);
        this.getModifiers().add(visibility);
    }

    @Override
    public ModifierKind getVisibility() {
        if (this.getModifiers().contains((Object)ModifierKind.PUBLIC)) {
            return ModifierKind.PUBLIC;
        }
        if (this.getModifiers().contains((Object)ModifierKind.PROTECTED)) {
            return ModifierKind.PROTECTED;
        }
        if (this.getModifiers().contains((Object)ModifierKind.PRIVATE)) {
            return ModifierKind.PRIVATE;
        }
        return null;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public CtTypeReference<?> getSuperclass() {
        return null;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    public List<CtFieldReference<?>> getAllFields() {
        CtTypeReference<?> st;
        ArrayList l = new ArrayList();
        for (CtField<?> f : this.getFields()) {
            l.add(f.getReference());
        }
        if (this instanceof CtClass && (st = ((CtClass)((Object)this)).getSuperclass()) != null) {
            l.addAll(st.getAllFields());
        }
        return l;
    }

    @Override
    public Collection<CtFieldReference<?>> getDeclaredFields() {
        ArrayList l = new ArrayList();
        for (CtField<?> f : this.getFields()) {
            l.add(f.getReference());
        }
        return Collections.unmodifiableCollection(l);
    }

    @Override
    public boolean isSubtypeOf(CtTypeReference<?> type) {
        return type.isSubtypeOf((CtTypeReference<?>)this.getReference());
    }

    @Override
    public boolean isAssignableFrom(CtTypeReference<?> type) {
        return this.isSubtypeOf(type);
    }

    @Override
    public <M> boolean addMethod(CtMethod<M> method) {
        if (this.methods == CtElementImpl.EMPTY_SET()) {
            this.methods = new TreeSet();
        }
        return this.methods.add(method);
    }

    @Override
    public <S> boolean addSuperInterface(CtTypeReference<S> interfac) {
        if (this.interfaces == CtElementImpl.EMPTY_SET()) {
            this.interfaces = new TreeSet();
        }
        return this.interfaces.add(interfac);
    }

    @Override
    public <M> boolean removeMethod(CtMethod<M> method) {
        if (this.methods.contains(method)) {
            return this.methods.remove(method);
        }
        return false;
    }

    @Override
    public <S> boolean removeSuperInterface(CtTypeReference<S> interfac) {
        if (this.interfaces.contains(interfac)) {
            return this.interfaces.remove(interfac);
        }
        return false;
    }

    @Override
    public boolean addFormalTypeParameter(CtTypeReference<?> formalTypeParameter) {
        if (this.formalTypeParameters == CtElementImpl.EMPTY_LIST()) {
            this.formalTypeParameters = new ArrayList();
        }
        return this.formalTypeParameters.add(formalTypeParameter);
    }

    @Override
    public boolean removeFormalTypeParameter(CtTypeReference<?> formalTypeParameter) {
        if (this.formalTypeParameters.contains(formalTypeParameter)) {
            return this.formalTypeParameters.remove(formalTypeParameter);
        }
        return false;
    }

    @Override
    public List<CtTypeReference<?>> getFormalTypeParameters() {
        return this.formalTypeParameters;
    }

    @Override
    public <R> CtMethod<R> getMethod(CtTypeReference<R> returnType, String name, CtTypeReference<?> ... parameterTypes) {
        for (CtMethod<?> mm : this.methods) {
            CtMethod<?> m = mm;
            if (!m.getSimpleName().equals(name) || !m.getType().equals(returnType)) continue;
            boolean cont = m.getParameters().size() == parameterTypes.length;
            for (int i = 0; cont && i < m.getParameters().size() && i < parameterTypes.length; ++i) {
                if (m.getParameters().get(i).getType().getQualifiedName().equals(parameterTypes[i].getQualifiedName())) continue;
                cont = false;
            }
            if (!cont) continue;
            return m;
        }
        return null;
    }

    @Override
    public <R> CtMethod<R> getMethod(String name, CtTypeReference<?> ... parameterTypes) {
        for (CtMethod<?> m : this.methods) {
            if (!m.getSimpleName().equals(name)) continue;
            boolean cont = m.getParameters().size() == parameterTypes.length;
            for (int i = 0; cont && i < m.getParameters().size() && i < parameterTypes.length; ++i) {
                if (m.getParameters().get(i).getType().equals(parameterTypes[i])) continue;
                cont = false;
            }
            if (!cont) continue;
            return m;
        }
        return null;
    }

    @Override
    public Set<CtMethod<?>> getMethods() {
        return this.methods;
    }

    @Override
    public Set<CtMethod<?>> getMethodsAnnotatedWith(CtTypeReference<?> ... annotationTypes) {
        HashSet result = new HashSet();
        for (CtMethod<?> m : this.methods) {
            for (CtAnnotation<? extends Annotation> a : m.getAnnotations()) {
                if (!Arrays.asList(annotationTypes).contains(a.getAnnotationType())) continue;
                result.add(m);
            }
        }
        return result;
    }

    @Override
    public List<CtMethod<?>> getMethodsByName(String name) {
        ArrayList result = new ArrayList();
        for (CtMethod<?> m : this.methods) {
            if (!name.equals(m.getSimpleName())) continue;
            result.add(m);
        }
        return result;
    }

    @Override
    public String getQualifiedName() {
        if (this.isTopLevel()) {
            if (this.getPackage() != null && !this.getPackage().getSimpleName().equals("unnamed package")) {
                return this.getPackage().getQualifiedName() + "." + this.getSimpleName();
            }
            return this.getSimpleName();
        }
        if (this.getDeclaringType() != null) {
            return this.getDeclaringType().getQualifiedName() + "$" + this.getSimpleName();
        }
        return this.getSimpleName();
    }

    @Override
    public Set<CtTypeReference<?>> getSuperInterfaces() {
        return this.interfaces;
    }

    @Override
    public void setFormalTypeParameters(List<CtTypeReference<?>> formalTypeParameters) {
        this.formalTypeParameters = formalTypeParameters;
    }

    @Override
    public void setMethods(Set<CtMethod<?>> methods) {
        this.methods = methods;
    }

    @Override
    public void setSuperInterfaces(Set<CtTypeReference<?>> interfaces) {
        this.interfaces = interfaces;
    }

    @Override
    public Collection<CtExecutableReference<?>> getDeclaredExecutables() {
        ArrayList l = new ArrayList();
        for (CtExecutable ctExecutable : this.getMethods()) {
            l.add(ctExecutable.getReference());
        }
        return Collections.unmodifiableCollection(l);
    }

    @Override
    public Collection<CtExecutableReference<?>> getAllExecutables() {
        CtTypeReference<?> st;
        HashSet l = new HashSet(this.getDeclaredExecutables());
        if (this instanceof CtClass && (st = ((CtClass)((Object)this)).getSuperclass()) != null) {
            l.addAll(st.getAllExecutables());
        }
        return l;
    }

    @Override
    public Set<CtMethod<?>> getAllMethods() {
        HashSet l = new HashSet(this.getMethods());
        CtTypeReference<?> st = ((CtClass)((Object)this)).getSuperclass();
        if (st != null) {
            l.addAll(((CtType)((Object)st)).getAllMethods());
        }
        return l;
    }
}

