/*
 * Decompiled with CFR 0.152.
 */
package spoon.template;

import java.util.List;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtGenericElement;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.Query;
import spoon.reflect.visitor.filter.ReferenceTypeFilter;
import spoon.support.template.Parameters;
import spoon.support.template.SubstitutionVisitor;
import spoon.template.Local;
import spoon.template.Parameter;
import spoon.template.Template;

public abstract class Substitution {
    private Substitution() {
    }

    public static <T extends Template<?>> void insertAll(CtType<?> targetType, T template) {
        CtType templateClass = targetType.getFactory().Class().get((Class)template.getClass());
        for (CtTypeReference ctTypeReference : templateClass.getSuperInterfaces()) {
            if (ctTypeReference.equals(targetType.getFactory().Type().createReference(Template.class))) continue;
            CtTypeReference t1 = ctTypeReference;
            if (Parameters.getNames(templateClass).contains(ctTypeReference.getSimpleName())) {
                Object o = Parameters.getValue(template, ctTypeReference.getSimpleName(), null);
                if (o instanceof CtTypeReference) {
                    t1 = (CtTypeReference)o;
                } else if (o instanceof Class) {
                    t1 = targetType.getFactory().Type().createReference((Class)o);
                } else if (o instanceof String) {
                    t1 = targetType.getFactory().Type().createReference((String)o);
                }
            }
            if (t1.equals(targetType.getReference())) continue;
            Class<?> c = null;
            try {
                c = t1.getActualClass();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (c != null && c.isInterface()) {
                targetType.addSuperInterface(t1);
            }
            if (c != null) continue;
            targetType.addSuperInterface(t1);
        }
        for (CtMethod ctMethod : templateClass.getMethods()) {
            if (ctMethod.getAnnotation(Local.class) != null || ctMethod.getAnnotation(Parameter.class) != null) continue;
            Substitution.insertMethod(targetType, template, ctMethod);
        }
        if (targetType instanceof CtClass) {
            for (CtConstructor ctConstructor : templateClass.getConstructors()) {
                if (ctConstructor.isImplicit() || ctConstructor.getAnnotation(Local.class) != null) continue;
                Substitution.insertConstructor((CtClass)targetType, template, ctConstructor);
            }
        }
        if (targetType instanceof CtClass) {
            for (CtAnonymousExecutable ctAnonymousExecutable : templateClass.getAnonymousExecutables()) {
                ((CtClass)targetType).addAnonymousExecutable(Substitution.substitute(targetType, template, ctAnonymousExecutable));
            }
        }
        for (CtField ctField : templateClass.getFields()) {
            if (ctField.getAnnotation(Local.class) != null || Parameters.isParameterSource(ctField.getReference())) continue;
            Substitution.insertField(targetType, template, ctField);
        }
        for (CtType ctType : templateClass.getNestedTypes()) {
            if (ctType.getAnnotation(Local.class) != null) continue;
            CtType result = Substitution.substitute(templateClass, template, ctType);
            targetType.addNestedType(result);
        }
    }

    public static void insertAllSuperInterfaces(CtType<?> targetType, Template<?> template) {
        CtType sourceClass = targetType.getFactory().Class().get((Class)template.getClass());
        for (CtTypeReference ctTypeReference : sourceClass.getSuperInterfaces()) {
            if (ctTypeReference.equals(targetType.getFactory().Type().createReference(Template.class))) continue;
            CtTypeReference t1 = ctTypeReference;
            if (Parameters.getNames(sourceClass).contains(ctTypeReference.getSimpleName())) {
                Object o = Parameters.getValue(template, ctTypeReference.getSimpleName(), null);
                if (o instanceof CtTypeReference) {
                    t1 = (CtTypeReference)o;
                } else if (o instanceof Class) {
                    t1 = targetType.getFactory().Type().createReference((Class)o);
                } else if (o instanceof String) {
                    t1 = targetType.getFactory().Type().createReference((String)o);
                }
            }
            if (t1.equals(targetType.getReference())) continue;
            Class<?> c = t1.getActualClass();
            if (c != null && c.isInterface()) {
                targetType.addSuperInterface(t1);
            }
            if (c != null) continue;
            targetType.addSuperInterface(t1);
        }
    }

    public static void insertAllMethods(CtType<?> targetType, Template<?> template) {
        CtType sourceClass = targetType.getFactory().Class().get((Class)template.getClass());
        for (CtMethod<?> m : sourceClass.getMethods()) {
            if (m.getAnnotation(Local.class) != null || m.getAnnotation(Parameter.class) != null) continue;
            Substitution.insertMethod(targetType, template, m);
        }
    }

    public static void insertAllFields(CtType<?> targetType, Template<?> template) {
        CtType sourceClass = targetType.getFactory().Class().get((Class)template.getClass());
        for (CtField<?> f : sourceClass.getFields()) {
            if (f.getAnnotation(Local.class) != null || Parameters.isParameterSource(f.getReference())) continue;
            Substitution.insertField(targetType, template, f);
        }
    }

    public static void insertAllConstructors(CtType<?> targetType, Template<?> template) {
        CtType sourceClass = targetType.getFactory().Class().get((Class)template.getClass());
        if (targetType instanceof CtClass) {
            for (CtConstructor ctConstructor : sourceClass.getConstructors()) {
                if (ctConstructor.isImplicit() || ctConstructor.getAnnotation(Local.class) != null) continue;
                Substitution.insertConstructor((CtClass)targetType, template, ctConstructor);
            }
        }
        if (targetType instanceof CtClass) {
            for (CtAnonymousExecutable ctAnonymousExecutable : sourceClass.getAnonymousExecutables()) {
                CtAnonymousExecutable e2 = Substitution.substitute(targetType, template, ctAnonymousExecutable);
                ((CtClass)targetType).addAnonymousExecutable(e2);
            }
        }
    }

    public static <T> CtConstructor<T> insertConstructor(CtClass<T> targetClass, Template<?> template, CtMethod<?> sourceMethod) {
        if (targetClass instanceof CtInterface) {
            return null;
        }
        CtConstructor<T> newConstructor = targetClass.getFactory().Constructor().create(targetClass, sourceMethod);
        newConstructor = Substitution.substitute(targetClass, template, newConstructor);
        targetClass.addConstructor(newConstructor);
        return newConstructor;
    }

    public static <T> CtMethod<T> insertMethod(CtType<?> targetType, Template<?> template, CtMethod<T> sourceMethod) {
        CtMethod<T> newMethod = Substitution.substitute(targetType, template, sourceMethod);
        if (targetType instanceof CtInterface) {
            newMethod.setBody(null);
        }
        targetType.addMethod(newMethod);
        return newMethod;
    }

    public static <T> CtConstructor<T> insertConstructor(CtClass<T> targetClass, Template<?> template, CtConstructor<?> sourceConstructor) {
        CtConstructor<T> c;
        CtConstructor<?> newConstrutor = Substitution.substitute(targetClass, template, sourceConstructor);
        if (newConstrutor.getParameters().isEmpty() && (c = targetClass.getConstructor(new CtTypeReference[0])) != null && c.isImplicit()) {
            targetClass.getConstructors().remove(c);
        }
        targetClass.addConstructor(newConstrutor);
        return newConstrutor;
    }

    public static CtBlock<?> substituteMethodBody(CtClass<?> targetClass, Template<?> template, String executableName, CtTypeReference<?> ... parameterTypes) {
        CtType sourceClass = targetClass.getFactory().Class().get((Class)template.getClass());
        CtGenericElement sourceExecutable = executableName.equals(template.getClass().getSimpleName()) ? sourceClass.getConstructor(parameterTypes) : sourceClass.getMethod(executableName, parameterTypes);
        return Substitution.substitute(targetClass, template, sourceExecutable.getBody());
    }

    public static CtStatement substituteStatement(CtClass<?> targetClass, Template<?> template, int statementIndex, String executableName, CtTypeReference<?> ... parameterTypes) {
        CtType sourceClass = targetClass.getFactory().Class().get((Class)template.getClass());
        CtGenericElement sourceExecutable = executableName.equals(template.getClass().getSimpleName()) ? sourceClass.getConstructor(parameterTypes) : sourceClass.getMethod(executableName, parameterTypes);
        return (CtStatement)Substitution.substitute(targetClass, template, sourceExecutable.getBody().getStatement(statementIndex));
    }

    public static CtExpression<?> substituteFieldDefaultExpression(CtType<?> targetType, Template<?> template, String fieldName) {
        CtType sourceClass = targetType.getFactory().Class().get((Class)template.getClass());
        CtField<?> sourceField = sourceClass.getField(fieldName);
        return Substitution.substitute(targetType, template, sourceField.getDefaultExpression());
    }

    public static <E extends CtElement> E substitute(CtType<?> targetType, Template<?> template, E code) {
        if (code == null) {
            return null;
        }
        if (targetType == null) {
            throw new RuntimeException("target is null in substitution");
        }
        E result = targetType.getFactory().Core().clone(code);
        new SubstitutionVisitor(targetType.getFactory(), targetType, template).scan(result);
        return result;
    }

    public static <T extends CtType<?>> T substitute(Template<?> template, T templateType) {
        T result = templateType.getFactory().Core().clone(templateType);
        result.setPositions(null);
        new SubstitutionVisitor(templateType.getFactory(), result, template).scan(result);
        return result;
    }

    public static <T> CtField<T> insertField(CtType<?> targetType, Template<?> template, CtField<T> sourceField) {
        CtField<T> field = Substitution.substitute(targetType, template, sourceField);
        targetType.addField(field);
        return field;
    }

    public static void redirectTypeReferences(CtElement element, CtTypeReference<?> source, CtTypeReference<?> target) {
        List<CtTypeReference> refs = Query.getReferences(element, new ReferenceTypeFilter(CtTypeReference.class));
        String srcName = source.getQualifiedName();
        String targetName = target.getSimpleName();
        CtPackageReference targetPackage = target.getPackage();
        for (CtTypeReference ref : refs) {
            if (!ref.getQualifiedName().equals(srcName)) continue;
            ref.setSimpleName(targetName);
            ref.setPackage(targetPackage);
        }
    }
}

