/*
 * Decompiled with CFR 0.152.
 */
package edu.ufl.cise.colamd.tdouble;

import edu.ufl.cise.colamd.tdouble.Colamd_Col;
import edu.ufl.cise.colamd.tdouble.Colamd_Row;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class Dcolamd {
    public static String COLAMD_DATE = "Jan 25, 2011";
    public static int COLAMD_MAIN_VERSION = 2;
    public static int COLAMD_SUB_VERSION = 7;
    public static int COLAMD_SUBSUB_VERSION = 3;
    public static int COLAMD_VERSION = Dcolamd.COLAMD_VERSION_CODE(COLAMD_MAIN_VERSION, COLAMD_SUB_VERSION);
    public static int COLAMD_KNOBS = 20;
    public static int COLAMD_STATS = 20;
    public static int COLAMD_DENSE_ROW = 0;
    public static int COLAMD_DENSE_COL = 1;
    public static int COLAMD_AGGRESSIVE = 2;
    public static int COLAMD_DEFRAG_COUNT = 2;
    public static int COLAMD_STATUS = 3;
    public static final int COLAMD_INFO1 = 4;
    public static final int COLAMD_INFO2 = 5;
    public static final int COLAMD_INFO3 = 6;
    public static final int COLAMD_OK = 0;
    public static final int COLAMD_OK_BUT_JUMBLED = 1;
    public static final int COLAMD_ERROR_A_not_present = -1;
    public static final int COLAMD_ERROR_p_not_present = -2;
    public static final int COLAMD_ERROR_nrow_negative = -3;
    public static final int COLAMD_ERROR_ncol_negative = -4;
    public static final int COLAMD_ERROR_nnz_negative = -5;
    public static final int COLAMD_ERROR_p0_nonzero = -6;
    public static final int COLAMD_ERROR_A_too_small = -7;
    public static final int COLAMD_ERROR_col_length_negative = -8;
    public static final int COLAMD_ERROR_row_index_out_of_bounds = -9;
    public static final int COLAMD_ERROR_out_of_memory = -10;
    public static final int COLAMD_ERROR_internal_error = -999;
    public static boolean NDEBUG = true;
    public static boolean NPRINT = true;
    private static int Int_MAX = Integer.MAX_VALUE;
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private static final int EMPTY = -1;
    private static final int ALIVE = 0;
    private static final int DEAD = -1;
    private static final int DEAD_PRINCIPAL = -1;
    private static final int DEAD_NON_PRINCIPAL = -2;
    public static int colamd_debug = 0;

    public static int COLAMD_VERSION_CODE(int main, int sub) {
        return main * 1000 + sub;
    }

    protected static double sqrt(double a) {
        return Math.sqrt(a);
    }

    private static final int MAX(int a, int b) {
        return a > b ? a : b;
    }

    private static final int MIN(int a, int b) {
        return a < b ? a : b;
    }

    private static final double MAX(double a, double b) {
        return a > b ? a : b;
    }

    private static int DENSE_DEGREE(double alpha, int n) {
        return (int)Dcolamd.MAX(16.0, alpha * Dcolamd.sqrt(n));
    }

    private static int ONES_COMPLEMENT(int r) {
        return -r - 1;
    }

    private static boolean ROW_IS_DEAD(Colamd_Row[] Row, int r) {
        return Dcolamd.ROW_IS_MARKED_DEAD(Row[r].mark());
    }

    private static boolean ROW_IS_MARKED_DEAD(int row_mark) {
        return row_mark < 0;
    }

    private static boolean ROW_IS_ALIVE(Colamd_Row[] Row, int r) {
        return Row[r].mark() >= 0;
    }

    private static boolean COL_IS_DEAD(Colamd_Col[] Col, int c) {
        return Col[c].start < 0;
    }

    private static boolean COL_IS_ALIVE(Colamd_Col[] Col, int c) {
        return Col[c].start >= 0;
    }

    private static boolean COL_IS_DEAD_PRINCIPAL(Colamd_Col[] Col, int c) {
        return Col[c].start == -1;
    }

    private static void KILL_ROW(Colamd_Row[] Row, int r) {
        Row[r].mark(-1);
    }

    private static void KILL_PRINCIPAL_COL(Colamd_Col[] Col, int c) {
        Col[c].start = -1;
    }

    private static void KILL_NON_PRINCIPAL_COL(Colamd_Col[] Col, int c) {
        Col[c].start = -2;
    }

    private static int INDEX(int i) {
        return i;
    }

    private static void PRINTF(String format, Object ... args) {
        if (!NPRINT) {
            System.out.printf(format, args);
        }
    }

    protected static void DEBUG0(String format, Object ... args) {
        if (!NDEBUG) {
            Dcolamd.PRINTF(format, args);
        }
    }

    protected static void DEBUG1(String format, Object ... args) {
        if (!NDEBUG && colamd_debug >= 1) {
            Dcolamd.PRINTF(format, args);
        }
    }

    protected static void DEBUG2(String format, Object ... args) {
        if (!NDEBUG && colamd_debug >= 2) {
            Dcolamd.PRINTF(format, args);
        }
    }

    protected static void DEBUG3(String format, Object ... args) {
        if (!NDEBUG && colamd_debug >= 3) {
            Dcolamd.PRINTF(format, args);
        }
    }

    protected static void DEBUG4(String format, Object ... args) {
        if (!NDEBUG && colamd_debug >= 4) {
            Dcolamd.PRINTF(format, args);
        }
    }

    protected static void ASSERT(boolean a) {
        if (!NDEBUG) assert (a);
    }

    protected static void ASSERT(int a) {
        Dcolamd.ASSERT(a != 0);
    }

    private static int t_add(int a, int b, int[] ok) {
        ok[0] = ok[0] != 0 && a + b >= Dcolamd.MAX(a, b) ? 1 : 0;
        return ok[0] != 0 ? a + b : 0;
    }

    static int t_mult(int a, int k, int[] ok) {
        int s = 0;
        for (int i = 0; i < k; ++i) {
            s = Dcolamd.t_add(s, a, ok);
        }
        return s;
    }

    private static int COLAMD_C(int n_col, int[] ok) {
        return Dcolamd.t_add(n_col, 1, ok);
    }

    private static int COLAMD_R(int n_row, int[] ok) {
        return Dcolamd.t_add(n_row, 1, ok);
    }

    public static int COLAMD_recommended(int nnz, int n_row, int n_col) {
        int[] ok = new int[]{1};
        if (nnz < 0 || n_row < 0 || n_col < 0) {
            return 0;
        }
        int s = Dcolamd.t_mult(nnz, 2, ok);
        s = Dcolamd.t_add(s, n_col, ok);
        ok[0] = (s = Dcolamd.t_add(s, nnz / 5, ok)) < Int_MAX ? 1 : 0;
        return ok[0] != 0 ? s : 0;
    }

    public static void COLAMD_set_defaults(double[] knobs) {
        if (knobs == null || knobs.length == 0) {
            return;
        }
        for (int i = 0; i < COLAMD_KNOBS; ++i) {
            knobs[i] = 0.0;
        }
        knobs[Dcolamd.COLAMD_DENSE_ROW] = 10.0;
        knobs[Dcolamd.COLAMD_DENSE_COL] = 10.0;
        knobs[Dcolamd.COLAMD_AGGRESSIVE] = 1.0;
    }

    public static int symamd(int n, int[] A, int[] p, int[] perm, double[] knobs, int[] stats) {
        int[] M;
        int pp;
        int j;
        int[] mark;
        int[] count;
        int i;
        double[] cknobs = new double[COLAMD_KNOBS];
        double[] default_knobs = new double[COLAMD_KNOBS];
        if (!NDEBUG) {
            // empty if block
        }
        if (stats == null) {
            Dcolamd.DEBUG0("symamd: stats not present\n", new Object[0]);
            return 0;
        }
        for (i = 0; i < COLAMD_STATS; ++i) {
            stats[i] = 0;
        }
        stats[Dcolamd.COLAMD_STATUS] = 0;
        stats[4] = -1;
        stats[5] = -1;
        if (A == null) {
            stats[Dcolamd.COLAMD_STATUS] = -1;
            Dcolamd.DEBUG0("symamd: A not present\n", new Object[0]);
            return 0;
        }
        if (p == null) {
            stats[Dcolamd.COLAMD_STATUS] = -2;
            Dcolamd.DEBUG0("symamd: p not present\n", new Object[0]);
            return 0;
        }
        if (n < 0) {
            stats[Dcolamd.COLAMD_STATUS] = -4;
            stats[4] = n;
            Dcolamd.DEBUG0("symamd: n negative %d\n", n);
            return 0;
        }
        int nnz = p[n];
        if (nnz < 0) {
            stats[Dcolamd.COLAMD_STATUS] = -5;
            stats[4] = nnz;
            Dcolamd.DEBUG0("symamd: number of entries negative %d\n", nnz);
            return 0;
        }
        if (p[0] != 0) {
            stats[Dcolamd.COLAMD_STATUS] = -6;
            stats[4] = p[0];
            Dcolamd.DEBUG0("symamd: p[0] not zero %d\n", p[0]);
            return 0;
        }
        if (knobs == null) {
            Dcolamd.COLAMD_set_defaults(default_knobs);
            knobs = default_knobs;
        }
        try {
            count = new int[n + 1];
        }
        catch (OutOfMemoryError e) {
            stats[Dcolamd.COLAMD_STATUS] = -10;
            Dcolamd.DEBUG0("symamd: allocate count (size %d) failed\n", n + 1);
            return 0;
        }
        try {
            mark = new int[n + 1];
        }
        catch (OutOfMemoryError e) {
            stats[Dcolamd.COLAMD_STATUS] = -10;
            count = null;
            Dcolamd.DEBUG0("symamd: allocate mark (size %d) failed\n", n + 1);
            return 0;
        }
        stats[6] = 0;
        for (i = 0; i < n; ++i) {
            mark[i] = -1;
        }
        for (j = 0; j < n; ++j) {
            int last_row = -1;
            int length = p[j + 1] - p[j];
            if (length < 0) {
                stats[Dcolamd.COLAMD_STATUS] = -8;
                stats[4] = j;
                stats[5] = length;
                count = null;
                mark = null;
                Dcolamd.DEBUG0("symamd: col %d negative length %d\n", j, length);
                return 0;
            }
            for (pp = p[j]; pp < p[j + 1]; ++pp) {
                i = A[pp];
                if (i < 0 || i >= n) {
                    stats[Dcolamd.COLAMD_STATUS] = -9;
                    stats[4] = j;
                    stats[5] = i;
                    stats[6] = n;
                    count = null;
                    mark = null;
                    Dcolamd.DEBUG0("symamd: row %d col %d out of bounds\n", i, j);
                    return 0;
                }
                if (i <= last_row || mark[i] == j) {
                    stats[Dcolamd.COLAMD_STATUS] = 1;
                    stats[4] = j;
                    stats[5] = i;
                    stats[6] = stats[6] + 1;
                    Dcolamd.DEBUG1("symamd: row %d col %d unsorted/duplicate\n", i, j);
                }
                if (i > j && mark[i] != j) {
                    int n2 = i;
                    count[n2] = count[n2] + 1;
                    int n3 = j;
                    count[n3] = count[n3] + 1;
                }
                mark[i] = j;
                last_row = i;
            }
        }
        perm[0] = 0;
        for (j = 1; j <= n; ++j) {
            perm[j] = perm[j - 1] + count[j - 1];
        }
        for (j = 0; j < n; ++j) {
            count[j] = perm[j];
        }
        int mnz = perm[n];
        int n_row = mnz / 2;
        int Mlen = Dcolamd.COLAMD_recommended(mnz, n_row, n);
        try {
            M = new int[Mlen];
            Dcolamd.DEBUG0("symamd: M is %d-by-%d with %d entries, Mlen = %d\n", n_row, n, mnz, Mlen);
        }
        catch (OutOfMemoryError e) {
            stats[Dcolamd.COLAMD_STATUS] = -10;
            count = null;
            mark = null;
            Dcolamd.DEBUG0("symamd: allocate M (size %g) failed\n", Mlen);
            return 0;
        }
        int k = 0;
        if (stats[COLAMD_STATUS] == 0) {
            for (j = 0; j < n; ++j) {
                Dcolamd.ASSERT(p[j + 1] - p[j] >= 0);
                for (pp = p[j]; pp < p[j + 1]; ++pp) {
                    i = A[pp];
                    Dcolamd.ASSERT(i >= 0 && i < n);
                    if (i <= j) continue;
                    int n4 = i;
                    int n5 = count[n4];
                    count[n4] = n5 + 1;
                    M[n5] = k;
                    int n6 = j;
                    int n7 = count[n6];
                    count[n6] = n7 + 1;
                    M[n7] = k++;
                }
            }
        } else {
            Dcolamd.DEBUG0("symamd: Duplicates in A.\n", new Object[0]);
            for (i = 0; i < n; ++i) {
                mark[i] = -1;
            }
            for (j = 0; j < n; ++j) {
                Dcolamd.ASSERT(p[j + 1] - p[j] >= 0);
                for (pp = p[j]; pp < p[j + 1]; ++pp) {
                    i = A[pp];
                    Dcolamd.ASSERT(i >= 0 && i < n);
                    if (i <= j || mark[i] == j) continue;
                    int n8 = i;
                    int n9 = count[n8];
                    count[n8] = n9 + 1;
                    M[n9] = k;
                    int n10 = j;
                    int n11 = count[n10];
                    count[n10] = n11 + 1;
                    M[n11] = k++;
                    mark[i] = j;
                }
            }
        }
        count = null;
        mark = null;
        Dcolamd.ASSERT(k == n_row);
        for (i = 0; i < COLAMD_KNOBS; ++i) {
            cknobs[i] = knobs[i];
        }
        cknobs[Dcolamd.COLAMD_DENSE_ROW] = -1.0;
        cknobs[Dcolamd.COLAMD_DENSE_COL] = knobs[COLAMD_DENSE_ROW];
        Dcolamd.colamd(n_row, n, Mlen, M, perm, cknobs, stats);
        stats[Dcolamd.COLAMD_DENSE_ROW] = stats[COLAMD_DENSE_COL];
        M = null;
        Dcolamd.DEBUG0("symamd: done.\n", new Object[0]);
        return 1;
    }

    public static int colamd(int n_row, int n_col, int Alen, int[] A, int[] p, double[] knobs, int[] stats) {
        int i;
        int[] n_col2 = new int[1];
        int[] n_row2 = new int[1];
        int[] max_deg = new int[1];
        double[] default_knobs = new double[COLAMD_KNOBS];
        if (!NDEBUG) {
            // empty if block
        }
        if (stats == null) {
            Dcolamd.DEBUG0("colamd: stats not present\n", new Object[0]);
            return 0;
        }
        for (i = 0; i < COLAMD_STATS; ++i) {
            stats[i] = 0;
        }
        stats[Dcolamd.COLAMD_STATUS] = 0;
        stats[4] = -1;
        stats[5] = -1;
        if (A == null) {
            stats[Dcolamd.COLAMD_STATUS] = -1;
            Dcolamd.DEBUG0("colamd: A not present\n", new Object[0]);
            return 0;
        }
        if (p == null) {
            stats[Dcolamd.COLAMD_STATUS] = -2;
            Dcolamd.DEBUG0("colamd: p not present\n", new Object[0]);
            return 0;
        }
        if (n_row < 0) {
            stats[Dcolamd.COLAMD_STATUS] = -3;
            stats[4] = n_row;
            Dcolamd.DEBUG0("colamd: nrow negative %d\n", n_row);
            return 0;
        }
        if (n_col < 0) {
            stats[Dcolamd.COLAMD_STATUS] = -4;
            stats[4] = n_col;
            Dcolamd.DEBUG0("colamd: ncol negative %d\n", n_col);
            return 0;
        }
        int nnz = p[n_col];
        if (nnz < 0) {
            stats[Dcolamd.COLAMD_STATUS] = -5;
            stats[4] = nnz;
            Dcolamd.DEBUG0("colamd: number of entries negative %d\n", nnz);
            return 0;
        }
        if (p[0] != 0) {
            stats[Dcolamd.COLAMD_STATUS] = -6;
            stats[4] = p[0];
            Dcolamd.DEBUG0("colamd: p[0] not zero %d\n", p[0]);
            return 0;
        }
        if (knobs == null) {
            Dcolamd.COLAMD_set_defaults(default_knobs);
            knobs = default_knobs;
        }
        int aggressive = knobs[COLAMD_AGGRESSIVE] != 0.0 ? 1 : 0;
        int[] ok = new int[]{1};
        int Col_size = Dcolamd.COLAMD_C(n_col, ok);
        int Row_size = Dcolamd.COLAMD_R(n_row, ok);
        int need = Dcolamd.t_mult(nnz, 2, ok);
        need = Dcolamd.t_add(need, n_col, ok);
        if (ok[0] == 0 || need > Alen || need > Int_MAX) {
            stats[Dcolamd.COLAMD_STATUS] = -7;
            stats[4] = need;
            stats[5] = Alen;
            Dcolamd.DEBUG0("colamd: Need Alen >= %d, given only Alen = %d\n", need, Alen);
            return 0;
        }
        Colamd_Col[] Col = new Colamd_Col[Col_size];
        Colamd_Row[] Row = new Colamd_Row[Row_size];
        for (i = 0; i < Col_size; ++i) {
            Col[i] = new Colamd_Col();
        }
        for (i = 0; i < Row_size; ++i) {
            Row[i] = new Colamd_Row();
        }
        if (Dcolamd.init_rows_cols(n_row, n_col, Row, Col, A, p, stats) == 0) {
            Dcolamd.DEBUG0("colamd: Matrix invalid\n", new Object[0]);
            return 0;
        }
        Dcolamd.init_scoring(n_row, n_col, Row, Col, A, p, knobs, n_row2, n_col2, max_deg);
        int ngarbage = Dcolamd.find_ordering(n_row, n_col, Alen, Row, Col, A, p, n_col2[0], max_deg[0], 2 * nnz, aggressive);
        Dcolamd.order_children(n_col, Col, p);
        stats[Dcolamd.COLAMD_DENSE_ROW] = n_row - n_row2[0];
        stats[Dcolamd.COLAMD_DENSE_COL] = n_col - n_col2[0];
        stats[Dcolamd.COLAMD_DEFRAG_COUNT] = ngarbage;
        Dcolamd.DEBUG0("colamd: done.\n", new Object[0]);
        return 1;
    }

    public static void COLAMD_report(int[] stats) {
        Dcolamd.print_report("colamd", stats);
    }

    public static void SYMAMD_report(int[] stats) {
        Dcolamd.print_report("symamd", stats);
    }

    private static int init_rows_cols(int n_row, int n_col, Colamd_Row[] Row, Colamd_Col[] Col, int[] A, int[] p, int[] stats) {
        int cp_end;
        int cp;
        int row;
        int col;
        for (col = 0; col < n_col; ++col) {
            Col[col].start = p[col];
            Col[col].length = p[col + 1] - p[col];
            if (Col[col].length < 0) {
                stats[Dcolamd.COLAMD_STATUS] = -8;
                stats[4] = col;
                stats[5] = Col[col].length;
                Dcolamd.DEBUG0("colamd: col %d length %d < 0\n", col, Col[col].length);
                return 0;
            }
            Col[col].thickness(1);
            Col[col].score(0);
            Col[col].prev(-1);
            Col[col].degree_next(-1);
        }
        stats[6] = 0;
        for (row = 0; row < n_row; ++row) {
            Row[row].length = 0;
            Row[row].mark(-1);
        }
        for (col = 0; col < n_col; ++col) {
            int last_row = -1;
            cp = p[col];
            cp_end = p[col + 1];
            while (cp < cp_end) {
                if ((row = A[cp++]) < 0 || row >= n_row) {
                    stats[Dcolamd.COLAMD_STATUS] = -9;
                    stats[4] = col;
                    stats[5] = row;
                    stats[6] = n_row;
                    Dcolamd.DEBUG0("colamd: row %d col %d out of bounds\n", row, col);
                    return 0;
                }
                if (row <= last_row || Row[row].mark() == col) {
                    stats[Dcolamd.COLAMD_STATUS] = 1;
                    stats[4] = col;
                    stats[5] = row;
                    stats[6] = stats[6] + 1;
                    Dcolamd.DEBUG1("colamd: row %d col %d unsorted/duplicate\n", row, col);
                }
                if (Row[row].mark() != col) {
                    ++Row[row].length;
                } else {
                    --Col[col].length;
                }
                Row[row].mark(col);
                last_row = row;
            }
        }
        Row[0].start = p[n_col];
        Row[0].p(Row[0].start);
        Row[0].mark(-1);
        for (row = 1; row < n_row; ++row) {
            Row[row].start = Row[row - 1].start + Row[row - 1].length;
            Row[row].p(Row[row].start);
            Row[row].mark(-1);
        }
        if (stats[COLAMD_STATUS] == 1) {
            for (col = 0; col < n_col; ++col) {
                cp = p[col];
                cp_end = p[col + 1];
                while (cp < cp_end) {
                    if (Row[row = A[cp++]].mark() == col) continue;
                    A[Row[row].p()] = col;
                    Row[row].p(Row[row].p() + 1);
                    Row[row].mark(col);
                }
            }
        } else {
            for (col = 0; col < n_col; ++col) {
                cp_end = p[col + 1];
                for (cp = p[col]; cp < cp_end; ++cp) {
                    A[Row[A[cp]].p()] = col;
                    Row[A[cp]].p(Row[A[cp]].p() + 1);
                }
            }
        }
        for (row = 0; row < n_row; ++row) {
            Row[row].mark(0);
            Row[row].degree(Row[row].length);
        }
        if (stats[COLAMD_STATUS] == 1) {
            int rp_end;
            int rp;
            Dcolamd.DEBUG0("colamd: reconstructing column form, matrix jumbled\n", new Object[0]);
            if (!NDEBUG) {
                for (col = 0; col < n_col; ++col) {
                    p[col] = Col[col].length;
                }
                for (row = 0; row < n_row; ++row) {
                    rp = Row[row].start;
                    rp_end = rp + Row[row].length;
                    while (rp < rp_end) {
                        int n = A[rp++];
                        p[n] = p[n] - 1;
                    }
                }
                for (col = 0; col < n_col; ++col) {
                    Dcolamd.ASSERT(p[col] == 0);
                }
            }
            p[0] = Col[0].start = 0;
            for (col = 1; col < n_col; ++col) {
                p[col] = Col[col].start = Col[col - 1].start + Col[col - 1].length;
            }
            for (row = 0; row < n_row; ++row) {
                rp = Row[row].start;
                rp_end = rp + Row[row].length;
                while (rp < rp_end) {
                    int n = A[rp++];
                    int n2 = p[n];
                    p[n] = n2 + 1;
                    A[n2] = row;
                }
            }
        }
        return 1;
    }

    private static void init_scoring(int n_row, int n_col, Colamd_Row[] Row, Colamd_Col[] Col, int[] A, int[] head, double[] knobs, int[] p_n_row2, int[] p_n_col2, int[] p_max_deg) {
        int score;
        int cp_end;
        int cp;
        int deg;
        int c;
        int debug_count = 0;
        int dense_row_count = knobs[COLAMD_DENSE_ROW] < 0.0 ? n_col - 1 : Dcolamd.DENSE_DEGREE(knobs[COLAMD_DENSE_ROW], n_col);
        int dense_col_count = knobs[COLAMD_DENSE_COL] < 0.0 ? n_row - 1 : Dcolamd.DENSE_DEGREE(knobs[COLAMD_DENSE_COL], Dcolamd.MIN(n_row, n_col));
        Dcolamd.DEBUG1("colamd: densecount: %d %d\n", dense_row_count, dense_col_count);
        int max_deg = 0;
        int n_col2 = n_col;
        int n_row2 = n_row;
        for (c = n_col - 1; c >= 0; --c) {
            deg = Col[c].length;
            if (deg != 0) continue;
            Col[c].order(--n_col2);
            Dcolamd.KILL_PRINCIPAL_COL(Col, c);
        }
        Dcolamd.DEBUG1("colamd: null columns killed: %d\n", n_col - n_col2);
        for (c = n_col - 1; c >= 0; --c) {
            if (Dcolamd.COL_IS_DEAD(Col, c) || (deg = Col[c].length) <= dense_col_count) continue;
            Col[c].order(--n_col2);
            cp_end = cp + Col[c].length;
            for (cp = Col[c].start; cp < cp_end; ++cp) {
                Row[A[cp]].degree(Row[A[cp]].degree() - 1);
            }
            Dcolamd.KILL_PRINCIPAL_COL(Col, c);
        }
        Dcolamd.DEBUG1("colamd: Dense and null columns killed: %d\n", n_col - n_col2);
        for (int r = 0; r < n_row; ++r) {
            deg = Row[r].degree();
            Dcolamd.ASSERT(deg >= 0 && deg <= n_col);
            if (deg > dense_row_count || deg == 0) {
                Dcolamd.KILL_ROW(Row, r);
                --n_row2;
                continue;
            }
            max_deg = Dcolamd.MAX(max_deg, deg);
        }
        Dcolamd.DEBUG1("colamd: Dense and null rows killed: %d\n", n_row - n_row2);
        for (c = n_col - 1; c >= 0; --c) {
            if (Dcolamd.COL_IS_DEAD(Col, c)) continue;
            score = 0;
            int new_cp = cp = Col[c].start;
            cp_end = cp + Col[c].length;
            while (cp < cp_end) {
                int row;
                if (Dcolamd.ROW_IS_DEAD(Row, row = A[cp++])) continue;
                A[new_cp++] = row;
                score += Row[row].degree() - 1;
                score = Dcolamd.MIN(score, n_col);
            }
            int col_length = new_cp - Col[c].start;
            if (col_length == 0) {
                Dcolamd.DEBUG2("Newly null killed: %d\n", c);
                Col[c].order(--n_col2);
                Dcolamd.KILL_PRINCIPAL_COL(Col, c);
                continue;
            }
            Dcolamd.ASSERT(score >= 0);
            Dcolamd.ASSERT(score <= n_col);
            Col[c].length = col_length;
            Col[c].score(score);
        }
        Dcolamd.DEBUG1("colamd: Dense, null, and newly-null columns killed: %d\n", n_col - n_col2);
        if (!NDEBUG) {
            Dcolamd.debug_structures(n_row, n_col, Row, Col, A, n_col2);
        }
        if (!NDEBUG) {
            debug_count = 0;
        }
        for (c = 0; c <= n_col; ++c) {
            head[c] = -1;
        }
        int min_score = n_col;
        for (c = n_col - 1; c >= 0; --c) {
            if (!Dcolamd.COL_IS_ALIVE(Col, c)) continue;
            Dcolamd.DEBUG4("place %d score %d minscore %d ncol %d\n", c, Col[c].score(), min_score, n_col);
            score = Col[c].score();
            Dcolamd.ASSERT(min_score >= 0);
            Dcolamd.ASSERT(min_score <= n_col);
            Dcolamd.ASSERT(score >= 0);
            Dcolamd.ASSERT(score <= n_col);
            Dcolamd.ASSERT(head[score] >= -1);
            int next_col = head[score];
            Col[c].prev(-1);
            Col[c].degree_next(next_col);
            if (next_col != -1) {
                Col[next_col].prev(c);
            }
            head[score] = c;
            min_score = Dcolamd.MIN(min_score, score);
            if (NDEBUG) continue;
            ++debug_count;
        }
        if (!NDEBUG) {
            Dcolamd.DEBUG1("colamd: Live cols %d out of %d, non-princ: %d\n", debug_count, n_col, n_col - debug_count);
            Dcolamd.ASSERT(debug_count == n_col2);
            Dcolamd.debug_deg_lists(n_row, n_col, Row, Col, head, min_score, n_col2, max_deg);
        }
        p_n_col2[0] = n_col2;
        p_n_row2[0] = n_row2;
        p_max_deg[0] = max_deg;
    }

    private static int find_ordering(int n_row, int n_col, int Alen, Colamd_Row[] Row, Colamd_Col[] Col, int[] A, int[] head, int n_col2, int max_deg, int pfree, int aggressive) {
        int debug_step = 0;
        int max_mark = Int_MAX - n_col;
        int tag_mark = Dcolamd.clear_mark(0, max_mark, n_row, Row);
        int min_score = 0;
        int ngarbage = 0;
        Dcolamd.DEBUG1("colamd: Ordering, n_col2=%d\n", n_col2);
        int k = 0;
        while (k < n_col2) {
            int row_mark;
            int cur_score;
            int pivot_row;
            int col;
            int col_thickness;
            int rp_end;
            int rp;
            int row;
            int next_col;
            if (!NDEBUG) {
                if (debug_step % 100 == 0) {
                    Dcolamd.DEBUG2("\n...       Step k: %d out of n_col2: %d\n", k, n_col2);
                } else {
                    Dcolamd.DEBUG3("\n----------Step k: %d out of n_col2: %d\n", k, n_col2);
                }
                ++debug_step;
                Dcolamd.debug_deg_lists(n_row, n_col, Row, Col, head, min_score, n_col2 - k, max_deg);
                Dcolamd.debug_matrix(n_row, n_col, Row, Col, A);
            }
            Dcolamd.ASSERT(min_score >= 0);
            Dcolamd.ASSERT(min_score <= n_col);
            Dcolamd.ASSERT(head[min_score] >= -1);
            if (!NDEBUG) {
                for (int debug_d = 0; debug_d < min_score; ++debug_d) {
                    Dcolamd.ASSERT(head[debug_d] == -1);
                }
            }
            while (head[min_score] == -1 && min_score < n_col) {
                ++min_score;
            }
            int pivot_col = head[min_score];
            Dcolamd.ASSERT(pivot_col >= 0 && pivot_col <= n_col);
            head[min_score] = next_col = Col[pivot_col].degree_next();
            if (next_col != -1) {
                Col[next_col].prev(-1);
            }
            Dcolamd.ASSERT(Dcolamd.COL_IS_ALIVE(Col, pivot_col));
            int pivot_col_score = Col[pivot_col].score();
            Col[pivot_col].order(k);
            int pivot_col_thickness = Col[pivot_col].thickness();
            Dcolamd.ASSERT(pivot_col_thickness > 0);
            Dcolamd.DEBUG3("Pivot col: %d thick %d\n", pivot_col, pivot_col_thickness);
            int needed_memory = Dcolamd.MIN(pivot_col_score, n_col - (k += pivot_col_thickness));
            if (pfree + needed_memory >= Alen) {
                pfree = Dcolamd.garbage_collection(n_row, n_col, Row, Col, A, pfree);
                ++ngarbage;
                Dcolamd.ASSERT(pfree + needed_memory < Alen);
                tag_mark = Dcolamd.clear_mark(0, max_mark, n_row, Row);
                if (!NDEBUG) {
                    Dcolamd.debug_matrix(n_row, n_col, Row, Col, A);
                }
            }
            int pivot_row_start = pfree;
            int pivot_row_degree = 0;
            Col[pivot_col].thickness(-pivot_col_thickness);
            int cp = Col[pivot_col].start;
            int cp_end = cp + Col[pivot_col].length;
            while (cp < cp_end) {
                row = A[cp++];
                Dcolamd.DEBUG4("Pivot col pattern %d %d\n", Dcolamd.ROW_IS_ALIVE(Row, row) ? 1 : 0, row);
                if (!Dcolamd.ROW_IS_ALIVE(Row, row)) continue;
                rp = Row[row].start;
                rp_end = rp + Row[row].length;
                while (rp < rp_end) {
                    if ((col_thickness = Col[col = A[rp++]].thickness()) <= 0 || !Dcolamd.COL_IS_ALIVE(Col, col)) continue;
                    Col[col].thickness(-col_thickness);
                    Dcolamd.ASSERT(pfree < Alen);
                    A[pfree++] = col;
                    pivot_row_degree += col_thickness;
                }
            }
            Col[pivot_col].thickness(pivot_col_thickness);
            max_deg = Dcolamd.MAX(max_deg, pivot_row_degree);
            if (!NDEBUG) {
                Dcolamd.DEBUG3("check2\n", new Object[0]);
                Dcolamd.debug_mark(n_row, Row, tag_mark, max_mark);
            }
            cp = Col[pivot_col].start;
            cp_end = cp + Col[pivot_col].length;
            while (cp < cp_end) {
                row = A[cp++];
                Dcolamd.DEBUG3("Kill row in pivot col: %d\n", row);
                Dcolamd.KILL_ROW(Row, row);
            }
            int pivot_row_length = pfree - pivot_row_start;
            if (pivot_row_length > 0) {
                pivot_row = A[Col[pivot_col].start];
                Dcolamd.DEBUG3("Pivotal row is %d\n", pivot_row);
            } else {
                pivot_row = -1;
                Dcolamd.ASSERT(pivot_row_length == 0);
            }
            Dcolamd.ASSERT(Col[pivot_col].length > 0 || pivot_row_length == 0);
            Dcolamd.DEBUG3("** Computing set differences phase. **\n", new Object[0]);
            Dcolamd.DEBUG3("Pivot row: ", new Object[0]);
            rp = pivot_row_start;
            rp_end = rp + pivot_row_length;
            while (rp < rp_end) {
                Dcolamd.ASSERT(Dcolamd.COL_IS_ALIVE(Col, col = A[rp++]) && col != pivot_col);
                Dcolamd.DEBUG3("Col: %d\n", col);
                col_thickness = -Col[col].thickness();
                Dcolamd.ASSERT(col_thickness > 0);
                Col[col].thickness(col_thickness);
                cur_score = Col[col].score();
                int prev_col = Col[col].prev();
                next_col = Col[col].degree_next();
                Dcolamd.ASSERT(cur_score >= 0);
                Dcolamd.ASSERT(cur_score <= n_col);
                Dcolamd.ASSERT(cur_score >= -1);
                if (prev_col == -1) {
                    head[cur_score] = next_col;
                } else {
                    Col[prev_col].degree_next(next_col);
                }
                if (next_col != -1) {
                    Col[next_col].prev(prev_col);
                }
                cp = Col[col].start;
                cp_end = cp + Col[col].length;
                while (cp < cp_end) {
                    if (Dcolamd.ROW_IS_MARKED_DEAD(row_mark = Row[row = A[cp++]].mark())) continue;
                    Dcolamd.ASSERT(row != pivot_row);
                    int set_difference = row_mark - tag_mark;
                    if (set_difference < 0) {
                        Dcolamd.ASSERT(Row[row].degree() <= max_deg);
                        set_difference = Row[row].degree();
                    }
                    Dcolamd.ASSERT((set_difference -= col_thickness) >= 0);
                    if (set_difference == 0 && aggressive != 0) {
                        Dcolamd.DEBUG3("aggressive absorption. Row: %d\n", row);
                        Dcolamd.KILL_ROW(Row, row);
                        continue;
                    }
                    Row[row].mark(set_difference + tag_mark);
                }
            }
            if (!NDEBUG) {
                Dcolamd.debug_deg_lists(n_row, n_col, Row, Col, head, min_score, n_col2 - k - pivot_row_degree, max_deg);
            }
            Dcolamd.DEBUG3("** Adding set differences phase. **\n", new Object[0]);
            rp = pivot_row_start;
            rp_end = rp + pivot_row_length;
            while (rp < rp_end) {
                int first_col;
                Dcolamd.ASSERT(Dcolamd.COL_IS_ALIVE(Col, col = A[rp++]) && col != pivot_col);
                int hash = 0;
                cur_score = 0;
                int new_cp = cp = Col[col].start;
                cp_end = cp + Col[col].length;
                Dcolamd.DEBUG4("Adding set diffs for Col: %d.\n", col);
                while (cp < cp_end) {
                    Dcolamd.ASSERT((row = A[cp++]) >= 0 && row < n_row);
                    row_mark = Row[row].mark();
                    if (Dcolamd.ROW_IS_MARKED_DEAD(row_mark)) {
                        Dcolamd.DEBUG4(" Row %d, dead\n", row);
                        continue;
                    }
                    Dcolamd.DEBUG4(" Row %d, set diff %d\n", row, row_mark - tag_mark);
                    Dcolamd.ASSERT(row_mark >= tag_mark);
                    A[new_cp++] = row;
                    hash += row;
                    cur_score += row_mark - tag_mark;
                    cur_score = Dcolamd.MIN(cur_score, n_col);
                }
                Col[col].length = new_cp - Col[col].start;
                if (Col[col].length == 0) {
                    Dcolamd.DEBUG4("further mass elimination. Col: %d\n", col);
                    Dcolamd.KILL_PRINCIPAL_COL(Col, col);
                    Dcolamd.ASSERT((pivot_row_degree -= Col[col].thickness()) >= 0);
                    Col[col].order(k);
                    k += Col[col].thickness();
                    continue;
                }
                Dcolamd.DEBUG4("Preparing supercol detection for Col: %d.\n", col);
                Col[col].score(cur_score);
                Dcolamd.DEBUG4(" Hash = %d, n_col = %d.\n", hash %= n_col + 1, n_col);
                Dcolamd.ASSERT(hash <= n_col);
                int head_column = head[hash];
                if (head_column > -1) {
                    first_col = Col[head_column].headhash();
                    Col[head_column].headhash(col);
                } else {
                    first_col = -(head_column + 2);
                    head[hash] = -(col + 2);
                }
                Col[col].hash_next(first_col);
                Col[col].hash(hash);
                Dcolamd.ASSERT(Dcolamd.COL_IS_ALIVE(Col, col));
            }
            Dcolamd.DEBUG3("** Supercolumn detection phase. **\n", new Object[0]);
            if (!NDEBUG) {
                Dcolamd.detect_super_cols(n_col, Row, Col, A, head, pivot_row_start, pivot_row_length);
            } else {
                Dcolamd.detect_super_cols(Col, A, head, pivot_row_start, pivot_row_length);
            }
            Dcolamd.KILL_PRINCIPAL_COL(Col, pivot_col);
            tag_mark = Dcolamd.clear_mark(tag_mark + max_deg + 1, max_mark, n_row, Row);
            if (!NDEBUG) {
                Dcolamd.DEBUG3("check3\n", new Object[0]);
                Dcolamd.debug_mark(n_row, Row, tag_mark, max_mark);
            }
            Dcolamd.DEBUG3("** Finalize scores phase. **\n", new Object[0]);
            int new_rp = rp = pivot_row_start;
            rp_end = rp + pivot_row_length;
            while (rp < rp_end) {
                if (Dcolamd.COL_IS_DEAD(Col, col = A[rp++])) continue;
                A[new_rp++] = col;
                A[Col[col].start + Col[col].length++] = pivot_row;
                cur_score = Col[col].score() + pivot_row_degree;
                int max_score = n_col - k - Col[col].thickness();
                cur_score -= Col[col].thickness();
                Dcolamd.ASSERT((cur_score = Dcolamd.MIN(cur_score, max_score)) >= 0);
                Col[col].score(cur_score);
                Dcolamd.ASSERT(min_score >= 0);
                Dcolamd.ASSERT(min_score <= n_col);
                Dcolamd.ASSERT(cur_score >= 0);
                Dcolamd.ASSERT(cur_score <= n_col);
                Dcolamd.ASSERT(head[cur_score] >= -1);
                next_col = head[cur_score];
                Col[col].degree_next(next_col);
                Col[col].prev(-1);
                if (next_col != -1) {
                    Col[next_col].prev(col);
                }
                head[cur_score] = col;
                min_score = Dcolamd.MIN(min_score, cur_score);
            }
            if (!NDEBUG) {
                Dcolamd.debug_deg_lists(n_row, n_col, Row, Col, head, min_score, n_col2 - k, max_deg);
            }
            if (pivot_row_degree <= 0) continue;
            Row[pivot_row].start = pivot_row_start;
            Row[pivot_row].length = new_rp - pivot_row_start;
            Dcolamd.ASSERT(Row[pivot_row].length > 0);
            Row[pivot_row].degree(pivot_row_degree);
            Row[pivot_row].mark(0);
            Dcolamd.DEBUG1("Resurrect Pivot_row %d deg: %d\n", pivot_row, pivot_row_degree);
        }
        return ngarbage;
    }

    private static void order_children(int n_col, Colamd_Col[] Col, int[] p) {
        int c;
        for (int i = 0; i < n_col; ++i) {
            Dcolamd.ASSERT(Dcolamd.COL_IS_DEAD(Col, i));
            if (Dcolamd.COL_IS_DEAD_PRINCIPAL(Col, i) || Col[i].order() != -1) continue;
            int parent = i;
            while (!Dcolamd.COL_IS_DEAD_PRINCIPAL(Col, parent = Col[parent].parent())) {
            }
            c = i;
            int order = Col[parent].order();
            do {
                Dcolamd.ASSERT(Col[c].order() == -1);
                Col[c].order(order++);
                Col[c].parent(parent);
            } while (Col[c = Col[c].parent()].order() == -1);
            Col[parent].order(order);
        }
        for (c = 0; c < n_col; ++c) {
            p[Col[c].order()] = c;
        }
    }

    private static void detect_super_cols(Colamd_Col[] Col, int[] A, int[] head, int row_start, int row_length) {
        Dcolamd.detect_super_cols(0, null, Col, A, head, row_start, row_length);
    }

    private static void detect_super_cols(int n_col, Colamd_Row[] Row, Colamd_Col[] Col, int[] A, int[] head, int row_start, int row_length) {
        int rp = row_start;
        int rp_end = rp + row_length;
        while (rp < rp_end) {
            int col;
            if (Dcolamd.COL_IS_DEAD(Col, col = A[rp++])) continue;
            int hash = Col[col].hash();
            Dcolamd.ASSERT(hash <= n_col);
            int head_column = head[hash];
            int first_col = head_column > -1 ? Col[head_column].headhash() : -(head_column + 2);
            int super_c = first_col;
            while (super_c != -1) {
                Dcolamd.ASSERT(Dcolamd.COL_IS_ALIVE(Col, super_c));
                Dcolamd.ASSERT(Col[super_c].hash() == hash);
                int length = Col[super_c].length;
                int prev_c = super_c;
                int c = Col[super_c].hash_next();
                while (c != -1) {
                    Dcolamd.ASSERT(c != super_c);
                    Dcolamd.ASSERT(Dcolamd.COL_IS_ALIVE(Col, c));
                    Dcolamd.ASSERT(Col[c].hash() == hash);
                    if (Col[c].length != length || Col[c].score() != Col[super_c].score()) {
                        prev_c = c;
                    } else {
                        int i;
                        int cp1 = Col[super_c].start;
                        int cp2 = Col[c].start;
                        for (i = 0; i < length; ++i) {
                            Dcolamd.ASSERT(Dcolamd.ROW_IS_ALIVE(Row, A[cp1]));
                            Dcolamd.ASSERT(Dcolamd.ROW_IS_ALIVE(Row, A[cp2]));
                            if (A[cp1++] != A[cp2++]) break;
                        }
                        if (i != length) {
                            prev_c = c;
                        } else {
                            Dcolamd.ASSERT(Col[c].score() == Col[super_c].score());
                            Col[super_c].thickness(Col[super_c].thickness() + Col[c].thickness());
                            Col[c].parent(super_c);
                            Dcolamd.KILL_NON_PRINCIPAL_COL(Col, c);
                            Col[c].order(-1);
                            Col[prev_c].hash_next(Col[c].hash_next());
                        }
                    }
                    c = Col[c].hash_next();
                }
                super_c = Col[super_c].hash_next();
            }
            if (head_column > -1) {
                Col[head_column].headhash(-1);
                continue;
            }
            head[hash] = -1;
        }
    }

    private static int garbage_collection(int n_row, int n_col, Colamd_Row[] Row, Colamd_Col[] Col, int[] A, int pfree) {
        int r;
        int j;
        int length;
        int c;
        int psrc;
        int debug_rows = 0;
        if (!NDEBUG) {
            Dcolamd.DEBUG2("Defrag..\n", new Object[0]);
            for (psrc = 0; psrc < pfree; ++psrc) {
                Dcolamd.ASSERT(A[psrc] >= 0);
            }
            debug_rows = 0;
        }
        int pdest = 0;
        for (c = 0; c < n_col; ++c) {
            if (!Dcolamd.COL_IS_ALIVE(Col, c)) continue;
            psrc = Col[c].start;
            Dcolamd.ASSERT(pdest <= psrc);
            Col[c].start = pdest - 0;
            length = Col[c].length;
            for (j = 0; j < length; ++j) {
                if (!Dcolamd.ROW_IS_ALIVE(Row, r = A[psrc++])) continue;
                A[pdest] = r;
            }
            Col[c].length = pdest - Col[c].start;
        }
        for (r = 0; r < n_row; ++r) {
            if (Dcolamd.ROW_IS_DEAD(Row, r) || Row[r].length == 0) {
                Dcolamd.KILL_ROW(Row, r);
                continue;
            }
            psrc = Row[r].start;
            Row[r].first_column(A[psrc]);
            Dcolamd.ASSERT(Dcolamd.ROW_IS_ALIVE(Row, r));
            A[psrc] = Dcolamd.ONES_COMPLEMENT(r);
            if (NDEBUG) continue;
            ++debug_rows;
        }
        psrc = pdest;
        while (psrc < pfree) {
            if (A[psrc++] >= 0) continue;
            Dcolamd.ASSERT((r = Dcolamd.ONES_COMPLEMENT(A[--psrc])) >= 0 && r < n_row);
            A[psrc] = Row[r].first_column();
            Dcolamd.ASSERT(Dcolamd.ROW_IS_ALIVE(Row, r));
            Dcolamd.ASSERT(Row[r].length > 0);
            Dcolamd.ASSERT(pdest <= psrc);
            Row[r].start = pdest - 0;
            length = Row[r].length;
            for (j = 0; j < length; ++j) {
                if (!Dcolamd.COL_IS_ALIVE(Col, c = A[psrc++])) continue;
                A[pdest++] = c;
            }
            Row[r].length = pdest - Row[r].start;
            Dcolamd.ASSERT(Row[r].length > 0);
            if (NDEBUG) continue;
            --debug_rows;
        }
        Dcolamd.ASSERT(debug_rows == 0);
        return pdest - 0;
    }

    private static int clear_mark(int tag_mark, int max_mark, int n_row, Colamd_Row[] Row) {
        if (tag_mark <= 0 || tag_mark >= max_mark) {
            for (int r = 0; r < n_row; ++r) {
                if (!Dcolamd.ROW_IS_ALIVE(Row, r)) continue;
                Row[r].mark(0);
            }
            tag_mark = 1;
        }
        return tag_mark;
    }

    private static void print_report(String method, int[] stats) {
        Dcolamd.PRINTF("\n%s version %d.%d, %s: ", method, COLAMD_MAIN_VERSION, COLAMD_SUB_VERSION, COLAMD_DATE);
        if (stats == null) {
            Dcolamd.PRINTF("No statistics available.\n", new Object[0]);
            return;
        }
        int i1 = stats[4];
        int i2 = stats[5];
        int i3 = stats[6];
        if (stats[COLAMD_STATUS] >= 0) {
            Dcolamd.PRINTF("OK.  ", new Object[0]);
        } else {
            Dcolamd.PRINTF("ERROR.  ", new Object[0]);
        }
        switch (stats[COLAMD_STATUS]) {
            case 1: {
                Dcolamd.PRINTF("Matrix has unsorted or duplicate row indices.\n", new Object[0]);
                Dcolamd.PRINTF("%s: number of duplicate or out-of-order row indices: %d\n", method, i3);
                Dcolamd.PRINTF("%s: last seen duplicate or out-of-order row index:   %d\n", method, Dcolamd.INDEX(i2));
                Dcolamd.PRINTF("%s: last seen in column:                             %d", method, Dcolamd.INDEX(i1));
            }
            case 0: {
                Dcolamd.PRINTF("\n", new Object[0]);
                Dcolamd.PRINTF("%s: number of dense or empty rows ignored:           %d\n", method, stats[COLAMD_DENSE_ROW]);
                Dcolamd.PRINTF("%s: number of dense or empty columns ignored:        %d\n", method, stats[COLAMD_DENSE_COL]);
                Dcolamd.PRINTF("%s: number of garbage collections performed:         %d\n", method, stats[COLAMD_DEFRAG_COUNT]);
                break;
            }
            case -1: {
                Dcolamd.PRINTF("Array A (row indices of matrix) not present.\n", new Object[0]);
                break;
            }
            case -2: {
                Dcolamd.PRINTF("Array p (column pointers for matrix) not present.\n", new Object[0]);
                break;
            }
            case -3: {
                Dcolamd.PRINTF("Invalid number of rows (%d).\n", i1);
                break;
            }
            case -4: {
                Dcolamd.PRINTF("Invalid number of columns (%d).\n", i1);
                break;
            }
            case -5: {
                Dcolamd.PRINTF("Invalid number of nonzero entries (%d).\n", i1);
                break;
            }
            case -6: {
                Dcolamd.PRINTF("Invalid column pointer, p [0] = %d, must be zero.\n", i1);
                break;
            }
            case -7: {
                Dcolamd.PRINTF("Array A too small.\n", new Object[0]);
                Dcolamd.PRINTF("        Need Alen >= %d, but given only Alen = %d.\n", i1, i2);
                break;
            }
            case -8: {
                Dcolamd.PRINTF("Column %d has a negative number of nonzero entries (%d).\n", Dcolamd.INDEX(i1), i2);
                break;
            }
            case -9: {
                Dcolamd.PRINTF("Row index (row %d) out of bounds (%d to %d) in column %d.\n", Dcolamd.INDEX(i2), Dcolamd.INDEX(0), Dcolamd.INDEX(i3 - 1), Dcolamd.INDEX(i1));
                break;
            }
            case -10: {
                Dcolamd.PRINTF("Out of memory.\n", new Object[0]);
            }
        }
    }

    private static void debug_structures(int n_row, int n_col, Colamd_Row[] Row, Colamd_Col[] Col, int[] A, int n_col2) {
        if (!NDEBUG) {
            int i;
            int r;
            int len;
            int c;
            for (c = 0; c < n_col; ++c) {
                if (Dcolamd.COL_IS_ALIVE(Col, c)) {
                    len = Col[c].length;
                    int score = Col[c].score();
                    Dcolamd.DEBUG4("initial live col %5d %5d %5d\n", c, len, score);
                    Dcolamd.ASSERT(len > 0);
                    Dcolamd.ASSERT(score >= 0);
                    Dcolamd.ASSERT(Col[c].thickness() == 1);
                    int cp = Col[c].start;
                    int cp_end = cp + len;
                    while (cp < cp_end) {
                        r = A[cp++];
                        Dcolamd.ASSERT(Dcolamd.ROW_IS_ALIVE(Row, r));
                    }
                    continue;
                }
                i = Col[c].order();
                Dcolamd.ASSERT(i >= n_col2 && i < n_col);
            }
            for (r = 0; r < n_row; ++r) {
                if (!Dcolamd.ROW_IS_ALIVE(Row, r)) continue;
                i = 0;
                len = Row[r].length;
                int deg = Row[r].degree();
                Dcolamd.ASSERT(len > 0);
                Dcolamd.ASSERT(deg > 0);
                int rp = Row[r].start;
                int rp_end = rp + len;
                while (rp < rp_end) {
                    if (!Dcolamd.COL_IS_ALIVE(Col, c = A[rp++])) continue;
                    ++i;
                }
                Dcolamd.ASSERT(i > 0);
            }
        }
    }

    private static void debug_deg_lists(int n_row, int n_col, Colamd_Row[] Row, Colamd_Col[] Col, int[] head, int min_score, int should, int max_deg) {
        if (!NDEBUG) {
            if (n_col > 10000 && colamd_debug <= 0) {
                return;
            }
            int have = 0;
            Dcolamd.DEBUG4("Degree lists: %d\n", min_score);
            for (int deg = 0; deg <= n_col; ++deg) {
                int col = head[deg];
                if (col == -1) continue;
                Dcolamd.DEBUG4("%d:", deg);
                while (col != -1) {
                    Dcolamd.DEBUG4(" %d", col);
                    have += Col[col].thickness();
                    Dcolamd.ASSERT(Dcolamd.COL_IS_ALIVE(Col, col));
                    col = Col[col].degree_next();
                }
                Dcolamd.DEBUG4("\n", new Object[0]);
            }
            Dcolamd.DEBUG4("should %d have %d\n", should, have);
            Dcolamd.ASSERT(should == have);
            if (n_row > 10000 && colamd_debug <= 0) {
                return;
            }
            for (int row = 0; row < n_row; ++row) {
                if (!Dcolamd.ROW_IS_ALIVE(Row, row)) continue;
                Dcolamd.ASSERT(Row[row].degree() <= max_deg);
            }
        }
    }

    private static void debug_mark(int n_row, Colamd_Row[] Row, int tag_mark, int max_mark) {
        if (!NDEBUG) {
            Dcolamd.ASSERT(tag_mark > 0 && tag_mark <= max_mark);
            if (n_row > 10000 && colamd_debug <= 0) {
                return;
            }
            for (int r = 0; r < n_row; ++r) {
                Dcolamd.ASSERT(Row[r].mark() < tag_mark);
            }
        }
    }

    private static void debug_matrix(int n_row, int n_col, Colamd_Row[] Row, Colamd_Col[] Col, int[] A) {
        if (!NDEBUG) {
            int c;
            int r;
            if (colamd_debug < 3) {
                return;
            }
            Dcolamd.DEBUG3("DUMP MATRIX:\n", new Object[0]);
            for (r = 0; r < n_row; ++r) {
                Dcolamd.DEBUG3("Row %d alive? %d\n", r, Dcolamd.ROW_IS_ALIVE(Row, r) ? 1 : 0);
                if (Dcolamd.ROW_IS_DEAD(Row, r)) continue;
                Dcolamd.DEBUG3("start %d length %d degree %d\n", Row[r].start, Row[r].length, Row[r].degree());
                int rp = Row[r].start;
                int rp_end = rp + Row[r].length;
                while (rp < rp_end) {
                    c = A[rp++];
                    Dcolamd.DEBUG4("\t%d col %d\n", Dcolamd.COL_IS_ALIVE(Col, c) ? 1 : 0, c);
                }
            }
            for (c = 0; c < n_col; ++c) {
                Dcolamd.DEBUG3("Col %d alive? %d\n", c, Dcolamd.COL_IS_ALIVE(Col, c) ? 1 : 0);
                if (Dcolamd.COL_IS_DEAD(Col, c)) continue;
                Dcolamd.DEBUG3("start %d length %d shared1 %d shared2 %d\n", Col[c].start, Col[c].length, Col[c].thickness(), Col[c].score());
                int cp = Col[c].start;
                int cp_end = cp + Col[c].length;
                while (cp < cp_end) {
                    r = A[cp++];
                    Dcolamd.DEBUG4("\t%d row %d\n", Dcolamd.ROW_IS_ALIVE(Row, r) ? 1 : 0, r);
                }
            }
        }
    }

    private static void colamd_get_debug(String method) {
        if (!NDEBUG) {
            colamd_debug = 0;
            File f = new File("debug");
            if (!f.exists()) {
                colamd_debug = 0;
            } else {
                try {
                    FileReader fr = new FileReader(f);
                    BufferedReader br = new BufferedReader(fr);
                    colamd_debug = Integer.valueOf(br.readLine());
                    br.close();
                    fr.close();
                }
                catch (IOException e) {
                    Dcolamd.PRINTF("%s: AMD_debug_init, error reading debug.amd file", method);
                }
            }
            Dcolamd.DEBUG0("%s: debug version, D = %d (THIS WILL BE SLOW!)\n", method, colamd_debug);
        }
    }
}

