/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.csparsej.tdouble;

import edu.emory.mathcs.csparsej.tdouble.Dcs_common;
import edu.emory.mathcs.csparsej.tdouble.Dcs_spsolve;
import edu.emory.mathcs.csparsej.tdouble.Dcs_util;

public class Dcs_lu {
    public static Dcs_common.Dcsn cs_lu(Dcs_common.Dcs A, Dcs_common.Dcss S, double tol) {
        int p;
        int[] Li;
        int k;
        int i;
        Dcs_common.Dcs U;
        Dcs_common.Dcs L;
        if (!Dcs_util.CS_CSC(A) || S == null) {
            return null;
        }
        int n = A.n;
        int[] q = S.q;
        int lnz = S.lnz;
        int unz = S.unz;
        double[] x = new double[n];
        int[] xi = new int[2 * n];
        Dcs_common.Dcsn N = new Dcs_common.Dcsn();
        N.L = L = Dcs_util.cs_spalloc(n, n, lnz, true, false);
        N.U = U = Dcs_util.cs_spalloc(n, n, unz, true, false);
        int[] pinv = new int[n];
        N.pinv = pinv;
        int[] Lp = L.p;
        int[] Up = U.p;
        for (i = 0; i < n; ++i) {
            x[i] = 0.0;
        }
        for (i = 0; i < n; ++i) {
            pinv[i] = -1;
        }
        for (k = 0; k <= n; ++k) {
            Lp[k] = 0;
        }
        unz = 0;
        lnz = 0;
        for (k = 0; k < n; ++k) {
            Lp[k] = lnz;
            Up[k] = unz;
            if (lnz + n > L.nzmax) {
                Dcs_util.cs_sprealloc(L, 2 * L.nzmax + n);
            }
            if (unz + n > U.nzmax) {
                Dcs_util.cs_sprealloc(U, 2 * U.nzmax + n);
            }
            Li = L.i;
            double[] Lx = L.x;
            int[] Ui = U.i;
            double[] Ux = U.x;
            int col = q != null ? q[k] : k;
            int top = Dcs_spsolve.cs_spsolve(L, A, col, xi, x, pinv, true);
            int ipiv = -1;
            double a = -1.0;
            for (p = top; p < n; ++p) {
                i = xi[p];
                if (pinv[i] < 0) {
                    double d;
                    double t = Math.abs(x[i]);
                    if (!(d > a)) continue;
                    a = t;
                    ipiv = i;
                    continue;
                }
                Ui[unz] = pinv[i];
                Ux[unz++] = x[i];
            }
            if (ipiv == -1 || a <= 0.0) {
                return null;
            }
            if (pinv[col] < 0 && Math.abs(x[col]) >= a * tol) {
                ipiv = col;
            }
            double pivot = x[ipiv];
            Ui[unz] = k;
            Ux[unz++] = pivot;
            pinv[ipiv] = k;
            Li[lnz] = ipiv;
            Lx[lnz++] = 1.0;
            for (p = top; p < n; ++p) {
                i = xi[p];
                if (pinv[i] < 0) {
                    Li[lnz] = i;
                    Lx[lnz++] = x[i] / pivot;
                }
                x[i] = 0.0;
            }
        }
        Lp[n] = lnz;
        Up[n] = unz;
        Li = L.i;
        for (p = 0; p < lnz; ++p) {
            Li[p] = pinv[Li[p]];
        }
        Dcs_util.cs_sprealloc(L, 0);
        Dcs_util.cs_sprealloc(U, 0);
        return N;
    }
}

