/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.AccessAnyD;
import org.ojalgo.access.AccessUtils;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.BasicArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;

public final class ArrayAnyD<N extends Number>
implements AccessAnyD<N>,
AccessAnyD.Elements,
AccessAnyD.IndexOf,
AccessAnyD.Fillable<N>,
AccessAnyD.Modifiable<N>,
AccessAnyD.Visitable<N>,
AccessAnyD.Sliceable<N>,
Serializable {
    public static final Factory<BigDecimal> BIG = new Factory<BigDecimal>(){

        @Override
        BasicArray.BasicFactory<BigDecimal> delegate() {
            return BasicArray.BIG;
        }
    };
    public static final Factory<ComplexNumber> COMPLEX = new Factory<ComplexNumber>(){

        @Override
        BasicArray.BasicFactory<ComplexNumber> delegate() {
            return BasicArray.COMPLEX;
        }
    };
    public static final Factory<Double> PRIMITIVE = new Factory<Double>(){

        @Override
        public ArrayAnyD<Double> copy(AccessAnyD<?> source) {
            long[] tmpStructure = source.shape();
            BasicArray<Double> tmpDelegate = this.delegate().makeToBeFilled(tmpStructure);
            long tmpCount = source.count();
            for (long index = 0L; index < tmpCount; ++index) {
                tmpDelegate.set(index, source.doubleValue(index));
            }
            return tmpDelegate.asArrayAnyD(tmpStructure);
        }

        @Override
        BasicArray.BasicFactory<Double> delegate() {
            return BasicArray.PRIMITIVE;
        }
    };
    public static final Factory<Quaternion> QUATERNION = new Factory<Quaternion>(){

        @Override
        BasicArray.BasicFactory<Quaternion> delegate() {
            return BasicArray.QUATERNION;
        }
    };
    public static final Factory<RationalNumber> RATIONAL = new Factory<RationalNumber>(){

        @Override
        BasicArray.BasicFactory<RationalNumber> delegate() {
            return BasicArray.RATIONAL;
        }
    };
    private final BasicArray<N> myDelegate;
    private final long[] myStructure;

    private ArrayAnyD() {
        this(null, new long[0]);
    }

    ArrayAnyD(BasicArray<N> delegate, long[] structure) {
        this.myDelegate = delegate;
        this.myStructure = structure;
    }

    @Override
    public void add(long index, double addend) {
        this.myDelegate.add(index, addend);
    }

    @Override
    public void add(long index, Number addend) {
        this.myDelegate.add(index, addend);
    }

    @Override
    public void add(long[] reference, double addend) {
        this.myDelegate.add(AccessUtils.index(this.myStructure, reference), addend);
    }

    @Override
    public void add(long[] reference, Number addend) {
        this.myDelegate.add(AccessUtils.index(this.myStructure, reference), addend);
    }

    @Deprecated
    public Array1D<N> asArray1D() {
        return this.myDelegate.asArray1D();
    }

    @Override
    public long count() {
        return this.myDelegate.count();
    }

    @Override
    public long count(int dimension) {
        return AccessUtils.count(this.myStructure, dimension);
    }

    @Override
    public double doubleValue(long index) {
        return this.myDelegate.doubleValue(index);
    }

    @Override
    public double doubleValue(long[] reference) {
        return this.myDelegate.doubleValue(AccessUtils.index(this.myStructure, reference));
    }

    public boolean equals(Object obj) {
        if (obj instanceof ArrayAnyD) {
            ArrayAnyD tmpObj = (ArrayAnyD)obj;
            return Arrays.equals(this.myStructure, tmpObj.shape()) && this.myDelegate.equals(tmpObj.getDelegate());
        }
        return super.equals(obj);
    }

    @Override
    public void fillAll(N value) {
        this.myDelegate.fill(0L, this.count(), 1L, value);
    }

    @Override
    public void fillAll(NullaryFunction<N> supplier) {
        this.myDelegate.fill(0L, this.count(), 1L, supplier);
    }

    @Override
    public void fillOne(long index, N value) {
        this.myDelegate.fillOne(index, value);
    }

    @Override
    public void fillOne(long index, NullaryFunction<N> supplier) {
        this.myDelegate.fillOne(index, supplier);
    }

    @Override
    public void fillOne(long[] reference, N value) {
        this.myDelegate.fillOne(AccessUtils.index(this.myStructure, reference), value);
    }

    @Override
    public void fillOne(long[] reference, NullaryFunction<N> supplier) {
        this.myDelegate.fillOne(AccessUtils.index(this.myStructure, reference), supplier);
    }

    @Override
    public void fillOneMatching(long index, Access1D<?> values, long valueIndex) {
        this.myDelegate.fillOneMatching(index, values, valueIndex);
    }

    @Override
    public void fillRange(long first, long limit, N value) {
        this.myDelegate.fill(first, limit, 1L, value);
    }

    @Override
    public void fillRange(long first, long limit, NullaryFunction<N> supplier) {
        this.myDelegate.fill(first, limit, 1L, supplier);
    }

    public void fillSet(long[] first, int dimension, N number) {
        long tmpCount = AccessUtils.count(this.myStructure, dimension) - first[dimension];
        long tmpFirst = AccessUtils.index(this.myStructure, first);
        long tmpStep = AccessUtils.step(this.myStructure, dimension);
        long tmpLimit = tmpFirst + tmpStep * tmpCount;
        this.myDelegate.fill(tmpFirst, tmpLimit, tmpStep, number);
    }

    @Override
    public N get(long index) {
        return this.myDelegate.get(index);
    }

    @Override
    public N get(long[] reference) {
        return this.myDelegate.get(AccessUtils.index(this.myStructure, reference));
    }

    public int hashCode() {
        return this.myDelegate.hashCode();
    }

    @Override
    public boolean isAbsolute(long index) {
        return this.myDelegate.isAbsolute(index);
    }

    @Override
    public boolean isAbsolute(long[] reference) {
        return this.myDelegate.isAbsolute(AccessUtils.index(this.myStructure, reference));
    }

    @Deprecated
    public boolean isAllZeros() {
        return this.myDelegate.isSmall(0L, this.myDelegate.count(), 1L, PrimitiveMath.ONE);
    }

    @Override
    public boolean isSmall(long index, double comparedTo) {
        return this.myDelegate.isSmall(index, comparedTo);
    }

    @Override
    public boolean isSmall(long[] reference, double comparedTo) {
        return this.myDelegate.isSmall(AccessUtils.index(this.myStructure, reference), comparedTo);
    }

    @Deprecated
    public boolean isZeros(long[] first, int dimension) {
        long tmpCount = AccessUtils.count(this.myStructure, dimension) - first[dimension];
        long tmpFirst = AccessUtils.index(this.myStructure, first);
        long tmpStep = AccessUtils.step(this.myStructure, dimension);
        long tmpLimit = tmpFirst + tmpStep * tmpCount;
        return this.myDelegate.isSmall(tmpFirst, tmpLimit, tmpStep, PrimitiveMath.ONE);
    }

    @Override
    public void modifyAll(UnaryFunction<N> function) {
        this.myDelegate.modify(0L, this.count(), 1L, function);
    }

    @Override
    public void modifyMatching(Access1D<N> left, BinaryFunction<N> function) {
        this.myDelegate.modify(0L, this.count(), 1L, left, function);
    }

    @Override
    public void modifyMatching(BinaryFunction<N> function, Access1D<N> right) {
        this.myDelegate.modify(0L, this.count(), 1L, function, right);
    }

    @Override
    public void modifyOne(long index, UnaryFunction<N> function) {
        this.myDelegate.modifyOne(index, function);
    }

    @Override
    public void modifyOne(long[] reference, UnaryFunction<N> function) {
        this.myDelegate.modifyOne(AccessUtils.index(this.myStructure, reference), function);
    }

    @Override
    public void modifyRange(long first, long limit, UnaryFunction<N> function) {
        this.myDelegate.modify(first, limit, 1L, function);
    }

    public void modifySet(long[] first, int dimension, UnaryFunction<N> function) {
        long tmpCount = AccessUtils.count(this.myStructure, dimension) - first[dimension];
        long tmpFirst = AccessUtils.index(this.myStructure, first);
        long tmpStep = AccessUtils.step(this.myStructure, dimension);
        long tmpLimit = tmpFirst + tmpStep * tmpCount;
        this.myDelegate.modify(tmpFirst, tmpLimit, tmpStep, function);
    }

    public int rank() {
        return this.myStructure.length;
    }

    @Override
    public void set(long index, double value) {
        this.myDelegate.set(index, value);
    }

    @Override
    public void set(long index, Number value) {
        this.myDelegate.set(index, value);
    }

    @Override
    public void set(long[] reference, double value) {
        this.myDelegate.set(AccessUtils.index(this.myStructure, reference), value);
    }

    @Override
    public void set(long[] reference, Number value) {
        this.myDelegate.set(AccessUtils.index(this.myStructure, reference), value);
    }

    @Override
    public long[] shape() {
        return this.myStructure;
    }

    @Override
    public Array1D<N> slice(long[] first, int dimension) {
        long tmpCount = AccessUtils.count(this.myStructure, dimension) - first[dimension];
        long tmpFirst = AccessUtils.index(this.myStructure, first);
        long tmpStep = AccessUtils.step(this.myStructure, dimension);
        long tmpLimit = tmpFirst + tmpStep * tmpCount;
        return new Array1D<N>(this.myDelegate, tmpFirst, tmpLimit, tmpStep);
    }

    @Override
    public Array1D<N> sliceRange(long first, long limit) {
        return this.myDelegate.asArray1D().sliceRange(first, limit);
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder();
        retVal.append('<');
        retVal.append(this.myStructure[0]);
        for (int i = 1; i < this.myStructure.length; ++i) {
            retVal.append('x');
            retVal.append(this.myStructure[i]);
        }
        retVal.append('>');
        int tmpLength = (int)this.count();
        if (tmpLength >= 1 && tmpLength <= 100) {
            retVal.append(' ');
            retVal.append(this.myDelegate.toString());
        }
        return retVal.toString();
    }

    @Override
    public void visitAll(VoidFunction<N> visitor) {
        this.myDelegate.visit(0L, this.count(), 1L, visitor);
    }

    @Override
    public void visitOne(long index, VoidFunction<N> visitor) {
        this.myDelegate.visitOne(index, visitor);
    }

    @Override
    public void visitOne(long[] reference, VoidFunction<N> visitor) {
        this.myDelegate.visitOne(AccessUtils.index(this.myStructure, reference), visitor);
    }

    @Override
    public void visitRange(long first, long limit, VoidFunction<N> visitor) {
        this.myDelegate.visit(first, limit, 1L, visitor);
    }

    public void visitSet(long[] first, int dimension, VoidFunction<N> visitor) {
        long tmpCount = AccessUtils.count(this.myStructure, dimension) - first[dimension];
        long tmpFirst = AccessUtils.index(this.myStructure, first);
        long tmpStep = AccessUtils.step(this.myStructure, dimension);
        long tmpLimit = tmpFirst + tmpStep * tmpCount;
        this.myDelegate.visit(tmpFirst, tmpLimit, tmpStep, visitor);
    }

    final BasicArray<N> getDelegate() {
        return this.myDelegate;
    }

    @Override
    public long indexOfLargest() {
        return this.myDelegate.indexOfLargest();
    }

    @Override
    public long indexOfLargestInRange(long first, long limit) {
        return this.myDelegate.indexOfLargestInRange(first, limit);
    }

    public static abstract class Factory<N extends Number>
    implements AccessAnyD.Factory<ArrayAnyD<N>> {
        @Override
        public ArrayAnyD<N> copy(AccessAnyD<?> source) {
            long[] tmpStructure = source.shape();
            BasicArray<N> tmpDelegate = this.delegate().makeToBeFilled(tmpStructure);
            long tmpCount = source.count();
            for (long index = 0L; index < tmpCount; ++index) {
                tmpDelegate.set(index, (Number)source.get(index));
            }
            return tmpDelegate.asArrayAnyD(tmpStructure);
        }

        @Override
        public final ArrayAnyD<N> makeFilled(long[] structure, NullaryFunction<?> supplier) {
            BasicArray<N> tmpDelegate = this.delegate().makeToBeFilled(structure);
            long tmpCount = AccessUtils.count(structure);
            for (long index = 0L; index < tmpCount; ++index) {
                tmpDelegate.set(index, (Number)supplier.get());
            }
            return tmpDelegate.asArrayAnyD(structure);
        }

        @Override
        public final ArrayAnyD<N> makeZero(long ... structure) {
            return this.delegate().makeStructuredZero(structure).asArrayAnyD(structure);
        }

        abstract BasicArray.BasicFactory<N> delegate();
    }
}

