/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.math.BigDecimal;
import java.util.Arrays;
import org.ojalgo.access.Access1D;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.ReferenceTypeArray;
import org.ojalgo.array.SegmentedArray;
import org.ojalgo.constant.BigMath;
import org.ojalgo.function.FunctionUtils;
import org.ojalgo.machine.MemoryEstimator;
import org.ojalgo.scalar.BigScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.TypeUtils;

public class BigArray
extends ReferenceTypeArray<BigDecimal> {
    static final long ELEMENT_SIZE = MemoryEstimator.estimateObject(BigDecimal.class);
    static final DenseArray.DenseFactory<BigDecimal> FACTORY = new DenseArray.DenseFactory<BigDecimal>(){

        @Override
        long getElementSize() {
            return ELEMENT_SIZE;
        }

        @Override
        DenseArray<BigDecimal> make(int size) {
            return BigArray.make(size);
        }

        @Override
        Scalar<BigDecimal> zero() {
            return BigScalar.ZERO;
        }
    };

    public static final BigArray make(int size) {
        return new BigArray(size);
    }

    public static final SegmentedArray<BigDecimal> makeSegmented(long count) {
        return SegmentedArray.make(FACTORY, count);
    }

    public static final BigArray wrap(BigDecimal[] data) {
        return new BigArray(data);
    }

    protected BigArray(BigDecimal[] data) {
        super((Number[])data);
    }

    protected BigArray(int size) {
        super((Number[])new BigDecimal[size]);
        this.fill(0, size, 1, BigMath.ZERO);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof BigArray) {
            return Arrays.equals(this.data, ((BigArray)other).data);
        }
        return super.equals(other);
    }

    @Override
    public final void fillMatching(Access1D<?> values) {
        int tmpLimit = (int)FunctionUtils.min(this.count(), values.count());
        for (int i = 0; i < tmpLimit; ++i) {
            ((BigDecimal[])this.data)[i] = TypeUtils.toBigDecimal(values.get(i));
        }
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    @Override
    protected final void add(int index, double addend) {
        this.fillOne(index, ((BigDecimal)this.get(index)).add(this.valueOf(addend)));
    }

    @Override
    protected final void add(int index, Number addend) {
        this.fillOne(index, ((BigDecimal)this.get(index)).add(this.valueOf(addend)));
    }

    @Override
    protected int indexOfLargest(int first, int limit, int step) {
        int retVal = first;
        BigDecimal tmpLargest = BigMath.ZERO;
        for (int i = first; i < limit; i += step) {
            BigDecimal tmpValue = ((BigDecimal[])this.data)[i].abs();
            if (tmpValue.compareTo(tmpLargest) != 1) continue;
            tmpLargest = tmpValue;
            retVal = i;
        }
        return retVal;
    }

    @Override
    protected boolean isAbsolute(int index) {
        return BigScalar.isAbsolute(((BigDecimal[])this.data)[index]);
    }

    @Override
    protected boolean isSmall(int index, double comparedTo) {
        return BigScalar.isSmall(comparedTo, ((BigDecimal[])this.data)[index]);
    }

    @Override
    DenseArray<BigDecimal> newInstance(int capacity) {
        return new BigArray(capacity);
    }

    @Override
    BigDecimal valueOf(double value) {
        return BigDecimal.valueOf(value);
    }

    @Override
    BigDecimal valueOf(Number number) {
        return TypeUtils.toBigDecimal(number);
    }
}

