/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.finance.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.ojalgo.finance.data.DataSource;
import org.ojalgo.series.CalendarDateSeries;
import org.ojalgo.type.CalendarDate;
import org.ojalgo.type.CalendarDateUnit;

public final class SourceCache {
    private static final Timer TIMER = new Timer("SourceCache-Daemon", true);
    private final Map<DataSource<?>, Value> myCache = Collections.synchronizedMap(new HashMap());
    private final CalendarDateUnit myResolution;

    public SourceCache(CalendarDateUnit aResolution) {
        this.myResolution = aResolution;
        TIMER.schedule(new TimerTask(){

            @Override
            public void run() {
                SourceCache.this.cleanUp();
            }
        }, 0L, aResolution.size());
    }

    public synchronized CalendarDateSeries<Double> get(DataSource<?> key) {
        CalendarDate tmpNow = new CalendarDate();
        Value tmpValue = this.myCache.get(key);
        if (tmpValue != null) {
            if (this.myResolution.count(tmpValue.updated.millis, tmpNow.millis) > 0L) {
                this.update(tmpValue, key, tmpNow);
            }
        } else {
            tmpValue = new Value(key.getSymbol(), this.myResolution);
            this.myCache.put(key, tmpValue);
            this.update(tmpValue, key, tmpNow);
        }
        tmpValue.used = tmpNow;
        return tmpValue.series;
    }

    private void cleanUp() {
        CalendarDate tmpNow = new CalendarDate();
        for (Map.Entry<DataSource<?>, Value> tmpEntry : this.myCache.entrySet()) {
            if (this.myResolution.count(tmpEntry.getValue().used.millis, tmpNow.millis) <= 1L) continue;
            tmpEntry.getValue().series.clear();
            this.myCache.remove(tmpEntry.getKey());
        }
    }

    private void update(Value aCacheValue, DataSource<?> key, CalendarDate now) {
        aCacheValue.series.putAll((Map<CalendarDate, Double>)key.getPriceSeries());
        aCacheValue.updated = now;
    }

    private static final class Value {
        CalendarDate used = new CalendarDate();
        final CalendarDateSeries<Double> series;
        CalendarDate updated = new CalendarDate();

        private Value() {
            this(null, null);
        }

        Value(String name, CalendarDateUnit resolution) {
            this.series = new CalendarDateSeries(resolution);
            this.series.name(name);
        }
    }
}

