/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.finance.portfolio;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import org.ojalgo.constant.BigMath;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.finance.portfolio.FinancePortfolio;
import org.ojalgo.type.TypeUtils;

public final class SimpleAsset
extends FinancePortfolio {
    private final double myMeanReturn;
    private final double myVolatility;
    private final BigDecimal myWeight;

    public SimpleAsset(FinancePortfolio aPortfolio) {
        this(aPortfolio.getMeanReturn(), aPortfolio.getVolatility(), BigMath.ONE);
    }

    public SimpleAsset(FinancePortfolio aPortfolio, Number aWeight) {
        this(aPortfolio.getMeanReturn(), aPortfolio.getVolatility(), aWeight);
    }

    public SimpleAsset(Number aWeight) {
        this(PrimitiveMath.ZERO, PrimitiveMath.ZERO, aWeight);
    }

    public SimpleAsset(Number aMeanReturn, Number aVolatility) {
        this(aMeanReturn, aVolatility, BigMath.ONE);
    }

    public SimpleAsset(Number aMeanReturn, Number aVolatility, Number aWeight) {
        this.myMeanReturn = aMeanReturn.doubleValue();
        this.myVolatility = aVolatility.doubleValue();
        this.myWeight = TypeUtils.toBigDecimal(aWeight, WEIGHT_CONTEXT);
    }

    private SimpleAsset() {
        this(BigMath.ZERO, BigMath.ZERO, BigMath.ONE);
    }

    @Override
    public double getMeanReturn() {
        return this.myMeanReturn;
    }

    @Override
    public double getVolatility() {
        return this.myVolatility;
    }

    public BigDecimal getWeight() {
        return this.myWeight;
    }

    @Override
    public List<BigDecimal> getWeights() {
        return Collections.singletonList(this.myWeight);
    }

    @Override
    protected void reset() {
    }
}

