/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.finance.portfolio.simulator;

import java.math.BigDecimal;
import java.util.List;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.array.PrimitiveArray;
import org.ojalgo.finance.portfolio.SimplePortfolio;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.random.process.GeometricBrownian1D;
import org.ojalgo.random.process.GeometricBrownianMotion;
import org.ojalgo.random.process.RandomProcess;

public class PortfolioSimulator {
    private GeometricBrownian1D myProcess;

    public PortfolioSimulator(Access2D<?> correlations, List<GeometricBrownianMotion> assetProcesses) {
        if (assetProcesses == null || assetProcesses.size() < 1) {
            throw new IllegalArgumentException();
        }
        this.myProcess = correlations != null ? new GeometricBrownian1D(correlations, (List<? extends GeometricBrownianMotion>)assetProcesses) : new GeometricBrownian1D((List<? extends GeometricBrownianMotion>)assetProcesses);
    }

    private PortfolioSimulator() {
    }

    public RandomProcess.SimulationResults simulate(int aNumberOfRealisations, int aNumberOfSteps, double aStepSize) {
        return this.simulate(aNumberOfRealisations, aNumberOfSteps, aStepSize, null);
    }

    public RandomProcess.SimulationResults simulate(int aNumberOfRealisations, int aNumberOfSteps, double aStepSize, int rebalancingInterval) {
        return this.simulate(aNumberOfRealisations, aNumberOfSteps, aStepSize, (Integer)rebalancingInterval);
    }

    RandomProcess.SimulationResults simulate(int aNumberOfRealisations, int aNumberOfSteps, double aStepSize, Integer rebalancingInterval) {
        int tmpProcDim = this.myProcess.size();
        PrimitiveArray tmpInitialValues = this.myProcess.getValues();
        Number[] tmpValues = new Number[tmpProcDim];
        for (int p = 0; p < tmpProcDim; ++p) {
            tmpValues[p] = tmpInitialValues.get((long)p);
        }
        List<BigDecimal> tmpWeights = new SimplePortfolio(tmpValues).normalise().getWeights();
        Access2D tmpRealisationValues = Array2D.PRIMITIVE.makeZero(aNumberOfRealisations, aNumberOfSteps);
        for (int r = 0; r < aNumberOfRealisations; ++r) {
            for (int s = 0; s < aNumberOfSteps; ++s) {
                if (rebalancingInterval != null && s != 0 && s % rebalancingInterval == 0) {
                    double tmpPortfolioValue = ((Array2D)tmpRealisationValues).doubleValue(r, s - 1);
                    for (int p = 0; p < tmpProcDim; ++p) {
                        this.myProcess.setValue(p, tmpPortfolioValue * tmpWeights.get(p).doubleValue());
                    }
                }
                Array1D tmpRealisation = this.myProcess.step(aStepSize);
                AggregatorFunction<Double> tmpAggregator = Aggregator.SUM.getPrimitiveFunction();
                tmpRealisation.visitAll(tmpAggregator);
                ((Array2D)tmpRealisationValues).set((long)r, (long)s, tmpAggregator.doubleValue());
            }
            this.myProcess.setValues((Access1D)tmpInitialValues);
        }
        AggregatorFunction<Double> tmpAggregator = Aggregator.SUM.getPrimitiveFunction();
        int i = 0;
        while ((long)i < tmpInitialValues.count()) {
            tmpAggregator.invoke(tmpInitialValues.doubleValue((long)i));
            ++i;
        }
        return new RandomProcess.SimulationResults(tmpAggregator.doubleValue(), (Array2D<Double>)tmpRealisationValues);
    }
}

