/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix;

import java.math.BigDecimal;
import java.util.List;
import org.ojalgo.access.Access2D;
import org.ojalgo.algebra.NormedVectorSpace;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.context.NumberContext;

public interface BasicMatrix
extends Access2D<Number>,
NormedVectorSpace<BasicMatrix, Number> {
    @Override
    public BasicMatrix add(Access2D<?> var1);

    public BasicMatrix add(int var1, int var2, Access2D<?> var3);

    public BasicMatrix add(int var1, int var2, Number var3);

    @Override
    public BasicMatrix add(Number var1);

    public Access2D.Builder<? extends BasicMatrix> copyToBuilder();

    public BasicMatrix divide(Number var1);

    public BasicMatrix divideElements(Access2D<?> var1);

    public BasicMatrix enforce(NumberContext var1);

    public boolean equals(Access2D<?> var1, NumberContext var2);

    public void flushCache();

    public BasicMatrix getColumnsRange(int var1, int var2);

    public Scalar<?> getCondition();

    public Scalar<?> getDeterminant();

    public List<ComplexNumber> getEigenvalues();

    public Scalar<?> getFrobeniusNorm();

    public Scalar<?> getInfinityNorm();

    public Scalar<?> getKyFanNorm(int var1);

    public Scalar<?> getOneNorm();

    public Scalar<?> getOperatorNorm();

    public int getRank();

    public BasicMatrix getRowsRange(int var1, int var2);

    public List<? extends Number> getSingularValues();

    public Scalar<?> getTrace();

    public Scalar<?> getTraceNorm();

    public Scalar<?> getVectorNorm(int var1);

    public BasicMatrix invert();

    public boolean isEmpty();

    public boolean isFat();

    public boolean isFullRank();

    public boolean isHermitian();

    public boolean isScalar();

    public boolean isSquare();

    public boolean isSymmetric();

    public boolean isTall();

    public boolean isVector();

    public BasicMatrix mergeColumns(Access2D<?> var1);

    public BasicMatrix mergeRows(Access2D<?> var1);

    public BasicMatrix modify(UnaryFunction<? extends Number> var1);

    @Override
    public BasicMatrix multiply(Access2D<?> var1);

    public BasicMatrix multiplyElements(Access2D<?> var1);

    public BasicMatrix multiplyLeft(Access2D<?> var1);

    public Scalar<?> multiplyVectors(Access2D<?> var1);

    public BasicMatrix selectColumns(int ... var1);

    public BasicMatrix selectRows(int ... var1);

    public BasicMatrix solve(Access2D<?> var1);

    public BasicMatrix subtract(Access2D<?> var1);

    public BasicMatrix subtract(Number var1);

    public BigDecimal toBigDecimal(int var1, int var2);

    public PhysicalStore<BigDecimal> toBigStore();

    public ComplexNumber toComplexNumber(int var1, int var2);

    public PhysicalStore<ComplexNumber> toComplexStore();

    public List<BasicMatrix> toListOfColumns();

    public List<? extends Number> toListOfElements();

    public List<BasicMatrix> toListOfRows();

    public PhysicalStore<Double> toPrimitiveStore();

    public Scalar<?> toScalar(long var1, long var3);

    public String toString(int var1, int var2);

    public BasicMatrix transpose();

    public static interface Factory<I extends BasicMatrix>
    extends Access2D.Factory<I> {
        public Access2D.Builder<I> getBuilder(int var1);

        public Access2D.Builder<I> getBuilder(int var1, int var2);
    }
}

