/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.access.Access2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.array.BasicArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.scalar.ComplexNumber;

public interface DecompositionStore<N extends Number>
extends PhysicalStore<N> {
    public void applyCholesky(int var1, BasicArray<N> var2);

    public void applyLDL(int var1, BasicArray<N> var2);

    public void applyLU(int var1, BasicArray<N> var2);

    public Array2D<N> asArray2D();

    public Array1D<ComplexNumber> computeInPlaceSchur(PhysicalStore<N> var1, boolean var2);

    public void divideAndCopyColumn(int var1, int var2, BasicArray<N> var3);

    public void exchangeHermitian(int var1, int var2);

    public boolean generateApplyAndCopyHouseholderColumn(int var1, int var2, Householder<N> var3);

    public boolean generateApplyAndCopyHouseholderRow(int var1, int var2, Householder<N> var3);

    public int indexOfLargestInColumn(int var1, int var2);

    public int indexOfLargestInDiagonal(int var1, int var2);

    public void negateColumn(int var1);

    public void rotateRight(int var1, int var2, double var3, double var5);

    public void setToIdentity(int var1);

    public void substituteBackwards(Access2D<N> var1, boolean var2, boolean var3, boolean var4);

    public void substituteForwards(Access2D<N> var1, boolean var2, boolean var3, boolean var4);

    public void transformSymmetric(Householder<N> var1);

    public void tred2(BasicArray<N> var1, BasicArray<N> var2, boolean var3);

    public static final class HouseholderReference<N extends Number>
    implements Householder<N> {
        public int col = 0;
        public int row = 0;
        private transient Householder.Big myBigWorker = null;
        private final boolean myColumn;
        private transient Householder.Complex myComplexWorker = null;
        private transient Householder.Primitive myPrimitiveWorker = null;
        private final DecompositionStore<N> myStore;

        private HouseholderReference() {
            this(null, true);
        }

        HouseholderReference(DecompositionStore<N> aStore, boolean aColumn) {
            this.myStore = aStore;
            this.myColumn = aColumn;
        }

        @Override
        public long count() {
            if (this.myColumn) {
                return this.myStore.countRows();
            }
            return this.myStore.countColumns();
        }

        @Override
        public double doubleValue(long index) {
            if (this.myColumn) {
                if (index > (long)this.row) {
                    return this.myStore.doubleValue((int)index, this.col);
                }
                if (index == (long)this.row) {
                    return PrimitiveMath.ONE;
                }
                return PrimitiveMath.ZERO;
            }
            if (index > (long)this.col) {
                return this.myStore.doubleValue(this.row, (int)index);
            }
            if (index == (long)this.col) {
                return PrimitiveMath.ONE;
            }
            return PrimitiveMath.ZERO;
        }

        @Override
        public int first() {
            return this.myColumn ? this.row : this.col;
        }

        @Override
        public N get(long index) {
            if (this.myColumn) {
                if (index > (long)this.row) {
                    return this.myStore.get((int)index, this.col);
                }
                if (index == (long)this.row) {
                    return this.myStore.factory().scalar().one().getNumber();
                }
                return this.myStore.factory().scalar().zero().getNumber();
            }
            if (index > (long)this.col) {
                return this.myStore.get(this.row, (int)index);
            }
            if (index == (long)this.col) {
                return this.myStore.factory().scalar().one().getNumber();
            }
            return this.myStore.factory().scalar().zero().getNumber();
        }

        public final Householder.Big getBigWorker() {
            if (this.myBigWorker == null) {
                this.myBigWorker = this.myColumn ? new Householder.Big((int)this.myStore.countRows()) : new Householder.Big((int)this.myStore.countColumns());
            }
            return this.myBigWorker;
        }

        public final Householder.Complex getComplexWorker() {
            if (this.myComplexWorker == null) {
                this.myComplexWorker = this.myColumn ? new Householder.Complex((int)this.myStore.countRows()) : new Householder.Complex((int)this.myStore.countColumns());
            }
            return this.myComplexWorker;
        }

        public final Householder.Primitive getPrimitiveWorker() {
            if (this.myPrimitiveWorker == null) {
                this.myPrimitiveWorker = this.myColumn ? new Householder.Primitive((int)this.myStore.countRows()) : new Householder.Primitive((int)this.myStore.countColumns());
            }
            return this.myPrimitiveWorker;
        }

        public final boolean isZero() {
            if (this.myColumn) {
                return this.myStore.asArray2D().isColumnZeros(this.row + 1, this.col);
            }
            return this.myStore.asArray2D().isRowZeros(this.row, this.col + 1);
        }

        public String toString() {
            StringBuilder retVal = new StringBuilder("{ ");
            int tmpLastIndex = (int)this.count() - 1;
            for (int i = 0; i < tmpLastIndex; ++i) {
                retVal.append(this.get(i));
                retVal.append(", ");
            }
            retVal.append(this.get(tmpLastIndex));
            retVal.append(" }");
            return retVal.toString();
        }
    }
}

