/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import org.ojalgo.access.Access2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.DynamicEvD;
import org.ojalgo.matrix.decomposition.GeneralEvD;
import org.ojalgo.matrix.decomposition.HermitianEvD;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.decomposition.RawEigenvalue;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.ComplexNumber;

public interface Eigenvalue<N extends Number>
extends MatrixDecomposition<N>,
MatrixDecomposition.Hermitian<N>,
MatrixDecomposition.Determinant<N>,
MatrixDecomposition.Values<N> {
    public static <N extends Number> Eigenvalue<N> make(Access2D<N> typical) {
        return Eigenvalue.make(typical, MatrixUtils.isHermitian(typical));
    }

    public static <N extends Number> Eigenvalue<N> make(Access2D<N> typical, boolean hermitian) {
        N tmpNumber = typical.get(0L, 0L);
        if (tmpNumber instanceof BigDecimal) {
            return hermitian ? new HermitianEvD.Big() : null;
        }
        if (tmpNumber instanceof ComplexNumber) {
            return hermitian ? new HermitianEvD.Complex() : null;
        }
        if (tmpNumber instanceof Double) {
            if (8192L < typical.countColumns() && typical.count() <= 0x7FFFFFF7L) {
                return hermitian ? new HermitianEvD.Primitive() : new GeneralEvD.Primitive();
            }
            return hermitian ? new RawEigenvalue.Symmetric() : new RawEigenvalue.General();
        }
        throw new IllegalArgumentException();
    }

    public static Eigenvalue<BigDecimal> makeBig() {
        return Eigenvalue.makeBig(true);
    }

    public static Eigenvalue<BigDecimal> makeBig(boolean symmetric) {
        return symmetric ? new HermitianEvD.Big() : null;
    }

    public static Eigenvalue<ComplexNumber> makeComplex() {
        return Eigenvalue.makeComplex(true);
    }

    public static Eigenvalue<ComplexNumber> makeComplex(boolean hermitian) {
        return hermitian ? new HermitianEvD.Complex() : null;
    }

    public static Eigenvalue<Double> makePrimitive() {
        return new DynamicEvD.Primitive();
    }

    public static Eigenvalue<Double> makePrimitive(boolean symmetric) {
        return symmetric ? new HermitianEvD.Primitive() : new GeneralEvD.Primitive();
    }

    public MatrixStore<N> getD();

    public Array1D<ComplexNumber> getEigenvalues();

    public ComplexNumber getTrace();

    public MatrixStore<N> getV();

    public boolean isHermitian();

    @Override
    public boolean isOrdered();

    @Override
    default public MatrixStore<N> reconstruct() {
        return MatrixUtils.reconstruct(this);
    }
}

