/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.HessenbergDecomposition;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.ComplexNumber;

public interface Hessenberg<N extends Number>
extends MatrixDecomposition<N> {
    public static <N extends Number> Hessenberg<N> make(Access2D<N> typical) {
        N tmpNumber = typical.get(0L, 0L);
        if (tmpNumber instanceof BigDecimal) {
            return Hessenberg.makeBig();
        }
        if (tmpNumber instanceof ComplexNumber) {
            return Hessenberg.makeComplex();
        }
        if (tmpNumber instanceof Double) {
            return Hessenberg.makePrimitive();
        }
        throw new IllegalArgumentException();
    }

    public static Hessenberg<BigDecimal> makeBig() {
        return new HessenbergDecomposition.Big();
    }

    public static Hessenberg<ComplexNumber> makeComplex() {
        return new HessenbergDecomposition.Complex();
    }

    public static Hessenberg<Double> makePrimitive() {
        return new HessenbergDecomposition.Primitive();
    }

    public boolean compute(ElementsSupplier<N> var1, boolean var2);

    public MatrixStore<N> getH();

    public MatrixStore<N> getQ();

    public boolean isUpper();

    @Override
    default public MatrixStore<N> reconstruct() {
        return MatrixUtils.reconstruct(this);
    }
}

