/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.access.Access2D;
import org.ojalgo.array.ArrayUtils;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.PrimitiveAggregator;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.decomposition.Pivot;
import org.ojalgo.matrix.decomposition.RawDecomposition;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.store.RawStore;
import org.ojalgo.matrix.store.operation.DotProduct;
import org.ojalgo.type.context.NumberContext;

final class RawLU
extends RawDecomposition
implements LU<Double> {
    private Pivot myPivot;

    RawLU() {
    }

    @Override
    public Double calculateDeterminant(Access2D<?> matrix) {
        double[][] tmpData = this.reset(matrix, false);
        this.getRawInPlaceStore().fillMatching(matrix);
        this.doDecompose(tmpData);
        return this.getDeterminant();
    }

    @Override
    public boolean computeWithoutPivoting(ElementsSupplier<Double> matrix) {
        double[][] tmpData = this.reset(matrix, false);
        matrix.supplyTo(this.getRawInPlaceStore());
        return this.doDecompose(tmpData);
    }

    @Override
    public boolean decompose(ElementsSupplier<Double> matrix) {
        double[][] tmpData = this.reset(matrix, false);
        matrix.supplyTo(this.getRawInPlaceStore());
        return this.doDecompose(tmpData);
    }

    boolean doDecompose(double[][] data) {
        int tmpRowDim = this.getRowDim();
        int tmpColDim = this.getColDim();
        this.myPivot = new Pivot(tmpRowDim);
        double[] tmpColJ = new double[tmpRowDim];
        for (int j = 0; j < tmpColDim; ++j) {
            double tmpVal;
            int i;
            for (i = 0; i < tmpRowDim; ++i) {
                tmpColJ[i] = data[i][j];
            }
            for (i = 0; i < tmpRowDim; ++i) {
                int n = i;
                double d = tmpColJ[n] - DotProduct.invoke(data[i], 0, tmpColJ, 0, 0, Math.min(i, j));
                tmpColJ[n] = d;
                data[i][j] = d;
            }
            int p = j;
            for (int i2 = j + 1; i2 < tmpRowDim; ++i2) {
                if (!(Math.abs(tmpColJ[i2]) > Math.abs(tmpColJ[p]))) continue;
                p = i2;
            }
            if (p != j) {
                ArrayUtils.exchangeRows(data, j, p);
                this.myPivot.change(j, p);
            }
            if (j >= tmpRowDim || (tmpVal = data[j][j]) == PrimitiveMath.ZERO) continue;
            for (int i3 = j + 1; i3 < tmpRowDim; ++i3) {
                double[] dArray = data[i3];
                int n = j;
                dArray[n] = dArray[n] / tmpVal;
            }
        }
        return this.computed(true);
    }

    @Override
    public boolean equals(MatrixStore<Double> aStore, NumberContext context) {
        return MatrixUtils.equals(aStore, this, context);
    }

    @Override
    public Double getDeterminant() {
        int n;
        int m = this.getRowDim();
        if (m != (n = this.getColDim())) {
            throw new IllegalArgumentException("RawStore must be square.");
        }
        double[][] LU2 = this.getRawInPlaceData();
        double d = this.myPivot.signum();
        for (int j = 0; j < n; ++j) {
            d *= LU2[j][j];
        }
        return d;
    }

    @Override
    public MatrixStore<Double> getL() {
        return this.getRawInPlaceStore().builder().triangular(false, true).build();
    }

    @Override
    public int[] getPivotOrder() {
        return this.myPivot.getOrder();
    }

    @Override
    public int getRank() {
        int retVal = 0;
        MatrixStore<Double> tmpU = this.getU();
        int tmpMinDim = (int)Math.min(tmpU.countRows(), tmpU.countColumns());
        AggregatorFunction<Double> tmpLargest = PrimitiveAggregator.LARGEST.get();
        tmpU.visitDiagonal(0L, 0L, tmpLargest);
        double tmpLargestValue = tmpLargest.doubleValue();
        for (int ij = 0; ij < tmpMinDim; ++ij) {
            if (tmpU.isSmall(ij, ij, tmpLargestValue)) continue;
            ++retVal;
        }
        return retVal;
    }

    @Override
    public MatrixStore<Double> getU() {
        return this.getRawInPlaceStore().builder().triangular(true, false).build();
    }

    @Override
    public MatrixStore<Double> invert(Access2D<?> original, DecompositionStore<Double> preallocated) {
        double[][] tmpData = this.reset(original, false);
        this.getRawInPlaceStore().fillMatching(original);
        this.doDecompose(tmpData);
        return this.getInverse(preallocated);
    }

    @Override
    public boolean isSolvable() {
        return this.isSquareAndNotSingular();
    }

    @Override
    public boolean isSquareAndNotSingular() {
        return this.getRowDim() == this.getColDim() && this.isNonsingular();
    }

    @Override
    public void reset() {
        super.reset();
        this.myPivot = null;
    }

    @Override
    public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, DecompositionStore<Double> preallocated) {
        double[][] tmpData = this.reset(body, false);
        this.getRawInPlaceStore().fillMatching(body);
        this.doDecompose(tmpData);
        MatrixStore.PRIMITIVE.makeWrapper(rhs).row(this.myPivot.getOrder()).supplyTo(preallocated);
        return this.doSolve(preallocated);
    }

    @Override
    public MatrixStore<Double> solve(ElementsSupplier<Double> rhs, DecompositionStore<Double> preallocated) {
        rhs.get().builder().row(this.myPivot.getOrder()).supplyTo(preallocated);
        return this.doSolve(preallocated);
    }

    @Override
    public MatrixStore<Double> solve(MatrixStore<Double> rhs, DecompositionStore<Double> preallocated) {
        rhs.builder().row(this.myPivot.getOrder()).supplyTo(preallocated);
        return this.doSolve(preallocated);
    }

    @Override
    protected MatrixStore<Double> doGetInverse(PrimitiveDenseStore preallocated) {
        int[] tmpPivotOrder = this.myPivot.getOrder();
        int tmpRowDim = this.getRowDim();
        for (int i = 0; i < tmpRowDim; ++i) {
            preallocated.set((long)i, (long)tmpPivotOrder[i], PrimitiveMath.ONE);
        }
        RawStore tmpBody = this.getRawInPlaceStore();
        preallocated.substituteForwards(tmpBody, true, false, !this.myPivot.isModified());
        preallocated.substituteBackwards(tmpBody, false, false, false);
        return preallocated;
    }

    MatrixStore<Double> doSolve(DecompositionStore<Double> preallocated) {
        RawStore tmpBody = this.getRawInPlaceStore();
        preallocated.substituteForwards(tmpBody, true, false, false);
        preallocated.substituteBackwards(tmpBody, false, false, false);
        return preallocated;
    }

    boolean isNonsingular() {
        int n = this.getColDim();
        double[][] LU2 = this.getRawInPlaceData();
        for (int j = 0; j < n; ++j) {
            if (LU2[j][j] != 0.0) continue;
            return false;
        }
        return true;
    }
}

