/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.AccessUtils;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.DiagonalAccess;
import org.ojalgo.matrix.decomposition.InPlaceDecomposition;
import org.ojalgo.matrix.decomposition.Tridiagonal;
import org.ojalgo.matrix.store.BigDenseStore;
import org.ojalgo.matrix.store.ComplexDenseStore;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.type.context.NumberContext;

abstract class TridiagonalDecomposition<N extends Number>
extends InPlaceDecomposition<N>
implements Tridiagonal<N> {
    private transient MatrixStore<N> myD = null;
    private DiagonalAccess<N> myDiagonalAccessD = null;
    private Array1D<N> myInitDiagQ = null;
    private transient MatrixStore<N> myQ = null;

    protected TridiagonalDecomposition(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> aFactory) {
        super(aFactory);
    }

    @Override
    public final boolean decompose(ElementsSupplier<N> matrix) {
        this.reset();
        boolean retVal = false;
        try {
            int tmpRowDim = (int)matrix.countRows();
            MatrixStore.Builder aTriangularMtrx = matrix.get().builder().triangular(false, false);
            DecompositionStore tmpInPlace = this.setInPlace(aTriangularMtrx);
            Householder tmpHouseholder = this.makeHouseholder(tmpRowDim);
            int tmpLimit = tmpRowDim - 2;
            for (int ij = 0; ij < tmpLimit; ++ij) {
                if (!tmpInPlace.generateApplyAndCopyHouseholderColumn(ij + 1, ij, tmpHouseholder)) continue;
                tmpInPlace.transformSymmetric(tmpHouseholder);
            }
            Array2D tmpArray2D = this.getInPlace().asArray2D();
            Array1D tmpMain = ((Array1D)tmpArray2D.sliceDiagonal(0L, 0L)).copy();
            Array1D tmpSub = ((Array1D)tmpArray2D.sliceDiagonal(1L, 0L)).copy();
            this.myDiagonalAccessD = new DiagonalAccess(tmpMain, tmpSub, tmpSub, this.scalar().zero().getNumber());
            this.myInitDiagQ = this.makeReal(this.myDiagonalAccessD);
            retVal = true;
        }
        catch (Exception anException) {
            BasicLogger.error(anException.toString());
            this.reset();
            retVal = false;
        }
        return this.computed(retVal);
    }

    @Override
    public final boolean equals(MatrixStore<N> aStore, NumberContext context) {
        return AccessUtils.equals(this.reconstruct(), aStore, context);
    }

    @Override
    public final MatrixStore<N> getD() {
        if (this.myD == null) {
            this.myD = this.makeD();
        }
        return this.myD;
    }

    @Override
    public final MatrixStore<N> getQ() {
        if (this.myQ == null) {
            this.myQ = this.makeQ();
        }
        return this.myQ;
    }

    public final boolean isFullSize() {
        return true;
    }

    public final boolean isSolvable() {
        return false;
    }

    @Override
    public void reset() {
        super.reset();
        this.myDiagonalAccessD = null;
        this.myD = null;
        this.myQ = null;
        this.myInitDiagQ = null;
    }

    public MatrixStore<N> solve(Access2D<N> rhs, DecompositionStore<N> preallocated) {
        throw new UnsupportedOperationException();
    }

    protected final DiagonalAccess<N> getDiagonalAccessD() {
        if (this.myDiagonalAccessD != null) {
            return this.myDiagonalAccessD;
        }
        throw new IllegalStateException("Decomposition not calculated!");
    }

    protected final MatrixStore<N> makeD() {
        return this.wrap(this.getDiagonalAccessD()).get();
    }

    protected final DecompositionStore<N> makeQ() {
        DecompositionStore retVal = this.getInPlace();
        int tmpDim = (int)Math.min(retVal.countRows(), retVal.countColumns());
        DecompositionStore.HouseholderReference tmpHouseholderReference = new DecompositionStore.HouseholderReference(retVal, true);
        if (this.myInitDiagQ != null) {
            retVal.set((long)(tmpDim - 1), (long)(tmpDim - 1), (Number)this.myInitDiagQ.get(tmpDim - 1));
            retVal.set((long)(tmpDim - 2), (long)(tmpDim - 2), (Number)this.myInitDiagQ.get(tmpDim - 2));
        } else {
            retVal.set((long)(tmpDim - 1), (long)(tmpDim - 1), PrimitiveMath.ONE);
            retVal.set((long)(tmpDim - 2), (long)(tmpDim - 2), PrimitiveMath.ONE);
        }
        retVal.set((long)(tmpDim - 1), (long)(tmpDim - 2), PrimitiveMath.ZERO);
        for (int ij = tmpDim - 3; ij >= 0; --ij) {
            tmpHouseholderReference.row = ij + 1;
            tmpHouseholderReference.col = ij;
            if (!tmpHouseholderReference.isZero()) {
                retVal.transformLeft(tmpHouseholderReference, ij);
            }
            retVal.setToIdentity(ij);
            if (this.myInitDiagQ == null) continue;
            retVal.set((long)ij, (long)ij, (Number)this.myInitDiagQ.get(ij));
        }
        return retVal;
    }

    final DecompositionStore<N> doQ() {
        return (DecompositionStore)this.getQ();
    }

    abstract Array1D<N> makeReal(DiagonalAccess<N> var1);

    static final class Primitive
    extends TridiagonalDecomposition<Double> {
        Primitive() {
            super(PrimitiveDenseStore.FACTORY);
        }

        @Override
        Array1D<Double> makeReal(DiagonalAccess<Double> aDiagonalAccessD) {
            return null;
        }
    }

    static final class Complex
    extends TridiagonalDecomposition<ComplexNumber> {
        Complex() {
            super(ComplexDenseStore.FACTORY);
        }

        @Override
        Array1D<ComplexNumber> makeReal(DiagonalAccess<ComplexNumber> aDiagonalAccessD) {
            Access1D retVal = Array1D.COMPLEX.makeZero(aDiagonalAccessD.getDimension());
            ((Array1D)retVal).fillAll(ComplexNumber.ONE);
            Array1D tmpSubdiagonal = aDiagonalAccessD.subdiagonal;
            ComplexNumber tmpVal = null;
            int i = 0;
            while ((long)i < tmpSubdiagonal.length) {
                tmpVal = ((ComplexNumber)tmpSubdiagonal.get(i)).signum();
                if (!tmpVal.isReal()) {
                    tmpSubdiagonal.set(i, (Object)((ComplexNumber)tmpSubdiagonal.get(i)).divide(tmpVal));
                    if ((long)(i + 1) < tmpSubdiagonal.length) {
                        tmpSubdiagonal.set(i + 1, (Object)((ComplexNumber)tmpSubdiagonal.get(i + 1)).multiply(tmpVal));
                    }
                    ((Array1D)retVal).set(i + 1, (Object)tmpVal);
                }
                ++i;
            }
            return retVal;
        }
    }

    static final class Big
    extends TridiagonalDecomposition<BigDecimal> {
        Big() {
            super(BigDenseStore.FACTORY);
        }

        @Override
        Array1D<BigDecimal> makeReal(DiagonalAccess<BigDecimal> aDiagonalAccessD) {
            return null;
        }
    }
}

