/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.matrix.store.DelegatingStore;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.Scalar;

final class AboveBelowStore<N extends Number>
extends DelegatingStore<N> {
    private final MatrixStore<N> myBelow;
    private final int mySplit;

    private AboveBelowStore(MatrixStore<N> base) {
        this(base, null);
        ProgrammingError.throwForIllegalInvocation();
    }

    AboveBelowStore(MatrixStore<N> base, MatrixStore<N> below) {
        super((int)(base.countRows() + below.countRows()), (int)base.countColumns(), base);
        this.myBelow = below;
        this.mySplit = (int)base.countRows();
        if (base.countColumns() != below.countColumns()) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public double doubleValue(long row, long column) {
        return row >= (long)this.mySplit ? this.myBelow.doubleValue(row - (long)this.mySplit, column) : this.getBase().doubleValue(row, column);
    }

    @Override
    public int firstInColumn(int col) {
        return this.getBase().firstInColumn(col);
    }

    @Override
    public int firstInRow(int row) {
        return row < this.mySplit ? this.getBase().firstInRow(row) : this.myBelow.firstInRow(row);
    }

    @Override
    public N get(long row, long column) {
        return row >= (long)this.mySplit ? this.myBelow.get(row - (long)this.mySplit, column) : this.getBase().get(row, column);
    }

    @Override
    public int limitOfColumn(int col) {
        return this.myBelow.limitOfColumn(col);
    }

    @Override
    public int limitOfRow(int row) {
        return row < this.mySplit ? this.getBase().limitOfRow(row) : this.myBelow.limitOfRow(row);
    }

    @Override
    public MatrixStore<N> multiply(Access1D<N> right) {
        Future<MatrixStore<N>> tmpBaseFuture = this.executeMultiplyRightOnBase(right);
        MatrixStore<Access1D<N>> tmpLower = this.myBelow.multiply(right);
        try {
            return new AboveBelowStore<Access1D<N>>(tmpBaseFuture.get(), tmpLower);
        }
        catch (InterruptedException | ExecutionException ex) {
            return null;
        }
    }

    @Override
    public Scalar<N> toScalar(long row, long column) {
        return row >= (long)this.mySplit ? this.myBelow.toScalar(row - (long)this.mySplit, column) : this.getBase().toScalar(row, column);
    }

    @Override
    protected void supplyNonZerosTo(ElementsConsumer<N> consumer) {
        consumer.regionByLimits(this.mySplit, this.getColDim()).fillMatching(this.getBase());
        consumer.regionByOffsets(this.mySplit, 0).fillMatching(this.myBelow);
    }
}

