/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.math.BigDecimal;
import java.util.List;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.AccessUtils;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.BigArray;
import org.ojalgo.concurrent.DivideAndConquer;
import org.ojalgo.constant.BigMath;
import org.ojalgo.function.BigFunction;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.BigAggregator;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.TransposedStore;
import org.ojalgo.matrix.store.operation.AXPY;
import org.ojalgo.matrix.store.operation.AggregateAll;
import org.ojalgo.matrix.store.operation.ApplyCholesky;
import org.ojalgo.matrix.store.operation.ApplyLDL;
import org.ojalgo.matrix.store.operation.ApplyLU;
import org.ojalgo.matrix.store.operation.FillMatchingLeft;
import org.ojalgo.matrix.store.operation.FillMatchingRight;
import org.ojalgo.matrix.store.operation.FillMatchingSingle;
import org.ojalgo.matrix.store.operation.FillTransposed;
import org.ojalgo.matrix.store.operation.GenerateApplyAndCopyHouseholderColumn;
import org.ojalgo.matrix.store.operation.GenerateApplyAndCopyHouseholderRow;
import org.ojalgo.matrix.store.operation.HouseholderHermitian;
import org.ojalgo.matrix.store.operation.HouseholderLeft;
import org.ojalgo.matrix.store.operation.HouseholderRight;
import org.ojalgo.matrix.store.operation.MAXPY;
import org.ojalgo.matrix.store.operation.ModifyAll;
import org.ojalgo.matrix.store.operation.MultiplyBoth;
import org.ojalgo.matrix.store.operation.MultiplyLeft;
import org.ojalgo.matrix.store.operation.MultiplyRight;
import org.ojalgo.matrix.store.operation.RotateLeft;
import org.ojalgo.matrix.store.operation.RotateRight;
import org.ojalgo.matrix.store.operation.SubstituteBackwards;
import org.ojalgo.matrix.store.operation.SubstituteForwards;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.matrix.transformation.Rotation;
import org.ojalgo.scalar.BigScalar;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.TypeUtils;
import org.ojalgo.type.context.NumberContext;

public final class BigDenseStore
extends BigArray
implements PhysicalStore<BigDecimal>,
DecompositionStore<BigDecimal> {
    public static final PhysicalStore.Factory<BigDecimal, BigDenseStore> FACTORY = new PhysicalStore.Factory<BigDecimal, BigDenseStore>(){

        @Override
        public AggregatorSet<BigDecimal> aggregator() {
            return BigAggregator.getSet();
        }

        @Override
        public MatrixStore.Factory<BigDecimal> builder() {
            return MatrixStore.BIG;
        }

        @Override
        public BigDenseStore columns(Access1D<?> ... source) {
            int tmpRowDim = (int)source[0].count();
            int tmpColDim = source.length;
            BigDecimal[] tmpData = new BigDecimal[tmpRowDim * tmpColDim];
            for (int j = 0; j < tmpColDim; ++j) {
                Access1D<?> tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = TypeUtils.toBigDecimal(tmpColumn.get(i));
                }
            }
            return new BigDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public BigDenseStore columns(double[] ... source) {
            int tmpRowDim = source[0].length;
            int tmpColDim = source.length;
            BigDecimal[] tmpData = new BigDecimal[tmpRowDim * tmpColDim];
            for (int j = 0; j < tmpColDim; ++j) {
                double[] tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = TypeUtils.toBigDecimal(tmpColumn[i]);
                }
            }
            return new BigDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public BigDenseStore columns(List<? extends Number> ... source) {
            int tmpRowDim = source[0].size();
            int tmpColDim = source.length;
            BigDecimal[] tmpData = new BigDecimal[tmpRowDim * tmpColDim];
            for (int j = 0; j < tmpColDim; ++j) {
                List<? extends Number> tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = TypeUtils.toBigDecimal(tmpColumn.get(i));
                }
            }
            return new BigDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public BigDenseStore columns(Number[] ... source) {
            int tmpRowDim = source[0].length;
            int tmpColDim = source.length;
            BigDecimal[] tmpData = new BigDecimal[tmpRowDim * tmpColDim];
            for (int j = 0; j < tmpColDim; ++j) {
                Number[] tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = TypeUtils.toBigDecimal(tmpColumn[i]);
                }
            }
            return new BigDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public BigDenseStore conjugate(Access2D<?> source) {
            return this.transpose((Access2D)source);
        }

        @Override
        public BigDenseStore copy(final Access2D<?> source) {
            final int tmpRowDim = (int)source.countRows();
            int tmpColDim = (int)source.countColumns();
            final BigDenseStore retVal = new BigDenseStore(tmpRowDim, tmpColDim);
            if (tmpColDim > FillMatchingSingle.THRESHOLD) {
                DivideAndConquer tmpConquerer = new DivideAndConquer(){

                    @Override
                    public void conquer(int aFirst, int aLimit) {
                        FillMatchingSingle.invoke((BigDecimal[])retVal.data, tmpRowDim, aFirst, aLimit, (Access1D<? extends Number>)source);
                    }
                };
                tmpConquerer.invoke(0, tmpColDim, FillMatchingSingle.THRESHOLD);
            } else {
                FillMatchingSingle.invoke((BigDecimal[])retVal.data, tmpRowDim, 0, tmpColDim, source);
            }
            return retVal;
        }

        @Override
        public FunctionSet<BigDecimal> function() {
            return BigFunction.getSet();
        }

        public BigArray makeArray(int length) {
            return BigArray.make(length);
        }

        @Override
        public BigDenseStore makeEye(long rows, long columns) {
            BigDenseStore retVal = this.makeZero(rows, columns);
            retVal.myUtility.fillDiagonal(0L, 0L, BigMath.ONE);
            return retVal;
        }

        @Override
        public BigDenseStore makeFilled(long rows, long columns, NullaryFunction<?> supplier) {
            int tmpRowDim = (int)rows;
            int tmpColDim = (int)columns;
            int tmpLength = tmpRowDim * tmpColDim;
            BigDecimal[] tmpData = new BigDecimal[tmpLength];
            for (int i = 0; i < tmpLength; ++i) {
                tmpData[i] = TypeUtils.toBigDecimal((Number)supplier.get());
            }
            return new BigDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        public Householder.Big makeHouseholder(int length) {
            return new Householder.Big(length);
        }

        public Rotation.Big makeRotation(int low, int high, BigDecimal cos, BigDecimal sin) {
            return new Rotation.Big(low, high, cos, sin);
        }

        public Rotation.Big makeRotation(int low, int high, double cos, double sin) {
            return this.makeRotation(low, high, new BigDecimal(cos), new BigDecimal(sin));
        }

        @Override
        public BigDenseStore makeZero(long rows, long columns) {
            return new BigDenseStore((int)rows, (int)columns);
        }

        @Override
        public BigDenseStore rows(Access1D<?> ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = (int)source[0].count();
            BigDecimal[] tmpData = new BigDecimal[tmpRowDim * tmpColDim];
            for (int i = 0; i < tmpRowDim; ++i) {
                Access1D<?> tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = TypeUtils.toBigDecimal(tmpRow.get(j));
                }
            }
            return new BigDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public BigDenseStore rows(double[] ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = source[0].length;
            BigDecimal[] tmpData = new BigDecimal[tmpRowDim * tmpColDim];
            for (int i = 0; i < tmpRowDim; ++i) {
                double[] tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = TypeUtils.toBigDecimal(tmpRow[j]);
                }
            }
            return new BigDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public BigDenseStore rows(List<? extends Number> ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = source[0].size();
            BigDecimal[] tmpData = new BigDecimal[tmpRowDim * tmpColDim];
            for (int i = 0; i < tmpRowDim; ++i) {
                List<? extends Number> tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = TypeUtils.toBigDecimal(tmpRow.get(j));
                }
            }
            return new BigDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public BigDenseStore rows(Number[] ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = source[0].length;
            BigDecimal[] tmpData = new BigDecimal[tmpRowDim * tmpColDim];
            for (int i = 0; i < tmpRowDim; ++i) {
                Number[] tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = TypeUtils.toBigDecimal(tmpRow[j]);
                }
            }
            return new BigDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public Scalar.Factory<BigDecimal> scalar() {
            return BigScalar.FACTORY;
        }

        @Override
        public BigDenseStore transpose(final Access2D<?> source) {
            final BigDenseStore retVal = new BigDenseStore((int)source.countColumns(), (int)source.countRows());
            final int tmpRowDim = retVal.getRowDim();
            int tmpColDim = retVal.getColDim();
            if (tmpColDim > FillTransposed.THRESHOLD) {
                DivideAndConquer tmpConquerer = new DivideAndConquer(){

                    @Override
                    public void conquer(int aFirst, int aLimit) {
                        FillTransposed.invoke((BigDecimal[])retVal.data, tmpRowDim, aFirst, aLimit, source);
                    }
                };
                tmpConquerer.invoke(0, tmpColDim, FillTransposed.THRESHOLD);
            } else {
                FillTransposed.invoke((BigDecimal[])retVal.data, tmpRowDim, 0, tmpColDim, source);
            }
            return retVal;
        }
    };
    private final BigMultiplyBoth multiplyBoth;
    private final BigMultiplyLeft multiplyLeft;
    private final BigMultiplyRight multiplyRight;
    private final int myColDim;
    private final int myRowDim;
    private final Array2D<BigDecimal> myUtility;

    static BigDenseStore cast(Access1D<BigDecimal> matrix) {
        if (matrix instanceof BigDenseStore) {
            return (BigDenseStore)matrix;
        }
        if (matrix instanceof Access2D) {
            return (BigDenseStore)FACTORY.copy((Access2D)matrix);
        }
        return (BigDenseStore)FACTORY.columns(matrix);
    }

    static Householder.Big cast(Householder<BigDecimal> transformation) {
        if (transformation instanceof Householder.Big) {
            return (Householder.Big)transformation;
        }
        if (transformation instanceof DecompositionStore.HouseholderReference) {
            return ((DecompositionStore.HouseholderReference)transformation).getBigWorker().copy(transformation);
        }
        return new Householder.Big(transformation);
    }

    static Rotation.Big cast(Rotation<BigDecimal> transformation) {
        if (transformation instanceof Rotation.Big) {
            return (Rotation.Big)transformation;
        }
        return new Rotation.Big(transformation);
    }

    BigDenseStore(BigDecimal[] anArray) {
        super(anArray);
        this.myRowDim = anArray.length;
        this.myColDim = 1;
        this.myUtility = this.asArray2D(this.myRowDim);
        this.multiplyBoth = MultiplyBoth.getBig(this.myRowDim, this.myColDim);
        this.multiplyLeft = MultiplyLeft.getBig(this.myRowDim, this.myColDim);
        this.multiplyRight = MultiplyRight.getBig(this.myRowDim, this.myColDim);
    }

    BigDenseStore(int aLength) {
        super(aLength);
        this.myRowDim = aLength;
        this.myColDim = 1;
        this.myUtility = this.asArray2D(this.myRowDim);
        this.multiplyBoth = MultiplyBoth.getBig(this.myRowDim, this.myColDim);
        this.multiplyLeft = MultiplyLeft.getBig(this.myRowDim, this.myColDim);
        this.multiplyRight = MultiplyRight.getBig(this.myRowDim, this.myColDim);
    }

    BigDenseStore(int aRowDim, int aColDim) {
        super(aRowDim * aColDim);
        this.myRowDim = aRowDim;
        this.myColDim = aColDim;
        this.myUtility = this.asArray2D(this.myRowDim);
        this.multiplyBoth = MultiplyBoth.getBig(this.myRowDim, this.myColDim);
        this.multiplyLeft = MultiplyLeft.getBig(this.myRowDim, this.myColDim);
        this.multiplyRight = MultiplyRight.getBig(this.myRowDim, this.myColDim);
    }

    BigDenseStore(int aRowDim, int aColDim, BigDecimal[] anArray) {
        super(anArray);
        this.myRowDim = aRowDim;
        this.myColDim = aColDim;
        this.myUtility = this.asArray2D(this.myRowDim);
        this.multiplyBoth = MultiplyBoth.getBig(this.myRowDim, this.myColDim);
        this.multiplyLeft = MultiplyLeft.getBig(this.myRowDim, this.myColDim);
        this.multiplyRight = MultiplyRight.getBig(this.myRowDim, this.myColDim);
    }

    @Override
    public void accept(Access2D<BigDecimal> supplied) {
        for (long j = 0L; j < supplied.countColumns(); ++j) {
            for (long i = 0L; i < supplied.countRows(); ++i) {
                this.set(i, j, supplied.get(i, j));
            }
        }
    }

    @Override
    public void add(long row, long column, double addend) {
        this.myUtility.add(row, column, addend);
    }

    @Override
    public void add(long row, long column, Number addend) {
        this.myUtility.add(row, column, addend);
    }

    @Override
    public BigDecimal aggregateAll(final Aggregator aggregator) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        final AggregatorFunction<BigDecimal> tmpMainAggr = aggregator.getBigFunction();
        if (tmpColDim > AggregateAll.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void conquer(int aFirst, int aLimit) {
                    AggregatorFunction<BigDecimal> tmpPartAggr = aggregator.getBigFunction();
                    BigDenseStore.this.visit(tmpRowDim * aFirst, tmpRowDim * aLimit, 1, tmpPartAggr);
                    AggregatorFunction aggregatorFunction = tmpMainAggr;
                    synchronized (aggregatorFunction) {
                        tmpMainAggr.merge(tmpPartAggr.getNumber());
                    }
                }
            };
            tmpConquerer.invoke(0, tmpColDim, AggregateAll.THRESHOLD);
        } else {
            this.visit(0, this.size(), 1, tmpMainAggr);
        }
        return tmpMainAggr.getNumber();
    }

    @Override
    public void applyCholesky(int iterationPoint, BasicArray<BigDecimal> multipliers) {
        final BigDecimal[] tmpData = (BigDecimal[])this.data;
        final BigDecimal[] tmpColumn = (BigDecimal[])((BigArray)multipliers).data;
        if (this.myColDim - iterationPoint - 1 > ApplyCholesky.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int aFirst, int aLimit) {
                    ApplyCholesky.invoke(tmpData, BigDenseStore.this.myRowDim, aFirst, aLimit, tmpColumn);
                }
            };
            tmpConquerer.invoke(iterationPoint + 1, this.myColDim, ApplyCholesky.THRESHOLD);
        } else {
            ApplyCholesky.invoke(tmpData, this.myRowDim, iterationPoint + 1, this.myColDim, tmpColumn);
        }
    }

    @Override
    public void applyLDL(final int iterationPoint, BasicArray<BigDecimal> multipliers) {
        final BigDecimal[] tmpData = (BigDecimal[])this.data;
        final BigDecimal[] tmpColumn = (BigDecimal[])((BigArray)multipliers).data;
        if (this.myColDim - iterationPoint - 1 > ApplyLDL.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int first, int limit) {
                    ApplyLDL.invoke(tmpData, BigDenseStore.this.myRowDim, first, limit, tmpColumn, iterationPoint);
                }
            };
            tmpConquerer.invoke(iterationPoint + 1, this.myColDim, ApplyLDL.THRESHOLD);
        } else {
            ApplyLDL.invoke(tmpData, this.myRowDim, iterationPoint + 1, this.myColDim, tmpColumn, iterationPoint);
        }
    }

    @Override
    public void applyLU(final int iterationPoint, BasicArray<BigDecimal> multipliers) {
        final BigDecimal[] tmpData = (BigDecimal[])this.data;
        final BigDecimal[] tmpColumn = (BigDecimal[])((BigArray)multipliers).data;
        if (this.myColDim - iterationPoint - 1 > ApplyLU.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int aFirst, int aLimit) {
                    ApplyLU.invoke(tmpData, BigDenseStore.this.myRowDim, aFirst, aLimit, tmpColumn, iterationPoint);
                }
            };
            tmpConquerer.invoke(iterationPoint + 1, this.myColDim, ApplyLU.THRESHOLD);
        } else {
            ApplyLU.invoke(tmpData, this.myRowDim, iterationPoint + 1, this.myColDim, tmpColumn, iterationPoint);
        }
    }

    @Override
    public Array2D<BigDecimal> asArray2D() {
        return this.myUtility;
    }

    @Override
    public Array1D<BigDecimal> asList() {
        return this.myUtility.asArray1D();
    }

    @Override
    public final MatrixStore.Builder<BigDecimal> builder() {
        return new MatrixStore.Builder<BigDecimal>(this);
    }

    @Override
    public void caxpy(BigDecimal scalarA, int columnX, int columnY, int firstRow) {
        AXPY.invoke((BigDecimal[])this.data, columnY * this.myRowDim + firstRow, 1, scalarA, (BigDecimal[])this.data, columnX * this.myRowDim + firstRow, 1, this.myRowDim - firstRow);
    }

    @Override
    public Array1D<ComplexNumber> computeInPlaceSchur(PhysicalStore<BigDecimal> transformationCollector, boolean eigenvalue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MatrixStore<BigDecimal> conjugate() {
        return this.transpose();
    }

    public BigDenseStore copy() {
        return new BigDenseStore(this.myRowDim, this.myColDim, (BigDecimal[])this.copyOfData());
    }

    @Override
    public long countColumns() {
        return this.myColDim;
    }

    @Override
    public long countRows() {
        return this.myRowDim;
    }

    @Override
    public void divideAndCopyColumn(int row, int column, BasicArray<BigDecimal> destination) {
        BigDecimal[] tmpData = (BigDecimal[])this.data;
        int tmpRowDim = this.myRowDim;
        BigDecimal[] tmpDestination = (BigDecimal[])((BigArray)destination).data;
        int tmpIndex = row + column * tmpRowDim;
        BigDecimal tmpDenominator = tmpData[tmpIndex];
        for (int i = row + 1; i < tmpRowDim; ++i) {
            tmpDestination[i] = tmpData[tmpIndex] = BigFunction.DIVIDE.invoke(tmpData[++tmpIndex], tmpDenominator);
        }
    }

    @Override
    public double doubleValue(long aRow, long aCol) {
        return this.myUtility.doubleValue(aRow, aCol);
    }

    @Override
    public boolean equals(MatrixStore<BigDecimal> other, NumberContext context) {
        return AccessUtils.equals(this, other, context);
    }

    @Override
    public boolean equals(Object anObj) {
        if (anObj instanceof MatrixStore) {
            return this.equals((MatrixStore)anObj, NumberContext.getGeneral(6));
        }
        return super.equals(anObj);
    }

    @Override
    public void exchangeColumns(long colA, long colB) {
        this.myUtility.exchangeColumns(colA, colB);
    }

    @Override
    public void exchangeHermitian(int indexA, int indexB) {
        BigDecimal tmpVal;
        int tmpMin = Math.min(indexA, indexB);
        int tmpMax = Math.max(indexA, indexB);
        for (int j = 0; j < tmpMin; ++j) {
            tmpVal = this.get(tmpMin, j);
            this.set((long)tmpMin, (long)j, this.get(tmpMax, j));
            this.set((long)tmpMax, (long)j, tmpVal);
        }
        tmpVal = this.get(tmpMin, tmpMin);
        this.set((long)tmpMin, (long)tmpMin, this.get(tmpMax, tmpMax));
        this.set((long)tmpMax, (long)tmpMax, tmpVal);
        for (int ij = tmpMin + 1; ij < tmpMax; ++ij) {
            tmpVal = this.get(ij, tmpMin);
            this.set((long)ij, (long)tmpMin, this.get(tmpMax, ij));
            this.set((long)tmpMax, (long)ij, tmpVal);
        }
        for (int i = tmpMax + 1; i < this.myRowDim; ++i) {
            tmpVal = this.get(i, tmpMin);
            this.set((long)i, (long)tmpMin, this.get(i, tmpMax));
            this.set((long)i, (long)tmpMax, tmpVal);
        }
    }

    @Override
    public void exchangeRows(long rowA, long rowB) {
        this.myUtility.exchangeRows(rowA, rowB);
    }

    @Override
    public PhysicalStore.Factory<BigDecimal, BigDenseStore> factory() {
        return FACTORY;
    }

    @Override
    public void fillByMultiplying(Access1D<BigDecimal> left, Access1D<BigDecimal> right) {
        int tmpComplexity = (int)left.count() / this.myRowDim;
        if (right instanceof BigDenseStore) {
            this.multiplyLeft.invoke((BigDecimal[])this.data, left, tmpComplexity, (BigDecimal[])BigDenseStore.cast(right).data);
        } else if (left instanceof BigDenseStore) {
            this.multiplyRight.invoke((BigDecimal[])this.data, (BigDecimal[])BigDenseStore.cast(left).data, tmpComplexity, right);
        } else {
            this.multiplyBoth.invoke(this, left, tmpComplexity, right);
        }
    }

    @Override
    public void fillColumn(long row, long column, BigDecimal value) {
        this.myUtility.fillColumn(row, column, value);
    }

    @Override
    public void fillColumn(long row, long column, NullaryFunction<BigDecimal> supplier) {
        this.myUtility.fillColumn(row, column, supplier);
    }

    @Override
    public void fillDiagonal(long row, long column, BigDecimal value) {
        this.myUtility.fillDiagonal(row, column, value);
    }

    @Override
    public void fillDiagonal(long row, long column, NullaryFunction<BigDecimal> supplier) {
        this.myUtility.fillDiagonal(row, column, supplier);
    }

    public void fillMatching(final Access1D<BigDecimal> aLeftArg, final BinaryFunction<BigDecimal> aFunc, final BigDecimal aRightArg) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim > FillMatchingLeft.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int aFirst, int aLimit) {
                    BigDenseStore.this.fill(tmpRowDim * aFirst, tmpRowDim * aLimit, aLeftArg, aFunc, aRightArg);
                }
            };
            tmpConquerer.invoke(0, tmpColDim, FillMatchingLeft.THRESHOLD);
        } else {
            this.fill(0, tmpRowDim * tmpColDim, aLeftArg, aFunc, aRightArg);
        }
    }

    public void fillMatching(final BigDecimal aLeftArg, final BinaryFunction<BigDecimal> aFunc, final Access1D<BigDecimal> aRightArg) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim > FillMatchingRight.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int aFirst, int aLimit) {
                    BigDenseStore.this.fill(tmpRowDim * aFirst, tmpRowDim * aLimit, aLeftArg, aFunc, aRightArg);
                }
            };
            tmpConquerer.invoke(0, tmpColDim, FillMatchingRight.THRESHOLD);
        } else {
            this.fill(0, tmpRowDim * tmpColDim, aLeftArg, aFunc, aRightArg);
        }
    }

    @Override
    public void fillOne(long row, long column, BigDecimal value) {
        this.myUtility.fillOne(row, column, value);
    }

    @Override
    public void fillOne(long row, long column, NullaryFunction<BigDecimal> supplier) {
        this.myUtility.fillOne(row, column, supplier);
    }

    @Override
    public void fillOneMatching(long row, long column, Access1D<?> values, long valueIndex) {
        this.set(row, column, (Number)values.get(valueIndex));
    }

    @Override
    public void fillRow(long row, long column, BigDecimal value) {
        this.myUtility.fillRow(row, column, value);
    }

    @Override
    public void fillRow(long row, long column, NullaryFunction<BigDecimal> supplier) {
        this.myUtility.fillRow(row, column, supplier);
    }

    @Override
    public boolean generateApplyAndCopyHouseholderColumn(int row, int column, Householder<BigDecimal> destination) {
        return GenerateApplyAndCopyHouseholderColumn.invoke((BigDecimal[])this.data, this.myRowDim, row, column, (Householder.Big)destination);
    }

    @Override
    public boolean generateApplyAndCopyHouseholderRow(int row, int column, Householder<BigDecimal> destination) {
        return GenerateApplyAndCopyHouseholderRow.invoke((BigDecimal[])this.data, this.myRowDim, row, column, (Householder.Big)destination);
    }

    @Override
    public final MatrixStore<BigDecimal> get() {
        return this;
    }

    @Override
    public BigDecimal get(long aRow, long aCol) {
        return this.myUtility.get(aRow, aCol);
    }

    @Override
    public int hashCode() {
        return MatrixUtils.hashCode(this);
    }

    @Override
    public int indexOfLargestInColumn(int row, int column) {
        return (int)this.myUtility.indexOfLargestInColumn(row, column);
    }

    @Override
    public long indexOfLargestInColumn(long row, long column) {
        return this.myUtility.indexOfLargestInColumn(row, column);
    }

    @Override
    public int indexOfLargestInDiagonal(int row, int column) {
        return (int)this.myUtility.indexOfLargestInDiagonal(row, column);
    }

    @Override
    public long indexOfLargestInDiagonal(long row, long column) {
        return this.myUtility.indexOfLargestInDiagonal(row, column);
    }

    @Override
    public long indexOfLargestInRow(long row, long column) {
        return this.myUtility.indexOfLargestInRow(row, column);
    }

    @Override
    public boolean isAbsolute(long row, long column) {
        return this.myUtility.isAbsolute(row, column);
    }

    @Override
    public boolean isSmall(long row, long column, double comparedTo) {
        return this.myUtility.isSmall(row, column, comparedTo);
    }

    @Override
    public void maxpy(final BigDecimal aSclrA, final MatrixStore<BigDecimal> aMtrxX) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim > MAXPY.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int aFirst, int aLimit) {
                    MAXPY.invoke((BigDecimal[])BigDenseStore.this.data, tmpRowDim, aFirst, aLimit, aSclrA, aMtrxX);
                }
            };
            tmpConquerer.invoke(0, tmpColDim, MAXPY.THRESHOLD);
        } else {
            MAXPY.invoke((BigDecimal[])this.data, tmpRowDim, 0, tmpColDim, aSclrA, aMtrxX);
        }
    }

    @Override
    public void modifyAll(final UnaryFunction<BigDecimal> aFunc) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim > ModifyAll.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int aFirst, int aLimit) {
                    BigDenseStore.this.modify(tmpRowDim * aFirst, tmpRowDim * aLimit, 1, aFunc);
                }
            };
            tmpConquerer.invoke(0, tmpColDim, ModifyAll.THRESHOLD);
        } else {
            this.modify(tmpRowDim * 0, tmpRowDim * tmpColDim, 1, aFunc);
        }
    }

    @Override
    public void modifyColumn(long row, long column, UnaryFunction<BigDecimal> function) {
        this.myUtility.modifyColumn(row, column, function);
    }

    @Override
    public void modifyDiagonal(long row, long column, UnaryFunction<BigDecimal> function) {
        this.myUtility.modifyDiagonal(row, column, function);
    }

    @Override
    public void modifyOne(long row, long column, UnaryFunction<BigDecimal> function) {
        BigDecimal tmpValue = this.get(row, column);
        tmpValue = function.invoke(tmpValue);
        this.set(row, column, tmpValue);
    }

    @Override
    public void modifyRow(long row, long column, UnaryFunction<BigDecimal> function) {
        this.myUtility.modifyRow(row, column, function);
    }

    @Override
    public MatrixStore<BigDecimal> multiply(Access1D<BigDecimal> right) {
        BigDenseStore retVal = (BigDenseStore)FACTORY.makeZero(this.myRowDim, right.count() / (long)this.myColDim);
        if (right instanceof BigDenseStore) {
            retVal.multiplyLeft.invoke((BigDecimal[])retVal.data, this, this.myColDim, (BigDecimal[])((BigDenseStore)right).data);
        } else {
            retVal.multiplyRight.invoke((BigDecimal[])retVal.data, (BigDecimal[])this.data, this.myColDim, right);
        }
        return retVal;
    }

    @Override
    public BigDecimal multiplyBoth(Access1D<BigDecimal> leftAndRight) {
        PhysicalStore tmpStep1 = (PhysicalStore)FACTORY.makeZero(1L, leftAndRight.count());
        PhysicalStore tmpStep2 = (PhysicalStore)FACTORY.makeZero(1L, 1L);
        tmpStep1.fillByMultiplying(leftAndRight, this);
        tmpStep2.fillByMultiplying(tmpStep1, leftAndRight);
        return (BigDecimal)tmpStep2.get(0L);
    }

    @Override
    public void negateColumn(int column) {
        this.myUtility.modifyColumn(0L, column, BigFunction.NEGATE);
    }

    @Override
    public void raxpy(BigDecimal scalarA, int rowX, int rowY, int firstColumn) {
        AXPY.invoke((BigDecimal[])this.data, rowY + firstColumn * (((BigDecimal[])this.data).length / this.myColDim), ((BigDecimal[])this.data).length / this.myColDim, scalarA, (BigDecimal[])this.data, rowX + firstColumn * (((BigDecimal[])this.data).length / this.myColDim), ((BigDecimal[])this.data).length / this.myColDim, this.myColDim - firstColumn);
    }

    @Override
    public final ElementsConsumer<BigDecimal> regionByColumns(int ... columns) {
        return new PhysicalStore.ColumnsRegion<BigDecimal>(this, this.multiplyBoth, columns);
    }

    @Override
    public final ElementsConsumer<BigDecimal> regionByLimits(int rowLimit, int columnLimit) {
        return new PhysicalStore.LimitRegion<BigDecimal>(this, this.multiplyBoth, rowLimit, columnLimit);
    }

    @Override
    public final ElementsConsumer<BigDecimal> regionByOffsets(int rowOffset, int columnOffset) {
        return new PhysicalStore.OffsetRegion<BigDecimal>(this, this.multiplyBoth, rowOffset, columnOffset);
    }

    @Override
    public final ElementsConsumer<BigDecimal> regionByRows(int ... rows) {
        return new PhysicalStore.RowsRegion<BigDecimal>(this, this.multiplyBoth, rows);
    }

    @Override
    public final ElementsConsumer<BigDecimal> regionByTransposing() {
        return new PhysicalStore.TransposedRegion<BigDecimal>(this, this.multiplyBoth);
    }

    @Override
    public void rotateRight(int aLow, int aHigh, double aCos, double aSin) {
        RotateRight.invoke((BigDecimal[])this.data, this.myRowDim, aLow, aHigh, FACTORY.scalar().cast(aCos), FACTORY.scalar().cast(aSin));
    }

    @Override
    public void set(long aRow, long aCol, double aNmbr) {
        this.myUtility.set(aRow, aCol, aNmbr);
    }

    @Override
    public void set(long aRow, long aCol, Number aNmbr) {
        this.myUtility.set(aRow, aCol, aNmbr);
    }

    @Override
    public void setToIdentity(int aCol) {
        this.myUtility.set((long)aCol, (long)aCol, BigMath.ONE);
        this.myUtility.fillColumn((long)(aCol + 1), (long)aCol, BigMath.ZERO);
    }

    @Override
    public Array1D<BigDecimal> sliceColumn(long row, long column) {
        return this.myUtility.sliceColumn(row, column);
    }

    @Override
    public Array1D<BigDecimal> sliceDiagonal(long row, long column) {
        return this.myUtility.sliceDiagonal(row, column);
    }

    @Override
    public Array1D<BigDecimal> sliceRange(long first, long limit) {
        return this.myUtility.sliceRange(first, limit);
    }

    @Override
    public Array1D<BigDecimal> sliceRow(long row, long column) {
        return this.myUtility.sliceRow(row, column);
    }

    @Override
    public void substituteBackwards(final Access2D<BigDecimal> body, final boolean unitDiagonal, final boolean conjugated, final boolean hermitian) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim > SubstituteBackwards.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int aFirst, int aLimit) {
                    SubstituteBackwards.invoke((BigDecimal[])BigDenseStore.this.data, tmpRowDim, aFirst, aLimit, body, unitDiagonal, conjugated, hermitian);
                }
            };
            tmpConquerer.invoke(0, tmpColDim, SubstituteBackwards.THRESHOLD);
        } else {
            SubstituteBackwards.invoke((BigDecimal[])this.data, tmpRowDim, 0, tmpColDim, body, unitDiagonal, conjugated, hermitian);
        }
    }

    @Override
    public void substituteForwards(final Access2D<BigDecimal> body, final boolean unitDiagonal, final boolean conjugated, final boolean identity) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim > SubstituteForwards.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int aFirst, int aLimit) {
                    SubstituteForwards.invoke((BigDecimal[])BigDenseStore.this.data, tmpRowDim, aFirst, aLimit, body, unitDiagonal, conjugated, identity);
                }
            };
            tmpConquerer.invoke(0, tmpColDim, SubstituteForwards.THRESHOLD);
        } else {
            SubstituteForwards.invoke((BigDecimal[])this.data, tmpRowDim, 0, tmpColDim, body, unitDiagonal, conjugated, identity);
        }
    }

    @Override
    public void supplyTo(ElementsConsumer<BigDecimal> consumer) {
        consumer.fillMatching(this);
    }

    public BigScalar toScalar(long row, long column) {
        return BigScalar.of(this.get(row, column));
    }

    @Override
    public final String toString() {
        return MatrixUtils.toString(this);
    }

    @Override
    public void transformLeft(Householder<BigDecimal> transformation, int firstColumn) {
        final Householder.Big tmpTransf = BigDenseStore.cast(transformation);
        final BigDecimal[] tmpData = (BigDecimal[])this.data;
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim - firstColumn > HouseholderLeft.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int aFirst, int aLimit) {
                    HouseholderLeft.invoke(tmpData, tmpRowDim, aFirst, aLimit, tmpTransf);
                }
            };
            tmpConquerer.invoke(firstColumn, tmpColDim, HouseholderLeft.THRESHOLD);
        } else {
            HouseholderLeft.invoke(tmpData, tmpRowDim, firstColumn, tmpColDim, tmpTransf);
        }
    }

    @Override
    public void transformLeft(Rotation<BigDecimal> transformation) {
        Rotation.Big tmpTransf = BigDenseStore.cast(transformation);
        int tmpLow = tmpTransf.low;
        int tmpHigh = tmpTransf.high;
        if (tmpLow != tmpHigh) {
            if (tmpTransf.cos != null && tmpTransf.sin != null) {
                RotateLeft.invoke((BigDecimal[])this.data, this.myColDim, tmpLow, tmpHigh, tmpTransf.cos, tmpTransf.sin);
            } else {
                this.myUtility.exchangeRows(tmpLow, tmpHigh);
            }
        } else if (tmpTransf.cos != null) {
            this.myUtility.modifyRow(tmpLow, 0L, BigFunction.MULTIPLY.second(tmpTransf.cos));
        } else if (tmpTransf.sin != null) {
            this.myUtility.modifyRow(tmpLow, 0L, BigFunction.DIVIDE.second(tmpTransf.sin));
        } else {
            this.myUtility.modifyRow(tmpLow, 0L, BigFunction.NEGATE);
        }
    }

    @Override
    public void transformRight(Householder<BigDecimal> transformation, int firstRow) {
        final Householder.Big tmpTransf = BigDenseStore.cast(transformation);
        final BigDecimal[] tmpData = (BigDecimal[])this.data;
        int tmpRowDim = this.myRowDim;
        final int tmpColDim = this.myColDim;
        if (tmpRowDim - firstRow > HouseholderRight.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int aFirst, int aLimit) {
                    HouseholderRight.invoke(tmpData, aFirst, aLimit, tmpColDim, tmpTransf);
                }
            };
            tmpConquerer.invoke(firstRow, tmpRowDim, HouseholderRight.THRESHOLD);
        } else {
            HouseholderRight.invoke(tmpData, firstRow, tmpRowDim, tmpColDim, tmpTransf);
        }
    }

    @Override
    public void transformRight(Rotation<BigDecimal> transformation) {
        Rotation.Big tmpTransf = BigDenseStore.cast(transformation);
        int tmpLow = tmpTransf.low;
        int tmpHigh = tmpTransf.high;
        if (tmpLow != tmpHigh) {
            if (tmpTransf.cos != null && tmpTransf.sin != null) {
                RotateRight.invoke((BigDecimal[])this.data, this.myRowDim, tmpLow, tmpHigh, tmpTransf.cos, tmpTransf.sin);
            } else {
                this.myUtility.exchangeColumns(tmpLow, tmpHigh);
            }
        } else if (tmpTransf.cos != null) {
            this.myUtility.modifyColumn(0L, tmpHigh, BigFunction.MULTIPLY.second(tmpTransf.cos));
        } else if (tmpTransf.sin != null) {
            this.myUtility.modifyColumn(0L, tmpHigh, BigFunction.DIVIDE.second(tmpTransf.sin));
        } else {
            this.myUtility.modifyColumn(0L, tmpHigh, BigFunction.NEGATE);
        }
    }

    @Override
    public void transformSymmetric(Householder<BigDecimal> transformation) {
        HouseholderHermitian.invoke((BigDecimal[])this.data, BigDenseStore.cast(transformation), new BigDecimal[(int)transformation.count()]);
    }

    @Override
    public MatrixStore<BigDecimal> transpose() {
        return new TransposedStore<BigDecimal>(this);
    }

    @Override
    public void tred2(BasicArray<BigDecimal> mainDiagonal, BasicArray<BigDecimal> offDiagonal, boolean yesvecs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitColumn(long row, long column, VoidFunction<BigDecimal> visitor) {
        this.myUtility.visitColumn(row, column, visitor);
    }

    @Override
    public void visitDiagonal(long row, long column, VoidFunction<BigDecimal> visitor) {
        this.myUtility.visitDiagonal(row, column, visitor);
    }

    @Override
    public void visitRow(long row, long column, VoidFunction<BigDecimal> visitor) {
        this.myUtility.visitRow(row, column, visitor);
    }

    int getColDim() {
        return this.myColDim;
    }

    int getMaxDim() {
        return Math.max(this.myRowDim, this.myColDim);
    }

    int getMinDim() {
        return Math.min(this.myRowDim, this.myColDim);
    }

    int getRowDim() {
        return this.myRowDim;
    }

    public static interface BigMultiplyRight {
        public void invoke(BigDecimal[] var1, BigDecimal[] var2, int var3, Access1D<BigDecimal> var4);
    }

    public static interface BigMultiplyLeft {
        public void invoke(BigDecimal[] var1, Access1D<BigDecimal> var2, int var3, BigDecimal[] var4);
    }

    public static interface BigMultiplyBoth
    extends PhysicalStore.FillByMultiplying<BigDecimal> {
    }
}

