/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.function.BinaryFunction;
import org.ojalgo.matrix.store.ContextSupplier;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.MatrixStore;

final class BinaryOperatorSupplier<N extends Number>
extends ContextSupplier<N> {
    private final BinaryFunction<N> myFunction;
    private final MatrixStore<N> myLeft;
    private final MatrixStore<N> myRight;

    private BinaryOperatorSupplier(MatrixStore<N> context) {
        super(context);
        this.myLeft = null;
        this.myFunction = null;
        this.myRight = null;
    }

    BinaryOperatorSupplier(MatrixStore<N> left, BinaryFunction<N> function, MatrixStore<N> right) {
        super(left);
        this.myLeft = left;
        this.myFunction = function;
        this.myRight = right;
    }

    @Override
    public long count() {
        return this.myRight.count();
    }

    @Override
    public long countColumns() {
        return this.myRight.countColumns();
    }

    @Override
    public long countRows() {
        return this.myRight.countRows();
    }

    @Override
    public void supplyTo(ElementsConsumer<N> consumer) {
        consumer.fillMatching(this.myLeft, this.myFunction, this.myRight);
    }
}

