/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.util.List;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.AccessUtils;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.ComplexArray;
import org.ojalgo.concurrent.DivideAndConquer;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.ComplexFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.ComplexAggregator;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.store.ConjugatedStore;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.TransposedStore;
import org.ojalgo.matrix.store.operation.AXPY;
import org.ojalgo.matrix.store.operation.AggregateAll;
import org.ojalgo.matrix.store.operation.ApplyCholesky;
import org.ojalgo.matrix.store.operation.ApplyLDL;
import org.ojalgo.matrix.store.operation.ApplyLU;
import org.ojalgo.matrix.store.operation.FillConjugated;
import org.ojalgo.matrix.store.operation.FillMatchingLeft;
import org.ojalgo.matrix.store.operation.FillMatchingRight;
import org.ojalgo.matrix.store.operation.FillMatchingSingle;
import org.ojalgo.matrix.store.operation.FillTransposed;
import org.ojalgo.matrix.store.operation.GenerateApplyAndCopyHouseholderColumn;
import org.ojalgo.matrix.store.operation.GenerateApplyAndCopyHouseholderRow;
import org.ojalgo.matrix.store.operation.HouseholderHermitian;
import org.ojalgo.matrix.store.operation.HouseholderLeft;
import org.ojalgo.matrix.store.operation.HouseholderRight;
import org.ojalgo.matrix.store.operation.MAXPY;
import org.ojalgo.matrix.store.operation.ModifyAll;
import org.ojalgo.matrix.store.operation.MultiplyBoth;
import org.ojalgo.matrix.store.operation.MultiplyLeft;
import org.ojalgo.matrix.store.operation.MultiplyRight;
import org.ojalgo.matrix.store.operation.RotateLeft;
import org.ojalgo.matrix.store.operation.RotateRight;
import org.ojalgo.matrix.store.operation.SubstituteBackwards;
import org.ojalgo.matrix.store.operation.SubstituteForwards;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.matrix.transformation.Rotation;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.context.NumberContext;

public final class ComplexDenseStore
extends ComplexArray
implements PhysicalStore<ComplexNumber>,
DecompositionStore<ComplexNumber> {
    public static final PhysicalStore.Factory<ComplexNumber, ComplexDenseStore> FACTORY = new PhysicalStore.Factory<ComplexNumber, ComplexDenseStore>(){

        @Override
        public AggregatorSet<ComplexNumber> aggregator() {
            return ComplexAggregator.getSet();
        }

        @Override
        public MatrixStore.Factory<ComplexNumber> builder() {
            return MatrixStore.COMPLEX;
        }

        @Override
        public ComplexDenseStore columns(Access1D<?> ... source) {
            int tmpRowDim = (int)source[0].count();
            int tmpColDim = source.length;
            ComplexNumber[] tmpData = new ComplexNumber[tmpRowDim * tmpColDim];
            for (int j = 0; j < tmpColDim; ++j) {
                Access1D<?> tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = ComplexNumber.valueOf(tmpColumn.get(i));
                }
            }
            return new ComplexDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public ComplexDenseStore columns(double[] ... source) {
            int tmpRowDim = source[0].length;
            int tmpColDim = source.length;
            ComplexNumber[] tmpData = new ComplexNumber[tmpRowDim * tmpColDim];
            for (int j = 0; j < tmpColDim; ++j) {
                double[] tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = ComplexNumber.valueOf((Number)tmpColumn[i]);
                }
            }
            return new ComplexDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public ComplexDenseStore columns(List<? extends Number> ... source) {
            int tmpRowDim = source[0].size();
            int tmpColDim = source.length;
            ComplexNumber[] tmpData = new ComplexNumber[tmpRowDim * tmpColDim];
            for (int j = 0; j < tmpColDim; ++j) {
                List<? extends Number> tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = ComplexNumber.valueOf(tmpColumn.get(i));
                }
            }
            return new ComplexDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public ComplexDenseStore columns(Number[] ... source) {
            int tmpRowDim = source[0].length;
            int tmpColDim = source.length;
            ComplexNumber[] tmpData = new ComplexNumber[tmpRowDim * tmpColDim];
            for (int j = 0; j < tmpColDim; ++j) {
                Number[] tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = ComplexNumber.valueOf(tmpColumn[i]);
                }
            }
            return new ComplexDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public ComplexDenseStore conjugate(final Access2D<?> source) {
            final ComplexDenseStore retVal = new ComplexDenseStore((int)source.countColumns(), (int)source.countRows());
            final int tmpRowDim = retVal.getRowDim();
            int tmpColDim = retVal.getColDim();
            if (tmpColDim > FillConjugated.THRESHOLD) {
                DivideAndConquer tmpConquerer = new DivideAndConquer(){

                    @Override
                    public void conquer(int aFirst, int aLimit) {
                        FillConjugated.invoke((ComplexNumber[])retVal.data, tmpRowDim, aFirst, aLimit, source);
                    }
                };
                tmpConquerer.invoke(0, tmpColDim, FillConjugated.THRESHOLD);
            } else {
                FillConjugated.invoke((ComplexNumber[])retVal.data, tmpRowDim, 0, tmpColDim, source);
            }
            return retVal;
        }

        @Override
        public ComplexDenseStore copy(final Access2D<?> source) {
            final int tmpRowDim = (int)source.countRows();
            int tmpColDim = (int)source.countColumns();
            final ComplexDenseStore retVal = new ComplexDenseStore(tmpRowDim, tmpColDim);
            if (tmpColDim > FillMatchingSingle.THRESHOLD) {
                DivideAndConquer tmpConquerer = new DivideAndConquer(){

                    @Override
                    public void conquer(int aFirst, int aLimit) {
                        FillMatchingSingle.invoke((ComplexNumber[])retVal.data, tmpRowDim, aFirst, aLimit, (Access1D<? extends Number>)source);
                    }
                };
                tmpConquerer.invoke(0, tmpColDim, FillMatchingSingle.THRESHOLD);
            } else {
                FillMatchingSingle.invoke((ComplexNumber[])retVal.data, tmpRowDim, 0, tmpColDim, source);
            }
            return retVal;
        }

        @Override
        public FunctionSet<ComplexNumber> function() {
            return ComplexFunction.getSet();
        }

        public ComplexArray makeArray(int length) {
            return ComplexArray.make(length);
        }

        @Override
        public ComplexDenseStore makeEye(long rows, long columns) {
            ComplexDenseStore retVal = this.makeZero(rows, columns);
            retVal.myUtility.fillDiagonal(0L, 0L, ComplexNumber.ONE);
            return retVal;
        }

        @Override
        public ComplexDenseStore makeFilled(long rows, long columns, NullaryFunction<?> supplier) {
            int tmpRowDim = (int)rows;
            int tmpColDim = (int)columns;
            int tmpLength = tmpRowDim * tmpColDim;
            ComplexNumber[] tmpData = new ComplexNumber[tmpLength];
            for (int i = 0; i < tmpLength; ++i) {
                tmpData[i] = ComplexNumber.valueOf((Number)supplier.get());
            }
            return new ComplexDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        public Householder.Complex makeHouseholder(int length) {
            return new Householder.Complex(length);
        }

        public Rotation.Complex makeRotation(int low, int high, ComplexNumber cos, ComplexNumber sin) {
            return new Rotation.Complex(low, high, cos, sin);
        }

        public Rotation.Complex makeRotation(int low, int high, double cos, double sin) {
            return this.makeRotation(low, high, ComplexNumber.valueOf(cos), ComplexNumber.valueOf(sin));
        }

        @Override
        public ComplexDenseStore makeZero(long rows, long columns) {
            return new ComplexDenseStore((int)rows, (int)columns);
        }

        @Override
        public ComplexDenseStore rows(Access1D<?> ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = (int)source[0].count();
            ComplexNumber[] tmpData = new ComplexNumber[tmpRowDim * tmpColDim];
            for (int i = 0; i < tmpRowDim; ++i) {
                Access1D<?> tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = ComplexNumber.valueOf(tmpRow.get(j));
                }
            }
            return new ComplexDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public ComplexDenseStore rows(double[] ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = source[0].length;
            ComplexNumber[] tmpData = new ComplexNumber[tmpRowDim * tmpColDim];
            for (int i = 0; i < tmpRowDim; ++i) {
                double[] tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = ComplexNumber.valueOf((Number)tmpRow[j]);
                }
            }
            return new ComplexDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public ComplexDenseStore rows(List<? extends Number> ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = source[0].size();
            ComplexNumber[] tmpData = new ComplexNumber[tmpRowDim * tmpColDim];
            for (int i = 0; i < tmpRowDim; ++i) {
                List<? extends Number> tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = ComplexNumber.valueOf(tmpRow.get(j));
                }
            }
            return new ComplexDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public ComplexDenseStore rows(Number[] ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = source[0].length;
            ComplexNumber[] tmpData = new ComplexNumber[tmpRowDim * tmpColDim];
            for (int i = 0; i < tmpRowDim; ++i) {
                Number[] tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = ComplexNumber.valueOf(tmpRow[j]);
                }
            }
            return new ComplexDenseStore(tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public Scalar.Factory<ComplexNumber> scalar() {
            return ComplexNumber.FACTORY;
        }

        @Override
        public ComplexDenseStore transpose(final Access2D<?> source) {
            final ComplexDenseStore retVal = new ComplexDenseStore((int)source.countColumns(), (int)source.countRows());
            final int tmpRowDim = retVal.getRowDim();
            int tmpColDim = retVal.getColDim();
            if (tmpColDim > FillTransposed.THRESHOLD) {
                DivideAndConquer tmpConquerer = new DivideAndConquer(){

                    @Override
                    public void conquer(int aFirst, int aLimit) {
                        FillTransposed.invoke((ComplexNumber[])retVal.data, tmpRowDim, aFirst, aLimit, source);
                    }
                };
                tmpConquerer.invoke(0, tmpColDim, FillTransposed.THRESHOLD);
            } else {
                FillTransposed.invoke((ComplexNumber[])retVal.data, tmpRowDim, 0, tmpColDim, source);
            }
            return retVal;
        }
    };
    private final ComplexMultiplyBoth multiplyBoth;
    private final ComplexMultiplyLeft multiplyLeft;
    private final ComplexMultiplyRight multiplyRight;
    private final int myColDim;
    private final int myRowDim;
    private final Array2D<ComplexNumber> myUtility;

    static ComplexDenseStore cast(Access1D<ComplexNumber> matrix) {
        if (matrix instanceof ComplexDenseStore) {
            return (ComplexDenseStore)matrix;
        }
        if (matrix instanceof Access2D) {
            return (ComplexDenseStore)FACTORY.copy((Access2D)matrix);
        }
        return (ComplexDenseStore)FACTORY.columns(matrix);
    }

    static Householder.Complex cast(Householder<ComplexNumber> transformation) {
        if (transformation instanceof Householder.Complex) {
            return (Householder.Complex)transformation;
        }
        if (transformation instanceof DecompositionStore.HouseholderReference) {
            return ((DecompositionStore.HouseholderReference)transformation).getComplexWorker().copy(transformation);
        }
        return new Householder.Complex(transformation);
    }

    static Rotation.Complex cast(Rotation<ComplexNumber> transformation) {
        if (transformation instanceof Rotation.Complex) {
            return (Rotation.Complex)transformation;
        }
        return new Rotation.Complex(transformation);
    }

    ComplexDenseStore(ComplexNumber[] anArray) {
        super(anArray);
        this.myRowDim = anArray.length;
        this.myColDim = 1;
        this.myUtility = this.asArray2D(this.myRowDim);
        this.multiplyBoth = MultiplyBoth.getComplex(this.myRowDim, this.myColDim);
        this.multiplyLeft = MultiplyLeft.getComplex(this.myRowDim, this.myColDim);
        this.multiplyRight = MultiplyRight.getComplex(this.myRowDim, this.myColDim);
    }

    ComplexDenseStore(int aLength) {
        super(aLength);
        this.myRowDim = aLength;
        this.myColDim = 1;
        this.myUtility = this.asArray2D(this.myRowDim);
        this.multiplyBoth = MultiplyBoth.getComplex(this.myRowDim, this.myColDim);
        this.multiplyLeft = MultiplyLeft.getComplex(this.myRowDim, this.myColDim);
        this.multiplyRight = MultiplyRight.getComplex(this.myRowDim, this.myColDim);
    }

    ComplexDenseStore(int aRowDim, int aColDim) {
        super(aRowDim * aColDim);
        this.myRowDim = aRowDim;
        this.myColDim = aColDim;
        this.myUtility = this.asArray2D(this.myRowDim);
        this.multiplyBoth = MultiplyBoth.getComplex(this.myRowDim, this.myColDim);
        this.multiplyLeft = MultiplyLeft.getComplex(this.myRowDim, this.myColDim);
        this.multiplyRight = MultiplyRight.getComplex(this.myRowDim, this.myColDim);
    }

    ComplexDenseStore(int aRowDim, int aColDim, ComplexNumber[] anArray) {
        super(anArray);
        this.myRowDim = aRowDim;
        this.myColDim = aColDim;
        this.myUtility = this.asArray2D(this.myRowDim);
        this.multiplyBoth = MultiplyBoth.getComplex(this.myRowDim, this.myColDim);
        this.multiplyLeft = MultiplyLeft.getComplex(this.myRowDim, this.myColDim);
        this.multiplyRight = MultiplyRight.getComplex(this.myRowDim, this.myColDim);
    }

    @Override
    public void accept(Access2D<ComplexNumber> supplied) {
        for (long j = 0L; j < supplied.countColumns(); ++j) {
            for (long i = 0L; i < supplied.countRows(); ++i) {
                this.set(i, j, supplied.get(i, j));
            }
        }
    }

    @Override
    public void add(long row, long column, double addend) {
        this.myUtility.add(row, column, addend);
    }

    @Override
    public void add(long row, long column, Number addend) {
        this.myUtility.add(row, column, addend);
    }

    @Override
    public ComplexNumber aggregateAll(final Aggregator aggregator) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        final AggregatorFunction<ComplexNumber> tmpMainAggr = aggregator.getComplexFunction();
        if (tmpColDim > AggregateAll.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void conquer(int aFirst, int aLimit) {
                    AggregatorFunction<ComplexNumber> tmpPartAggr = aggregator.getComplexFunction();
                    ComplexDenseStore.this.visit(tmpRowDim * aFirst, tmpRowDim * aLimit, 1, tmpPartAggr);
                    AggregatorFunction aggregatorFunction = tmpMainAggr;
                    synchronized (aggregatorFunction) {
                        tmpMainAggr.merge(tmpPartAggr.getNumber());
                    }
                }
            };
            tmpConquerer.invoke(0, tmpColDim, AggregateAll.THRESHOLD);
        } else {
            this.visit(0, this.size(), 1, tmpMainAggr);
        }
        return tmpMainAggr.getNumber();
    }

    @Override
    public void applyCholesky(int iterationPoint, BasicArray<ComplexNumber> multipliers) {
        final ComplexNumber[] tmpData = (ComplexNumber[])this.data;
        final ComplexNumber[] tmpColumn = (ComplexNumber[])((ComplexArray)multipliers).data;
        if (this.myColDim - iterationPoint - 1 > ApplyCholesky.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int aFirst, int aLimit) {
                    ApplyCholesky.invoke(tmpData, ComplexDenseStore.this.myRowDim, aFirst, aLimit, tmpColumn);
                }
            };
            tmpConquerer.invoke(iterationPoint + 1, this.myColDim, ApplyCholesky.THRESHOLD);
        } else {
            ApplyCholesky.invoke(tmpData, this.myRowDim, iterationPoint + 1, this.myColDim, tmpColumn);
        }
    }

    @Override
    public void applyLDL(final int iterationPoint, BasicArray<ComplexNumber> multipliers) {
        final ComplexNumber[] tmpData = (ComplexNumber[])this.data;
        final ComplexNumber[] tmpColumn = (ComplexNumber[])((ComplexArray)multipliers).data;
        if (this.myColDim - iterationPoint - 1 > ApplyLDL.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int first, int limit) {
                    ApplyLDL.invoke(tmpData, ComplexDenseStore.this.myRowDim, first, limit, tmpColumn, iterationPoint);
                }
            };
            tmpConquerer.invoke(iterationPoint + 1, this.myColDim, ApplyLDL.THRESHOLD);
        } else {
            ApplyLDL.invoke(tmpData, this.myRowDim, iterationPoint + 1, this.myColDim, tmpColumn, iterationPoint);
        }
    }

    @Override
    public void applyLU(final int iterationPoint, BasicArray<ComplexNumber> multipliers) {
        final ComplexNumber[] tmpData = (ComplexNumber[])this.data;
        final ComplexNumber[] tmpColumn = (ComplexNumber[])((ComplexArray)multipliers).data;
        if (this.myColDim - iterationPoint - 1 > ApplyLU.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int aFirst, int aLimit) {
                    ApplyLU.invoke(tmpData, ComplexDenseStore.this.myRowDim, aFirst, aLimit, tmpColumn, iterationPoint);
                }
            };
            tmpConquerer.invoke(iterationPoint + 1, this.myColDim, ApplyLU.THRESHOLD);
        } else {
            ApplyLU.invoke(tmpData, this.myRowDim, iterationPoint + 1, this.myColDim, tmpColumn, iterationPoint);
        }
    }

    @Override
    public Array2D<ComplexNumber> asArray2D() {
        return this.myUtility;
    }

    @Override
    public Array1D<ComplexNumber> asList() {
        return this.myUtility.asArray1D();
    }

    @Override
    public final MatrixStore.Builder<ComplexNumber> builder() {
        return new MatrixStore.Builder<ComplexNumber>(this);
    }

    @Override
    public void caxpy(ComplexNumber scalarA, int columnX, int columnY, int firstRow) {
        AXPY.invoke((ComplexNumber[])this.data, columnY * this.myRowDim + firstRow, 1, scalarA, (ComplexNumber[])this.data, columnX * this.myRowDim + firstRow, 1, this.myRowDim - firstRow);
    }

    @Override
    public Array1D<ComplexNumber> computeInPlaceSchur(PhysicalStore<ComplexNumber> transformationCollector, boolean eigenvalue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MatrixStore<ComplexNumber> conjugate() {
        return new ConjugatedStore<ComplexNumber>(this);
    }

    public ComplexDenseStore copy() {
        return new ComplexDenseStore(this.myRowDim, this.myColDim, (ComplexNumber[])this.copyOfData());
    }

    @Override
    public long countColumns() {
        return this.myColDim;
    }

    @Override
    public long countRows() {
        return this.myRowDim;
    }

    @Override
    public void divideAndCopyColumn(int row, int column, BasicArray<ComplexNumber> destination) {
        ComplexNumber[] tmpData = (ComplexNumber[])this.data;
        int tmpRowDim = this.myRowDim;
        ComplexNumber[] tmpDestination = (ComplexNumber[])((ComplexArray)destination).data;
        int tmpIndex = row + column * tmpRowDim;
        ComplexNumber tmpDenominator = tmpData[tmpIndex];
        for (int i = row + 1; i < tmpRowDim; ++i) {
            tmpDestination[i] = tmpData[tmpIndex] = tmpData[++tmpIndex].divide(tmpDenominator);
        }
    }

    @Override
    public double doubleValue(long aRow, long aCol) {
        return this.doubleValue(aRow + aCol * (long)this.myRowDim);
    }

    @Override
    public boolean equals(MatrixStore<ComplexNumber> other, NumberContext context) {
        return AccessUtils.equals(this, other, context);
    }

    @Override
    public boolean equals(Object anObj) {
        if (anObj instanceof MatrixStore) {
            return this.equals((MatrixStore)anObj, NumberContext.getGeneral(6));
        }
        return super.equals(anObj);
    }

    @Override
    public void exchangeColumns(long colA, long colB) {
        this.myUtility.exchangeColumns(colA, colB);
    }

    @Override
    public void exchangeHermitian(int indexA, int indexB) {
        ComplexNumber tmpVal;
        int tmpMin = Math.min(indexA, indexB);
        int tmpMax = Math.max(indexA, indexB);
        for (int j = 0; j < tmpMin; ++j) {
            tmpVal = this.get(tmpMin, j);
            this.set((long)tmpMin, (long)j, this.get(tmpMax, j));
            this.set((long)tmpMax, (long)j, tmpVal);
        }
        tmpVal = this.get(tmpMin, tmpMin);
        this.set((long)tmpMin, (long)tmpMin, this.get(tmpMax, tmpMax));
        this.set((long)tmpMax, (long)tmpMax, tmpVal);
        for (int ij = tmpMin + 1; ij < tmpMax; ++ij) {
            tmpVal = this.get(ij, tmpMin);
            this.set((long)ij, (long)tmpMin, this.get(tmpMax, ij).conjugate());
            this.set((long)tmpMax, (long)ij, tmpVal.conjugate());
        }
        for (int i = tmpMax + 1; i < this.myRowDim; ++i) {
            tmpVal = this.get(i, tmpMin);
            this.set((long)i, (long)tmpMin, this.get(i, tmpMax));
            this.set((long)i, (long)tmpMax, tmpVal);
        }
    }

    @Override
    public void exchangeRows(long rowA, long rowB) {
        this.myUtility.exchangeRows(rowA, rowB);
    }

    @Override
    public PhysicalStore.Factory<ComplexNumber, ComplexDenseStore> factory() {
        return FACTORY;
    }

    @Override
    public void fillByMultiplying(Access1D<ComplexNumber> left, Access1D<ComplexNumber> right) {
        int tmpComplexity = (int)left.count() / this.myRowDim;
        if (right instanceof ComplexDenseStore) {
            this.multiplyLeft.invoke((ComplexNumber[])this.data, left, tmpComplexity, (ComplexNumber[])ComplexDenseStore.cast(right).data);
        } else if (left instanceof ComplexDenseStore) {
            this.multiplyRight.invoke((ComplexNumber[])this.data, (ComplexNumber[])ComplexDenseStore.cast(left).data, tmpComplexity, right);
        } else {
            this.multiplyBoth.invoke(this, left, tmpComplexity, right);
        }
    }

    @Override
    public void fillColumn(long row, long column, ComplexNumber value) {
        this.myUtility.fillColumn(row, column, value);
    }

    @Override
    public void fillColumn(long row, long column, NullaryFunction<ComplexNumber> supplier) {
        this.myUtility.fillColumn(row, column, supplier);
    }

    @Override
    public void fillDiagonal(long row, long column, ComplexNumber value) {
        this.myUtility.fillDiagonal(row, column, value);
    }

    @Override
    public void fillDiagonal(long row, long column, NullaryFunction<ComplexNumber> supplier) {
        this.myUtility.fillDiagonal(row, column, supplier);
    }

    public void fillMatching(final Access1D<ComplexNumber> aLeftArg, final BinaryFunction<ComplexNumber> aFunc, final ComplexNumber aRightArg) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim > FillMatchingLeft.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int aFirst, int aLimit) {
                    ComplexDenseStore.this.fill(tmpRowDim * aFirst, tmpRowDim * aLimit, aLeftArg, aFunc, aRightArg);
                }
            };
            tmpConquerer.invoke(0, tmpColDim, FillMatchingLeft.THRESHOLD);
        } else {
            this.fill(0, tmpRowDim * tmpColDim, aLeftArg, aFunc, aRightArg);
        }
    }

    public void fillMatching(final ComplexNumber aLeftArg, final BinaryFunction<ComplexNumber> aFunc, final Access1D<ComplexNumber> aRightArg) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim > FillMatchingRight.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int aFirst, int aLimit) {
                    ComplexDenseStore.this.fill(tmpRowDim * aFirst, tmpRowDim * aLimit, aLeftArg, aFunc, aRightArg);
                }
            };
            tmpConquerer.invoke(0, tmpColDim, FillMatchingRight.THRESHOLD);
        } else {
            this.fill(0, tmpRowDim * tmpColDim, aLeftArg, aFunc, aRightArg);
        }
    }

    @Override
    public void fillOne(long row, long column, ComplexNumber value) {
        this.myUtility.fillOne(row, column, value);
    }

    @Override
    public void fillOne(long row, long column, NullaryFunction<ComplexNumber> supplier) {
        this.myUtility.fillOne(row, column, supplier);
    }

    @Override
    public void fillOneMatching(long row, long column, Access1D<?> values, long valueIndex) {
        this.set(row, column, (Number)values.get(valueIndex));
    }

    @Override
    public void fillRow(long row, long column, ComplexNumber value) {
        this.myUtility.fillRow(row, column, value);
    }

    @Override
    public void fillRow(long row, long column, NullaryFunction<ComplexNumber> supplier) {
        this.myUtility.fillRow(row, column, supplier);
    }

    @Override
    public boolean generateApplyAndCopyHouseholderColumn(int row, int column, Householder<ComplexNumber> destination) {
        return GenerateApplyAndCopyHouseholderColumn.invoke((ComplexNumber[])this.data, this.myRowDim, row, column, (Householder.Complex)destination);
    }

    @Override
    public boolean generateApplyAndCopyHouseholderRow(int row, int column, Householder<ComplexNumber> destination) {
        return GenerateApplyAndCopyHouseholderRow.invoke((ComplexNumber[])this.data, this.myRowDim, row, column, (Householder.Complex)destination);
    }

    @Override
    public final MatrixStore<ComplexNumber> get() {
        return this;
    }

    @Override
    public ComplexNumber get(long aRow, long aCol) {
        return this.myUtility.get(aRow, aCol);
    }

    @Override
    public int hashCode() {
        return MatrixUtils.hashCode(this);
    }

    @Override
    public int indexOfLargestInColumn(int row, int column) {
        return (int)this.myUtility.indexOfLargestInColumn(row, column);
    }

    @Override
    public long indexOfLargestInColumn(long row, long column) {
        return this.myUtility.indexOfLargestInColumn(row, column);
    }

    @Override
    public int indexOfLargestInDiagonal(int row, int column) {
        return (int)this.myUtility.indexOfLargestInDiagonal(row, column);
    }

    @Override
    public long indexOfLargestInDiagonal(long row, long column) {
        return this.myUtility.indexOfLargestInDiagonal(row, column);
    }

    @Override
    public long indexOfLargestInRow(long row, long column) {
        return this.myUtility.indexOfLargestInRow(row, column);
    }

    @Override
    public boolean isAbsolute(long row, long column) {
        return this.myUtility.isAbsolute(row, column);
    }

    @Override
    public boolean isSmall(long row, long column, double comparedTo) {
        return this.myUtility.isSmall(row, column, comparedTo);
    }

    @Override
    public void maxpy(final ComplexNumber aSclrA, final MatrixStore<ComplexNumber> aMtrxX) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim > MAXPY.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int aFirst, int aLimit) {
                    MAXPY.invoke((ComplexNumber[])ComplexDenseStore.this.data, tmpRowDim, aFirst, aLimit, aSclrA, aMtrxX);
                }
            };
            tmpConquerer.invoke(0, tmpColDim, MAXPY.THRESHOLD);
        } else {
            MAXPY.invoke((ComplexNumber[])this.data, tmpRowDim, 0, tmpColDim, aSclrA, aMtrxX);
        }
    }

    @Override
    public void modifyAll(final UnaryFunction<ComplexNumber> aFunc) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim > ModifyAll.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int aFirst, int aLimit) {
                    ComplexDenseStore.this.modify(tmpRowDim * aFirst, tmpRowDim * aLimit, 1, aFunc);
                }
            };
            tmpConquerer.invoke(0, tmpColDim, ModifyAll.THRESHOLD);
        } else {
            this.modify(tmpRowDim * 0, tmpRowDim * tmpColDim, 1, aFunc);
        }
    }

    @Override
    public void modifyColumn(long row, long column, UnaryFunction<ComplexNumber> function) {
        this.myUtility.modifyColumn(row, column, function);
    }

    @Override
    public void modifyDiagonal(long row, long column, UnaryFunction<ComplexNumber> function) {
        this.myUtility.modifyDiagonal(row, column, function);
    }

    @Override
    public void modifyOne(long row, long column, UnaryFunction<ComplexNumber> function) {
        ComplexNumber tmpValue = this.get(row, column);
        tmpValue = function.invoke(tmpValue);
        this.set(row, column, tmpValue);
    }

    @Override
    public void modifyRow(long row, long column, UnaryFunction<ComplexNumber> function) {
        this.myUtility.modifyRow(row, column, function);
    }

    @Override
    public MatrixStore<ComplexNumber> multiply(Access1D<ComplexNumber> right) {
        ComplexDenseStore retVal = (ComplexDenseStore)FACTORY.makeZero(this.myRowDim, right.count() / (long)this.myColDim);
        if (right instanceof ComplexDenseStore) {
            retVal.multiplyLeft.invoke((ComplexNumber[])retVal.data, this, this.myColDim, (ComplexNumber[])((ComplexDenseStore)right).data);
        } else {
            retVal.multiplyRight.invoke((ComplexNumber[])retVal.data, (ComplexNumber[])this.data, this.myColDim, right);
        }
        return retVal;
    }

    @Override
    public ComplexNumber multiplyBoth(Access1D<ComplexNumber> leftAndRight) {
        PhysicalStore tmpStep1 = (PhysicalStore)FACTORY.makeZero(1L, leftAndRight.count());
        PhysicalStore tmpStep2 = (PhysicalStore)FACTORY.makeZero(1L, 1L);
        PhysicalStore tmpLeft = (PhysicalStore)FACTORY.rows(leftAndRight);
        tmpLeft.fillMatching(FACTORY.function().conjugate(), leftAndRight);
        tmpStep1.fillByMultiplying(tmpLeft, this);
        tmpStep2.fillByMultiplying(tmpStep1, leftAndRight);
        return (ComplexNumber)tmpStep2.get(0L);
    }

    @Override
    public void negateColumn(int column) {
        this.myUtility.modifyColumn(0L, column, ComplexFunction.NEGATE);
    }

    @Override
    public void raxpy(ComplexNumber scalarA, int rowX, int rowY, int firstColumn) {
        AXPY.invoke((ComplexNumber[])this.data, rowY + firstColumn * (((ComplexNumber[])this.data).length / this.myColDim), ((ComplexNumber[])this.data).length / this.myColDim, scalarA, (ComplexNumber[])this.data, rowX + firstColumn * (((ComplexNumber[])this.data).length / this.myColDim), ((ComplexNumber[])this.data).length / this.myColDim, this.myColDim - firstColumn);
    }

    @Override
    public final ElementsConsumer<ComplexNumber> regionByColumns(int ... columns) {
        return new PhysicalStore.ColumnsRegion<ComplexNumber>(this, this.multiplyBoth, columns);
    }

    @Override
    public final ElementsConsumer<ComplexNumber> regionByLimits(int rowLimit, int columnLimit) {
        return new PhysicalStore.LimitRegion<ComplexNumber>(this, this.multiplyBoth, rowLimit, columnLimit);
    }

    @Override
    public final ElementsConsumer<ComplexNumber> regionByOffsets(int rowOffset, int columnOffset) {
        return new PhysicalStore.OffsetRegion<ComplexNumber>(this, this.multiplyBoth, rowOffset, columnOffset);
    }

    @Override
    public final ElementsConsumer<ComplexNumber> regionByRows(int ... rows) {
        return new PhysicalStore.RowsRegion<ComplexNumber>(this, this.multiplyBoth, rows);
    }

    @Override
    public final ElementsConsumer<ComplexNumber> regionByTransposing() {
        return new PhysicalStore.TransposedRegion<ComplexNumber>(this, this.multiplyBoth);
    }

    @Override
    public void rotateRight(int aLow, int aHigh, double aCos, double aSin) {
        RotateRight.invoke((ComplexNumber[])this.data, this.myRowDim, aLow, aHigh, FACTORY.scalar().cast(aCos), FACTORY.scalar().cast(aSin));
    }

    @Override
    public void set(long aRow, long aCol, double aNmbr) {
        this.myUtility.set(aRow, aCol, aNmbr);
    }

    @Override
    public void set(long aRow, long aCol, Number aNmbr) {
        this.myUtility.set(aRow, aCol, aNmbr);
    }

    @Override
    public void setToIdentity(int aCol) {
        this.myUtility.set((long)aCol, (long)aCol, ComplexNumber.ONE);
        this.myUtility.fillColumn((long)(aCol + 1), (long)aCol, ComplexNumber.ZERO);
    }

    @Override
    public Array1D<ComplexNumber> sliceColumn(long row, long column) {
        return this.myUtility.sliceColumn(row, column);
    }

    @Override
    public Array1D<ComplexNumber> sliceDiagonal(long row, long column) {
        return this.myUtility.sliceDiagonal(row, column);
    }

    @Override
    public Array1D<ComplexNumber> sliceRange(long first, long limit) {
        return this.myUtility.sliceRange(first, limit);
    }

    @Override
    public Array1D<ComplexNumber> sliceRow(long row, long column) {
        return this.myUtility.sliceRow(row, column);
    }

    @Override
    public void substituteBackwards(final Access2D<ComplexNumber> body, final boolean unitDiagonal, final boolean conjugated, final boolean hermitian) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim > SubstituteBackwards.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int aFirst, int aLimit) {
                    SubstituteBackwards.invoke((ComplexNumber[])ComplexDenseStore.this.data, tmpRowDim, aFirst, aLimit, body, unitDiagonal, conjugated, hermitian);
                }
            };
            tmpConquerer.invoke(0, tmpColDim, SubstituteBackwards.THRESHOLD);
        } else {
            SubstituteBackwards.invoke((ComplexNumber[])this.data, tmpRowDim, 0, tmpColDim, body, unitDiagonal, conjugated, hermitian);
        }
    }

    @Override
    public void substituteForwards(final Access2D<ComplexNumber> body, final boolean unitDiagonal, final boolean conjugated, final boolean identity) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim > SubstituteForwards.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int aFirst, int aLimit) {
                    SubstituteForwards.invoke((ComplexNumber[])ComplexDenseStore.this.data, tmpRowDim, aFirst, aLimit, body, unitDiagonal, conjugated, identity);
                }
            };
            tmpConquerer.invoke(0, tmpColDim, SubstituteForwards.THRESHOLD);
        } else {
            SubstituteForwards.invoke((ComplexNumber[])this.data, tmpRowDim, 0, tmpColDim, body, unitDiagonal, conjugated, identity);
        }
    }

    @Override
    public void supplyTo(ElementsConsumer<ComplexNumber> consumer) {
        consumer.fillMatching(this);
    }

    @Override
    public Scalar<ComplexNumber> toScalar(long row, long column) {
        return this.myUtility.get(row, column);
    }

    @Override
    public final String toString() {
        return MatrixUtils.toString(this);
    }

    @Override
    public void transformLeft(Householder<ComplexNumber> transformation, int firstColumn) {
        final Householder.Complex tmpTransf = ComplexDenseStore.cast(transformation);
        final ComplexNumber[] tmpData = (ComplexNumber[])this.data;
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim - firstColumn > HouseholderLeft.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int aFirst, int aLimit) {
                    HouseholderLeft.invoke(tmpData, tmpRowDim, aFirst, aLimit, tmpTransf);
                }
            };
            tmpConquerer.invoke(firstColumn, tmpColDim, HouseholderLeft.THRESHOLD);
        } else {
            HouseholderLeft.invoke(tmpData, tmpRowDim, firstColumn, tmpColDim, tmpTransf);
        }
    }

    @Override
    public void transformLeft(Rotation<ComplexNumber> transformation) {
        Rotation.Complex tmpTransf = ComplexDenseStore.cast(transformation);
        int tmpLow = tmpTransf.low;
        int tmpHigh = tmpTransf.high;
        if (tmpLow != tmpHigh) {
            if (tmpTransf.cos != null && tmpTransf.sin != null) {
                RotateLeft.invoke((ComplexNumber[])this.data, this.myColDim, tmpLow, tmpHigh, tmpTransf.cos, tmpTransf.sin);
            } else {
                this.myUtility.exchangeRows(tmpLow, tmpHigh);
            }
        } else if (tmpTransf.cos != null) {
            this.myUtility.modifyRow(tmpLow, 0L, ComplexFunction.MULTIPLY.second(tmpTransf.cos));
        } else if (tmpTransf.sin != null) {
            this.myUtility.modifyRow(tmpLow, 0L, ComplexFunction.DIVIDE.second(tmpTransf.sin));
        } else {
            this.myUtility.modifyRow(tmpLow, 0L, ComplexFunction.NEGATE);
        }
    }

    @Override
    public void transformRight(Householder<ComplexNumber> transformation, int firstRow) {
        final Householder.Complex tmpTransf = ComplexDenseStore.cast(transformation);
        final ComplexNumber[] tmpData = (ComplexNumber[])this.data;
        int tmpRowDim = this.myRowDim;
        final int tmpColDim = this.myColDim;
        if (tmpRowDim - firstRow > HouseholderRight.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int aFirst, int aLimit) {
                    HouseholderRight.invoke(tmpData, aFirst, aLimit, tmpColDim, tmpTransf);
                }
            };
            tmpConquerer.invoke(firstRow, tmpRowDim, HouseholderRight.THRESHOLD);
        } else {
            HouseholderRight.invoke(tmpData, firstRow, tmpRowDim, tmpColDim, tmpTransf);
        }
    }

    @Override
    public void transformRight(Rotation<ComplexNumber> transformation) {
        Rotation.Complex tmpTransf = ComplexDenseStore.cast(transformation);
        int tmpLow = tmpTransf.low;
        int tmpHigh = tmpTransf.high;
        if (tmpLow != tmpHigh) {
            if (tmpTransf.cos != null && tmpTransf.sin != null) {
                RotateRight.invoke((ComplexNumber[])this.data, this.myRowDim, tmpLow, tmpHigh, tmpTransf.cos, tmpTransf.sin);
            } else {
                this.myUtility.exchangeColumns(tmpLow, tmpHigh);
            }
        } else if (tmpTransf.cos != null) {
            this.myUtility.modifyColumn(0L, tmpHigh, ComplexFunction.MULTIPLY.second(tmpTransf.cos));
        } else if (tmpTransf.sin != null) {
            this.myUtility.modifyColumn(0L, tmpHigh, ComplexFunction.DIVIDE.second(tmpTransf.sin));
        } else {
            this.myUtility.modifyColumn(0L, tmpHigh, ComplexFunction.NEGATE);
        }
    }

    @Override
    public void transformSymmetric(Householder<ComplexNumber> transformation) {
        HouseholderHermitian.invoke((ComplexNumber[])this.data, ComplexDenseStore.cast(transformation), new ComplexNumber[(int)transformation.count()]);
    }

    @Override
    public MatrixStore<ComplexNumber> transpose() {
        return new TransposedStore<ComplexNumber>(this);
    }

    @Override
    public void tred2(BasicArray<ComplexNumber> mainDiagonal, BasicArray<ComplexNumber> offDiagonal, boolean yesvecs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitAll(VoidFunction<ComplexNumber> visitor) {
        this.myUtility.visitAll(visitor);
    }

    @Override
    public void visitColumn(long row, long column, VoidFunction<ComplexNumber> visitor) {
        this.myUtility.visitColumn(row, column, visitor);
    }

    @Override
    public void visitDiagonal(long row, long column, VoidFunction<ComplexNumber> visitor) {
        this.myUtility.visitDiagonal(row, column, visitor);
    }

    @Override
    public void visitRow(long row, long column, VoidFunction<ComplexNumber> visitor) {
        this.myUtility.visitRow(row, column, visitor);
    }

    int getColDim() {
        return this.myColDim;
    }

    int getMaxDim() {
        return Math.max(this.myRowDim, this.myColDim);
    }

    int getMinDim() {
        return Math.min(this.myRowDim, this.myColDim);
    }

    int getRowDim() {
        return this.myRowDim;
    }

    public static interface ComplexMultiplyRight {
        public void invoke(ComplexNumber[] var1, ComplexNumber[] var2, int var3, Access1D<ComplexNumber> var4);
    }

    public static interface ComplexMultiplyLeft {
        public void invoke(ComplexNumber[] var1, Access1D<ComplexNumber> var2, int var3, ComplexNumber[] var4);
    }

    public static interface ComplexMultiplyBoth
    extends PhysicalStore.FillByMultiplying<ComplexNumber> {
    }
}

