/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.access.Access1D;
import org.ojalgo.matrix.store.ContextSupplier;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.MatrixStore;

final class MatrixProductSupplier<N extends Number>
extends ContextSupplier<N> {
    private final Access1D<N> myLeft;
    private final MatrixStore<N> myRight;

    private MatrixProductSupplier(MatrixStore<N> base) {
        super(base);
        this.myLeft = null;
        this.myRight = null;
    }

    MatrixProductSupplier(Access1D<N> left, MatrixStore<N> right) {
        super(right);
        this.myLeft = left;
        this.myRight = right;
    }

    @Override
    public long countColumns() {
        return this.myRight.countColumns();
    }

    @Override
    public long countRows() {
        return this.myLeft.count() / this.myRight.countRows();
    }

    @Override
    public void supplyTo(ElementsConsumer<N> consumer) {
        consumer.fillByMultiplying(this.myLeft, this.myRight);
    }
}

