/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.FactoryStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.scalar.Scalar;

final class SingleStore<N extends Number>
extends FactoryStore<N> {
    private final N myNumber;
    private final double myValue;

    private SingleStore(PhysicalStore.Factory<N, ?> factory, int rowsCount, int columnsCount) {
        super(factory, rowsCount, columnsCount);
        this.myNumber = null;
        this.myValue = 0.0;
        ProgrammingError.throwForIllegalInvocation();
    }

    SingleStore(PhysicalStore.Factory<N, ?> factory, Number element) {
        super(factory, 1, 1);
        this.myNumber = factory.scalar().cast(element);
        this.myValue = ((Number)this.myNumber).doubleValue();
    }

    @Override
    public MatrixStore<N> conjugate() {
        return new SingleStore(this.factory(), (Number)((Scalar)this.factory().scalar().convert((Number)this.myNumber).conjugate()).getNumber());
    }

    @Override
    public double doubleValue(long anInd) {
        return this.myValue;
    }

    @Override
    public double doubleValue(long aRow, long aCol) {
        return this.myValue;
    }

    @Override
    public N get(long aRow, long aCol) {
        return this.myNumber;
    }

    @Override
    public MatrixStore<N> multiply(Access1D<N> right) {
        int tmpRowDim = this.getRowDim();
        int tmpColDim = (int)(right.count() / (long)this.getColDim());
        PhysicalStore.Factory tmpFactory = this.factory();
        PhysicalStore retVal = (PhysicalStore)tmpFactory.makeZero(tmpRowDim, tmpColDim);
        retVal.fillMatching(tmpFactory.function().multiply().first(this.myNumber), right);
        return retVal;
    }

    @Override
    public void supplyTo(ElementsConsumer<N> consumer) {
        this.supplyNonZerosTo(consumer);
    }

    @Override
    public Scalar<N> toScalar(long row, long column) {
        return this.factory().scalar().convert((Number)this.myNumber);
    }

    @Override
    public MatrixStore<N> transpose() {
        return this;
    }

    @Override
    protected void supplyNonZerosTo(ElementsConsumer<N> consumer) {
        consumer.fillOne(0L, 0L, this.myNumber);
    }
}

