/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.math.BigDecimal;
import org.ojalgo.constant.BigMath;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BigFunction;
import org.ojalgo.function.ComplexFunction;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.type.TypeUtils;

public final class GenerateApplyAndCopyHouseholderColumn
extends MatrixOperation {
    public static final GenerateApplyAndCopyHouseholderColumn SETUP = new GenerateApplyAndCopyHouseholderColumn();
    public static int THRESHOLD = 128;

    public static boolean invoke(BigDecimal[] data, int structure, int row, int col, Householder.Big destination) {
        int tmpColBase = col * structure;
        BigDecimal[] tmpVector = destination.vector;
        destination.first = row;
        BigDecimal tmpNormInf = BigMath.ZERO;
        for (int i = row; i < structure; ++i) {
            tmpVector[i] = data[i + tmpColBase];
            tmpNormInf = tmpNormInf.max(tmpVector[i].abs());
        }
        boolean retVal = tmpNormInf.signum() != 0;
        BigDecimal tmpNorm2 = BigMath.ZERO;
        if (retVal) {
            for (int i = row + 1; i < structure; ++i) {
                BigDecimal tmpVal = BigFunction.DIVIDE.invoke(tmpVector[i], tmpNormInf);
                tmpNorm2 = BigFunction.ADD.invoke(tmpNorm2, BigFunction.MULTIPLY.invoke(tmpVal, tmpVal));
                tmpVector[i] = tmpVal;
            }
            boolean bl = retVal = !TypeUtils.isZero(tmpNorm2.doubleValue());
        }
        if (retVal) {
            BigDecimal tmpScale = BigFunction.DIVIDE.invoke(tmpVector[row], tmpNormInf);
            tmpNorm2 = BigFunction.ADD.invoke(tmpNorm2, BigFunction.MULTIPLY.invoke(tmpScale, tmpScale));
            tmpNorm2 = BigFunction.SQRT.invoke(tmpNorm2);
            if (tmpScale.signum() != 1) {
                data[row + tmpColBase] = tmpNorm2.multiply(tmpNormInf);
                tmpScale = BigFunction.SUBTRACT.invoke(tmpScale, tmpNorm2);
            } else {
                data[row + tmpColBase] = tmpNorm2.negate().multiply(tmpNormInf);
                tmpScale = BigFunction.ADD.invoke(tmpScale, tmpNorm2);
            }
            tmpVector[row] = BigMath.ONE;
            for (int i = row + 1; i < structure; ++i) {
                data[i + tmpColBase] = tmpVector[i] = BigFunction.DIVIDE.invoke(tmpVector[i], tmpScale);
            }
            destination.beta = BigFunction.DIVIDE.invoke(tmpScale.abs(), tmpNorm2);
        }
        return retVal;
    }

    public static boolean invoke(ComplexNumber[] data, int structure, int row, int col, Householder.Complex destination) {
        int tmpColBase = col * structure;
        ComplexNumber[] tmpVector = destination.vector;
        destination.first = row;
        double tmpNormInf = PrimitiveMath.ZERO;
        for (int i = row; i < structure; ++i) {
            tmpVector[i] = data[i + tmpColBase];
            tmpNormInf = Math.max(tmpNormInf, tmpVector[i].norm());
        }
        boolean retVal = tmpNormInf != PrimitiveMath.ZERO;
        double tmpNorm2 = PrimitiveMath.ZERO;
        if (retVal) {
            for (int i = row + 1; i < structure; ++i) {
                ComplexNumber tmpVal = tmpVector[i].divide(tmpNormInf);
                tmpNorm2 += tmpVal.norm() * tmpVal.norm();
                tmpVector[i] = tmpVal;
            }
            boolean bl = retVal = !TypeUtils.isZero(tmpNorm2);
        }
        if (retVal) {
            ComplexNumber tmpScale = tmpVector[row].divide(tmpNormInf);
            tmpNorm2 += tmpScale.norm() * tmpScale.norm();
            tmpNorm2 = Math.sqrt(tmpNorm2);
            data[row + tmpColBase] = ComplexNumber.makePolar(tmpNorm2 * tmpNormInf, tmpScale.phase());
            tmpScale = tmpScale.subtract(ComplexNumber.makePolar(tmpNorm2, tmpScale.phase()));
            tmpVector[row] = ComplexNumber.ONE;
            for (int i = row + 1; i < structure; ++i) {
                data[i + tmpColBase] = tmpVector[i] = ComplexFunction.DIVIDE.invoke(tmpVector[i], tmpScale);
            }
            destination.beta = ComplexNumber.valueOf(tmpScale.norm() / tmpNorm2);
        }
        return retVal;
    }

    public static boolean invoke(double[] data, int structure, int row, int col, Householder.Primitive destination) {
        int tmpColBase = col * structure;
        double[] tmpVector = destination.vector;
        destination.first = row;
        double tmpNormInf = PrimitiveMath.ZERO;
        for (int i = row; i < structure; ++i) {
            tmpVector[i] = data[i + tmpColBase];
            tmpNormInf = Math.max(tmpNormInf, Math.abs(tmpVector[i]));
        }
        boolean retVal = tmpNormInf != PrimitiveMath.ZERO;
        double tmpNorm2 = PrimitiveMath.ZERO;
        if (retVal) {
            int i = row + 1;
            while (i < structure) {
                int n = i++;
                double d = tmpVector[n] / tmpNormInf;
                tmpVector[n] = d;
                double tmpVal = d;
                tmpNorm2 += tmpVal * tmpVal;
            }
            boolean bl = retVal = !TypeUtils.isZero(tmpNorm2);
        }
        if (retVal) {
            double tmpScale = tmpVector[row] / tmpNormInf;
            tmpNorm2 += tmpScale * tmpScale;
            tmpNorm2 = Math.sqrt(tmpNorm2);
            if (tmpScale <= PrimitiveMath.ZERO) {
                data[row + tmpColBase] = tmpNorm2 * tmpNormInf;
                tmpScale -= tmpNorm2;
            } else {
                data[row + tmpColBase] = -tmpNorm2 * tmpNormInf;
                tmpScale += tmpNorm2;
            }
            tmpVector[row] = PrimitiveMath.ONE;
            for (int i = row + 1; i < structure; ++i) {
                int n = i;
                double d = tmpVector[n] / tmpScale;
                tmpVector[n] = d;
                data[i + tmpColBase] = d;
            }
            destination.beta = Math.abs(tmpScale) / tmpNorm2;
        }
        return retVal;
    }

    private GenerateApplyAndCopyHouseholderColumn() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

