/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.math.BigDecimal;
import java.util.Arrays;
import org.ojalgo.concurrent.DivideAndConquer;
import org.ojalgo.constant.BigMath;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BigFunction;
import org.ojalgo.function.ComplexFunction;
import org.ojalgo.matrix.store.operation.Copy;
import org.ojalgo.matrix.store.operation.DotProduct;
import org.ojalgo.matrix.store.operation.HermitianRank2Update;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.matrix.store.operation.MultiplyHermitianAndVector;
import org.ojalgo.matrix.store.operation.SubtractScaledVector;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.scalar.ComplexNumber;

public final class HouseholderHermitian
extends MatrixOperation {
    public static final HouseholderHermitian SETUP = new HouseholderHermitian();
    public static int THRESHOLD = 64;

    public static void invoke(final BigDecimal[] data, Householder.Big householder, final BigDecimal[] worker) {
        int c;
        final BigDecimal[] tmpVector = householder.vector;
        final int tmpFirst = householder.first;
        int tmpLength = tmpVector.length;
        BigDecimal tmpBeta = householder.beta;
        int tmpCount = tmpLength - tmpFirst;
        if (tmpCount > THRESHOLD) {
            DivideAndConquer tmpConqurer = new DivideAndConquer(){

                @Override
                protected void conquer(int aFirst, int aLimit) {
                    MultiplyHermitianAndVector.invoke(worker, aFirst, aLimit, data, tmpVector, tmpFirst);
                }
            };
            tmpConqurer.invoke(tmpFirst, tmpLength, THRESHOLD);
        } else {
            MultiplyHermitianAndVector.invoke(worker, tmpFirst, tmpLength, data, tmpVector, tmpFirst);
        }
        BigDecimal tmpVal = BigMath.ZERO;
        for (c = tmpFirst; c < tmpLength; ++c) {
            tmpVal = tmpVal.add(tmpVector[c].multiply(worker[c]));
        }
        tmpVal = BigFunction.DIVIDE.invoke(tmpVal.multiply(tmpBeta), BigMath.TWO);
        for (c = tmpFirst; c < tmpLength; ++c) {
            worker[c] = tmpBeta.multiply(worker[c].subtract(tmpVal.multiply(tmpVector[c])));
        }
        if (tmpCount > THRESHOLD) {
            DivideAndConquer tmpConqurer = new DivideAndConquer(){

                @Override
                protected void conquer(int aFirst, int aLimit) {
                    HermitianRank2Update.invoke(data, aFirst, aLimit, tmpVector, worker);
                }
            };
            tmpConqurer.invoke(tmpFirst, tmpLength, THRESHOLD);
        } else {
            HermitianRank2Update.invoke(data, tmpFirst, tmpLength, tmpVector, worker);
        }
    }

    public static void invoke(final ComplexNumber[] data, Householder.Complex householder, final ComplexNumber[] worker) {
        int c;
        final ComplexNumber[] tmpVector = householder.vector;
        final int tmpFirst = householder.first;
        int tmpLength = tmpVector.length;
        ComplexNumber tmpBeta = householder.beta;
        int tmpCount = tmpLength - tmpFirst;
        if (tmpCount > THRESHOLD) {
            DivideAndConquer tmpConqurer = new DivideAndConquer(){

                @Override
                protected void conquer(int aFirst, int aLimit) {
                    MultiplyHermitianAndVector.invoke(worker, aFirst, aLimit, data, tmpVector, tmpFirst);
                }
            };
            tmpConqurer.invoke(tmpFirst, tmpLength, THRESHOLD);
        } else {
            MultiplyHermitianAndVector.invoke(worker, tmpFirst, tmpLength, data, tmpVector, tmpFirst);
        }
        ComplexNumber tmpVal = ComplexNumber.ZERO;
        for (c = tmpFirst; c < tmpLength; ++c) {
            tmpVal = tmpVal.add(tmpVector[c].conjugate().multiply(worker[c]));
        }
        tmpVal = ComplexFunction.DIVIDE.invoke(tmpVal.multiply(tmpBeta), ComplexNumber.TWO);
        for (c = tmpFirst; c < tmpLength; ++c) {
            worker[c] = tmpBeta.multiply(worker[c].subtract(tmpVal.multiply(tmpVector[c])));
        }
        if (tmpCount > THRESHOLD) {
            DivideAndConquer tmpConqurer = new DivideAndConquer(){

                @Override
                protected void conquer(int aFirst, int aLimit) {
                    HermitianRank2Update.invoke(data, aFirst, aLimit, tmpVector, worker);
                }
            };
            tmpConqurer.invoke(tmpFirst, tmpLength, THRESHOLD);
        } else {
            HermitianRank2Update.invoke(data, tmpFirst, tmpLength, tmpVector, worker);
        }
    }

    public static void invoke(final double[] data, Householder.Primitive householder, final double[] worker) {
        int c;
        final double[] tmpVector = householder.vector;
        final int tmpFirst = householder.first;
        int tmpLength = tmpVector.length;
        double tmpBeta = householder.beta;
        int tmpCount = tmpLength - tmpFirst;
        if (tmpCount > THRESHOLD) {
            DivideAndConquer tmpConqurer = new DivideAndConquer(){

                @Override
                protected void conquer(int aFirst, int aLimit) {
                    MultiplyHermitianAndVector.invoke(worker, aFirst, aLimit, data, tmpVector, tmpFirst);
                }
            };
            tmpConqurer.invoke(tmpFirst, tmpLength, THRESHOLD);
        } else {
            MultiplyHermitianAndVector.invoke(worker, tmpFirst, tmpLength, data, tmpVector, tmpFirst);
        }
        double tmpVal = PrimitiveMath.ZERO;
        for (c = tmpFirst; c < tmpLength; ++c) {
            tmpVal += tmpVector[c] * worker[c];
        }
        tmpVal *= tmpBeta / PrimitiveMath.TWO;
        for (c = tmpFirst; c < tmpLength; ++c) {
            worker[c] = tmpBeta * (worker[c] - tmpVal * tmpVector[c]);
        }
        if (tmpCount > THRESHOLD) {
            DivideAndConquer tmpConqurer = new DivideAndConquer(){

                @Override
                protected void conquer(int aFirst, int aLimit) {
                    HermitianRank2Update.invoke(data, aFirst, aLimit, tmpVector, worker);
                }
            };
            tmpConqurer.invoke(tmpFirst, tmpLength, THRESHOLD);
        } else {
            HermitianRank2Update.invoke(data, tmpFirst, tmpLength, tmpVector, worker);
        }
    }

    public static void tred2j(double[] data, double[] d, double[] e, boolean yesvecs) {
        int k;
        double g;
        int j;
        int k2;
        double h;
        int l;
        int i;
        int n = d.length;
        int tmpLast = n - 1;
        int tmpRowDim = n;
        Copy.invoke(data, tmpRowDim * tmpLast, d, 0, 0, n);
        for (i = tmpLast; i > 0; --i) {
            double scale;
            l = i - 1;
            h = scale = PrimitiveMath.ZERO;
            for (k2 = 0; k2 < i; ++k2) {
                scale += Math.abs(d[k2]);
            }
            if (scale == PrimitiveMath.ZERO) {
                e[i] = d[l];
                for (j = 0; j < i; ++j) {
                    d[j] = data[l + tmpRowDim * j];
                    data[i + tmpRowDim * j] = PrimitiveMath.ZERO;
                    data[j + tmpRowDim * i] = PrimitiveMath.ZERO;
                }
            } else {
                double tmpVal;
                k2 = 0;
                while (k2 < i) {
                    int n2 = k2++;
                    double d2 = d[n2] / scale;
                    d[n2] = d2;
                    tmpVal = d2;
                    h += tmpVal * tmpVal;
                }
                double f = d[l];
                g = Math.sqrt(h);
                if (f > 0.0) {
                    g = -g;
                }
                e[i] = scale * g;
                h -= f * g;
                d[l] = f - g;
                Arrays.fill(e, 0, i, PrimitiveMath.ZERO);
                for (j = 0; j < i; ++j) {
                    data[j + tmpRowDim * i] = f = d[j];
                    g = e[j] + data[j + tmpRowDim * j] * f;
                    k = j + 1;
                    while (k <= l) {
                        tmpVal = data[k + tmpRowDim * j];
                        g += tmpVal * d[k];
                        int n3 = k++;
                        e[n3] = e[n3] + tmpVal * f;
                    }
                    e[j] = g;
                }
                f = PrimitiveMath.ZERO;
                for (j = 0; j < i; ++j) {
                    int n4 = j;
                    e[n4] = e[n4] / h;
                    f += e[j] * d[j];
                }
                tmpVal = f / (h + h);
                SubtractScaledVector.invoke(e, 0, d, 0, tmpVal, 0, i);
                for (j = 0; j < i; ++j) {
                    f = d[j];
                    g = e[j];
                    for (k = j; k <= l; ++k) {
                        int n5 = k + tmpRowDim * j;
                        data[n5] = data[n5] - (f * e[k] + g * d[k]);
                    }
                    d[j] = data[l + tmpRowDim * j];
                    data[i + tmpRowDim * j] = PrimitiveMath.ZERO;
                }
            }
            d[i] = h;
        }
        if (yesvecs) {
            for (i = 0; i < tmpLast; ++i) {
                l = i + 1;
                data[tmpLast + tmpRowDim * i] = data[i + tmpRowDim * i];
                data[i + tmpRowDim * i] = PrimitiveMath.ONE;
                h = d[l];
                if (h != PrimitiveMath.ZERO) {
                    for (k2 = 0; k2 <= i; ++k2) {
                        d[k2] = data[k2 + tmpRowDim * l] / h;
                    }
                    for (j = 0; j <= i; ++j) {
                        g = PrimitiveMath.ZERO;
                        for (k = 0; k <= i; ++k) {
                            g += data[k + tmpRowDim * l] * data[k + tmpRowDim * j];
                        }
                        for (k = 0; k <= i; ++k) {
                            int n6 = k + tmpRowDim * j;
                            data[n6] = data[n6] - g * d[k];
                        }
                    }
                }
                for (k2 = 0; k2 <= i; ++k2) {
                    data[k2 + tmpRowDim * l] = PrimitiveMath.ZERO;
                }
            }
            for (int j2 = 0; j2 < n; ++j2) {
                d[j2] = data[tmpLast + tmpRowDim * j2];
                data[tmpLast + tmpRowDim * j2] = PrimitiveMath.ZERO;
            }
            data[tmpLast + tmpRowDim * tmpLast] = PrimitiveMath.ONE;
            e[0] = PrimitiveMath.ZERO;
        }
    }

    public static void tred2jj(double[][] data, double[] d, double[] e, boolean yesvecs) {
        double h;
        int i;
        int n = d.length;
        int tmpLast = n - 1;
        Copy.invoke(data[tmpLast], 0, d, 0, 0, n);
        for (i = tmpLast; i > 0; --i) {
            int j;
            int k;
            double scale;
            int l = i - 1;
            h = scale = PrimitiveMath.ZERO;
            for (k = 0; k < i; ++k) {
                scale += Math.abs(d[k]);
            }
            if (scale == PrimitiveMath.ZERO) {
                e[i] = d[l];
                for (j = 0; j < i; ++j) {
                    d[j] = data[j][l];
                    data[j][i] = PrimitiveMath.ZERO;
                    data[i][j] = PrimitiveMath.ZERO;
                }
            } else {
                double tmpVal;
                k = 0;
                while (k < i) {
                    int n2 = k++;
                    double d2 = d[n2] / scale;
                    d[n2] = d2;
                    tmpVal = d2;
                    h += tmpVal * tmpVal;
                }
                double f = d[l];
                double g = Math.sqrt(h);
                if (f > 0.0) {
                    g = -g;
                }
                e[i] = scale * g;
                h -= f * g;
                d[l] = f - g;
                Arrays.fill(e, 0, i, PrimitiveMath.ZERO);
                for (j = 0; j < i; ++j) {
                    data[i][j] = f = d[j];
                    double[] tmpVt_j = data[j];
                    g = e[j] + tmpVt_j[j] * f;
                    int k2 = j + 1;
                    while (k2 <= l) {
                        tmpVal = tmpVt_j[k2];
                        g += tmpVal * d[k2];
                        int n3 = k2++;
                        e[n3] = e[n3] + tmpVal * f;
                    }
                    e[j] = g;
                }
                f = PrimitiveMath.ZERO;
                for (j = 0; j < i; ++j) {
                    int n4 = j;
                    e[n4] = e[n4] / h;
                    f += e[j] * d[j];
                }
                tmpVal = f / (h + h);
                SubtractScaledVector.invoke(e, 0, d, 0, tmpVal, 0, i);
                for (j = 0; j < i; ++j) {
                    f = d[j];
                    g = e[j];
                    for (int k3 = j; k3 <= l; ++k3) {
                        double[] dArray = data[j];
                        int n5 = k3;
                        dArray[n5] = dArray[n5] - (f * e[k3] + g * d[k3]);
                    }
                    d[j] = data[j][l];
                    data[j][i] = PrimitiveMath.ZERO;
                }
            }
            d[i] = h;
        }
        for (i = 0; i < tmpLast; ++i) {
            double[] tmpVt_i = data[i];
            double[] tmpVt_i1 = data[i + 1];
            tmpVt_i[tmpLast] = tmpVt_i[i];
            tmpVt_i[i] = PrimitiveMath.ONE;
            h = d[i + 1];
            if (h != PrimitiveMath.ZERO) {
                for (int k = 0; k <= i; ++k) {
                    d[k] = tmpVt_i1[k] / h;
                }
                for (int j = 0; j <= i; ++j) {
                    double tmpDotProd = DotProduct.invoke(tmpVt_i1, 0, data[j], 0, 0, i + 1);
                    SubtractScaledVector.invoke(data[j], 0, d, 0, tmpDotProd, 0, i + 1);
                }
            }
            Arrays.fill(tmpVt_i1, 0, i + 1, PrimitiveMath.ZERO);
        }
        for (int j = 0; j < n; ++j) {
            d[j] = data[j][tmpLast];
            data[j][tmpLast] = PrimitiveMath.ZERO;
        }
        data[tmpLast][tmpLast] = PrimitiveMath.ONE;
        e[0] = PrimitiveMath.ZERO;
    }

    public static void tred2nr(double[] data, double[] d, double[] e, boolean yesvecs) {
        int k;
        int j;
        double g;
        int i;
        int n;
        int tmpRowDim = n = d.length;
        for (i = n - 1; i > 0; --i) {
            int l = i - 1;
            double scale = PrimitiveMath.ZERO;
            double h = PrimitiveMath.ZERO;
            if (l > 0) {
                int k2;
                for (k2 = 0; k2 < i; ++k2) {
                    scale += Math.abs(data[i + k2 * tmpRowDim]);
                }
                if (scale == PrimitiveMath.ZERO) {
                    e[i] = data[i + l * tmpRowDim];
                } else {
                    for (k2 = 0; k2 < i; ++k2) {
                        int n2 = i + k2 * tmpRowDim;
                        data[n2] = data[n2] / scale;
                        h += data[i + k2 * tmpRowDim] * data[i + k2 * tmpRowDim];
                    }
                    double f = data[i + l * tmpRowDim];
                    g = f >= PrimitiveMath.ZERO ? -Math.sqrt(h) : Math.sqrt(h);
                    e[i] = scale * g;
                    h -= f * g;
                    data[i + l * tmpRowDim] = f - g;
                    f = PrimitiveMath.ZERO;
                    for (j = 0; j < i; ++j) {
                        if (yesvecs) {
                            data[j + i * tmpRowDim] = data[i + j * tmpRowDim] / h;
                        }
                        g = PrimitiveMath.ZERO;
                        for (k = 0; k < j + 1; ++k) {
                            g += data[j + k * tmpRowDim] * data[i + k * tmpRowDim];
                        }
                        for (k = j + 1; k < i; ++k) {
                            g += data[k + j * tmpRowDim] * data[i + k * tmpRowDim];
                        }
                        e[j] = g / h;
                        f += e[j] * data[i + j * tmpRowDim];
                    }
                    double hh = f / (h + h);
                    for (j = 0; j < i; ++j) {
                        f = data[i + j * tmpRowDim];
                        e[j] = g = e[j] - hh * f;
                        for (k = 0; k < j + 1; ++k) {
                            int n3 = j + k * tmpRowDim;
                            data[n3] = data[n3] - (f * e[k] + g * data[i + k * tmpRowDim]);
                        }
                    }
                }
            } else {
                e[i] = data[i + l * tmpRowDim];
            }
            d[i] = h;
        }
        if (yesvecs) {
            d[0] = PrimitiveMath.ZERO;
        }
        e[0] = PrimitiveMath.ZERO;
        for (i = 0; i < n; ++i) {
            if (yesvecs) {
                if (d[i] != PrimitiveMath.ZERO) {
                    for (j = 0; j < i; ++j) {
                        g = PrimitiveMath.ZERO;
                        for (k = 0; k < i; ++k) {
                            g += data[i + k * tmpRowDim] * data[k + j * tmpRowDim];
                        }
                        for (k = 0; k < i; ++k) {
                            int n4 = k + j * tmpRowDim;
                            data[n4] = data[n4] - g * data[k + i * tmpRowDim];
                        }
                    }
                }
                d[i] = data[i + i * tmpRowDim];
                data[i + i * tmpRowDim] = PrimitiveMath.ONE;
                for (j = 0; j < i; ++j) {
                    data[i + j * tmpRowDim] = PrimitiveMath.ZERO;
                    data[j + i * tmpRowDim] = PrimitiveMath.ZERO;
                }
                continue;
            }
            d[i] = data[i + i * tmpRowDim];
        }
    }

    private HouseholderHermitian() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

