/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation;

import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.type.context.NumberContext;

public abstract class OptimisationUtils {
    static final NumberContext DISPLAY = NumberContext.getGeneral(6);

    static int getAdjustmentExponent(double largest, double smallest) {
        double tmpLargestExp = largest > PrimitiveMath.ZERO ? Math.log10(largest) : PrimitiveMath.ZERO;
        double tmpSmallestExp = smallest > PrimitiveMath.ZERO ? Math.log10(smallest) : -PrimitiveMath.EIGHT;
        tmpSmallestExp = Math.max(tmpSmallestExp, tmpLargestExp - PrimitiveMath.EIGHT - PrimitiveMath.EIGHT);
        double tmpNegatedAverage = (tmpLargestExp + tmpSmallestExp) / -PrimitiveMath.TWO;
        return (int)Math.rint(tmpNegatedAverage);
    }

    private OptimisationUtils() {
    }
}

