/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.convex;

import org.ojalgo.access.Access1D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.convex.ConstrainedSolver;
import org.ojalgo.optimisation.convex.ConvexSolver;
import org.ojalgo.optimisation.linear.LinearSolver;
import org.ojalgo.type.IndexSelector;

abstract class ActiveSetSolver
extends ConstrainedSolver {
    private final IndexSelector myActivator = new IndexSelector(this.countInequalityConstraints());
    private int myConstraintToInclude = -1;
    private final PrimitiveDenseStore myIterationX = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(this.countVariables(), 1L);
    MatrixStore<Double> myInvQC;

    ActiveSetSolver(ConvexSolver.Builder matrices, Optimisation.Options solverOptions) {
        super(matrices, solverOptions);
    }

    private boolean checkFeasibility(boolean onlyExcluded) {
        double tmpRHS;
        double tmpBody;
        int i;
        MatrixStore<Double> tmpAIX;
        boolean retVal = true;
        if (!onlyExcluded) {
            if (this.hasEqualityConstraints()) {
                MatrixStore<Double> tmpAEX = this.getAEX();
                MatrixStore<Double> tmpBE = this.getBE();
                int i2 = 0;
                while (retVal && (long)i2 < tmpBE.countRows()) {
                    if (this.options.slack.isDifferent(tmpBE.doubleValue(i2), tmpAEX.doubleValue(i2))) {
                        retVal = false;
                    }
                    ++i2;
                }
            }
            if (this.hasInequalityConstraints() && this.myActivator.countIncluded() > 0) {
                int[] tmpIncluded = this.myActivator.getIncluded();
                tmpAIX = this.getAIX(tmpIncluded);
                MatrixStore<Double> tmpBI = this.getBI(tmpIncluded);
                for (i = 0; retVal && i < tmpIncluded.length; ++i) {
                    tmpBody = tmpAIX.doubleValue(i);
                    if (!(tmpBody > (tmpRHS = tmpBI.doubleValue(i))) || !this.options.slack.isDifferent(tmpRHS, tmpBody)) continue;
                    retVal = false;
                }
            }
        }
        if (this.hasInequalityConstraints() && this.myActivator.countExcluded() > 0) {
            int[] tmpExcluded = this.myActivator.getExcluded();
            tmpAIX = this.getAIX(tmpExcluded);
            MatrixStore<Double> tmpBI = this.getBI(tmpExcluded);
            for (i = 0; retVal && i < tmpExcluded.length; ++i) {
                tmpBody = tmpAIX.doubleValue(i);
                if (!(tmpBody > (tmpRHS = tmpBI.doubleValue(i))) || !this.options.slack.isDifferent(tmpRHS, tmpBody)) continue;
                retVal = false;
            }
        }
        return retVal;
    }

    private int suggestConstraintToExclude() {
        double tmpVal;
        int retVal = -1;
        int[] tmpIncluded = this.myActivator.getIncluded();
        int tmpLastIncluded = this.myActivator.getLastIncluded();
        int tmpIndexOfLast = -1;
        double tmpMin = Double.POSITIVE_INFINITY;
        MatrixStore<Double> tmpLI = this.getLI(tmpIncluded);
        if (this.isDebug() && tmpLI.count() > 0L) {
            this.debug("Looking for the largest negative lagrange multiplier among these: {}.", tmpLI.copy().asList());
        }
        int i = 0;
        while ((long)i < tmpLI.countRows()) {
            if (tmpIncluded[i] != tmpLastIncluded) {
                tmpVal = tmpLI.doubleValue(i, 0L);
                if (tmpVal < PrimitiveMath.ZERO && tmpVal < tmpMin && !this.options.solution.isZero(tmpVal)) {
                    tmpMin = tmpVal;
                    retVal = i;
                    if (this.isDebug()) {
                        this.debug("Best so far: {} @ {} ({}).", tmpMin, retVal, tmpIncluded[i]);
                    }
                }
            } else {
                tmpIndexOfLast = i;
            }
            ++i;
        }
        if (retVal < 0 && tmpIndexOfLast >= 0 && (tmpVal = tmpLI.doubleValue(tmpIndexOfLast, 0L)) < PrimitiveMath.ZERO && tmpVal < tmpMin && !this.options.solution.isZero(tmpVal)) {
            tmpMin = tmpVal;
            retVal = tmpIndexOfLast;
            if (this.isDebug()) {
                this.debug("Only the last included needs to be excluded: {} @ {} ({}).", tmpMin, retVal, tmpIncluded[retVal]);
            }
        }
        return retVal >= 0 ? tmpIncluded[retVal] : retVal;
    }

    private int suggestConstraintToInclude() {
        return this.myConstraintToInclude;
    }

    @Override
    protected MatrixStore<Double> extractSolution() {
        return super.extractSolution();
    }

    @Override
    protected final MatrixStore<Double> getIterationKKT() {
        return this.getIterationKKT(this.myActivator.getIncluded());
    }

    protected final MatrixStore<Double> getIterationKKT(int[] included) {
        MatrixStore<Double> tmpIterationQ = this.getIterationQ();
        MatrixStore<Double> tmpIterationA = this.getIterationA(included);
        return tmpIterationQ.builder().right(new MatrixStore[]{tmpIterationA.transpose()}).below(tmpIterationA).build();
    }

    @Override
    protected final MatrixStore<Double> getIterationRHS() {
        return this.getIterationRHS(this.myActivator.getIncluded());
    }

    protected final MatrixStore<Double> getIterationRHS(int[] included) {
        MatrixStore<Double> tmpIterationC = this.getIterationC();
        MatrixStore<Double> tmpIterationB = this.getIterationB(included);
        return tmpIterationC.builder().below(tmpIterationB).build();
    }

    @Override
    protected boolean initialise(Optimisation.Result kickStarter) {
        boolean tmpUsableKickStarter;
        super.initialise(kickStarter);
        MatrixStore<Double> tmpQ = this.getQ();
        MatrixStore<Double> tmpC = this.getC();
        MatrixStore<Double> tmpAE = this.getAE();
        MatrixStore<Double> tmpBE = this.getBE();
        MatrixStore<Double> tmpAI = this.getAI();
        MatrixStore<Double> tmpBI = this.getBI();
        int tmpNumVars = (int)tmpC.countRows();
        int tmpNumEqus = tmpAE != null ? (int)tmpAE.countRows() : 0;
        int tmpNumInes = tmpAI != null ? (int)tmpAI.countRows() : 0;
        DecompositionStore<Double> tmpX = this.getX();
        this.myActivator.excludeAll();
        boolean tmpFeasible = false;
        boolean bl = tmpUsableKickStarter = kickStarter != null && kickStarter.getState().isApproximate();
        if (tmpUsableKickStarter) {
            this.fillX(kickStarter);
            tmpFeasible = this.checkFeasibility(false);
        }
        if (!tmpFeasible) {
            LinearSolver tmpLinearSolver;
            Optimisation.Result tmpLinearResult;
            int i;
            MatrixStore<Double> tmpGradient = tmpUsableKickStarter ? tmpQ.multiply((Double)((Object)tmpX)).subtract(tmpC) : tmpC.negate();
            MatrixStore<Double> tmpLinearC = tmpGradient.builder().below(new MatrixStore[]{tmpGradient.negate()}).below(tmpNumInes).build();
            LinearSolver.Builder tmpLinearBuilder = LinearSolver.getBuilder(tmpLinearC);
            MatrixStore<Double> tmpAEpart = null;
            MatrixStore<Double> tmpBEpart = null;
            if (tmpNumEqus > 0) {
                tmpAEpart = tmpAE.builder().right(new MatrixStore[]{tmpAE.negate()}).right(tmpNumInes).build();
                tmpBEpart = tmpBE;
            }
            if (tmpNumInes > 0) {
                MatrixStore<Double> tmpAIpart = tmpAI.builder().right(new MatrixStore[]{tmpAI.negate()}).right(new MatrixStore[]{MatrixStore.PRIMITIVE.makeIdentity(tmpNumInes).get()}).build();
                MatrixStore<Double> tmpBIpart = tmpBI;
                if (tmpAEpart != null) {
                    tmpAEpart = tmpAEpart.builder().below(tmpAIpart).build();
                    tmpBEpart = tmpBEpart.builder().below(tmpBIpart).build();
                } else {
                    tmpAEpart = tmpAIpart;
                    tmpBEpart = tmpBIpart;
                }
            }
            if (tmpAEpart != null) {
                PhysicalStore<Double> tmpLinearAE = tmpAEpart.copy();
                PhysicalStore<Double> tmpLinearBE = tmpBEpart.copy();
                i = 0;
                while ((long)i < tmpLinearBE.countRows()) {
                    if (tmpLinearBE.doubleValue(i) < 0.0) {
                        tmpLinearAE.modifyRow(i, 0L, PrimitiveFunction.NEGATE);
                        tmpLinearBE.modifyRow(i, 0L, PrimitiveFunction.NEGATE);
                    }
                    ++i;
                }
                tmpLinearBuilder.equalities(tmpLinearAE, tmpLinearBE);
            }
            if (tmpFeasible = (tmpLinearResult = (tmpLinearSolver = (LinearSolver)tmpLinearBuilder.build()).solve()).getState().isFeasible()) {
                for (i = 0; i < tmpNumVars; ++i) {
                    this.setX(i, tmpLinearResult.doubleValue(i) - tmpLinearResult.doubleValue(tmpNumVars + i));
                }
                double[] tmpResidual = tmpLinearSolver.getResidualCosts();
                for (int i2 = tmpNumVars * 2; i2 < tmpResidual.length; ++i2) {
                    int tmpIndexToInclude = i2 - 2 * tmpNumVars;
                    this.setLI(tmpIndexToInclude, tmpResidual[i2]);
                }
            }
        }
        if (tmpFeasible) {
            this.setState(Optimisation.State.FEASIBLE);
            if (this.hasInequalityConstraints()) {
                int[] tmpExcluded = this.myActivator.getExcluded();
                MatrixStore<Double> tmpAIX = this.getAIX(tmpExcluded);
                for (int i = 0; i < tmpExcluded.length; ++i) {
                    double tmpBody = tmpAIX.doubleValue(i);
                    double tmpRHS = tmpBI.doubleValue(tmpExcluded[i]);
                    if (this.options.slack.isDifferent(tmpRHS, tmpBody)) continue;
                    this.myActivator.include(tmpExcluded[i]);
                }
            }
            while (tmpNumEqus + this.myActivator.countIncluded() > tmpNumVars) {
                this.shrink();
            }
            if (this.isDebug() && tmpNumEqus + this.myActivator.countIncluded() > tmpNumVars) {
                this.debug("Redundant contraints!", new Object[0]);
            }
            this.myInvQC = this.myCholesky.solve(this.getIterationC());
        } else {
            this.setState(Optimisation.State.INFEASIBLE);
            this.resetX();
        }
        if (this.isDebug()) {
            this.debug("Initial solution: {}", tmpX.copy().asList());
            if (tmpAE != null) {
                this.debug("Initial E-slack: {}", this.getSE().copy().asList());
            }
            if (tmpAI != null) {
                this.debug("Initial I-included-slack: {}", this.getSI(this.myActivator.getIncluded()).copy().asList());
                this.debug("Initial I-excluded-slack: {}", this.getSI(this.myActivator.getExcluded()).copy().asList());
            }
        }
        return this.getState().isFeasible();
    }

    @Override
    protected boolean needsAnotherIteration() {
        if (this.isDebug()) {
            this.debug("\nNeedsAnotherIteration?", new Object[0]);
            this.debug(this.myActivator.toString(), new Object[0]);
        }
        int tmpToInclude = -1;
        int tmpToExclude = -1;
        if (this.hasInequalityConstraints() && (tmpToInclude = this.suggestConstraintToInclude()) == -1) {
            tmpToExclude = this.suggestConstraintToExclude();
        }
        if (this.isDebug()) {
            this.debug("Suggested to include: {}", tmpToInclude);
            this.debug("Suggested to exclude: {}", tmpToExclude);
        }
        if (tmpToExclude == -1) {
            if (tmpToInclude == -1) {
                this.setState(Optimisation.State.OPTIMAL);
                return false;
            }
            this.myActivator.include(tmpToInclude);
            this.setState(Optimisation.State.APPROXIMATE);
            return true;
        }
        if (tmpToInclude == -1) {
            this.myActivator.exclude(tmpToExclude);
            this.setState(Optimisation.State.APPROXIMATE);
            return true;
        }
        this.myActivator.exclude(tmpToExclude);
        this.myActivator.include(tmpToInclude);
        this.setState(Optimisation.State.APPROXIMATE);
        return true;
    }

    @Override
    protected void performIteration() {
        if (this.isDebug()) {
            this.debug("\nPerformIteration {}", 1 + this.countIterations());
            this.debug(this.myActivator.toString(), new Object[0]);
        }
        this.myConstraintToInclude = -1;
        int[] tmpIncluded = this.myActivator.getIncluded();
        MatrixStore<Double> tmpIterQ = this.getIterationQ();
        MatrixStore<Double> tmpIterC = this.getIterationC();
        MatrixStore<Double> tmpIterA = this.getIterationA(tmpIncluded);
        MatrixStore<Double> tmpIterB = this.getIterationB(tmpIncluded);
        boolean tmpSolvable = false;
        PrimitiveDenseStore tmpIterX = this.myIterationX;
        PrimitiveDenseStore tmpIterL = (PrimitiveDenseStore)PrimitiveDenseStore.FACTORY.makeZero(tmpIterA.countRows(), 1L);
        if (tmpIterA.countRows() < tmpIterA.countColumns() && (tmpSolvable = this.myCholesky.isSolvable())) {
            if (tmpIterA.countRows() == 0L) {
                this.myCholesky.solve(tmpIterC, tmpIterX);
            } else {
                MatrixStore<Double> tmpInvQAT = this.myCholesky.solve(tmpIterA.transpose());
                ElementsSupplier<Double> tmpS = tmpInvQAT.multiplyLeft(tmpIterA);
                tmpSolvable = this.myLU.compute(tmpS);
                if (tmpSolvable) {
                    this.myLU.solve(this.myInvQC.multiplyLeft(tmpIterA).operateOnMatching(PrimitiveFunction.SUBTRACT, tmpIterB), tmpIterL);
                    this.myCholesky.solve(tmpIterL.multiplyLeft(tmpIterA.transpose()).operateOnMatching(tmpIterC, PrimitiveFunction.SUBTRACT), tmpIterX);
                }
            }
        }
        if (!tmpSolvable && (tmpSolvable = this.myLU.compute(this.getIterationKKT(tmpIncluded)))) {
            MatrixStore<Double> tmpXL = this.myLU.solve(this.getIterationRHS(tmpIncluded));
            tmpIterX.fillMatching(tmpXL.builder().rows(0, this.countVariables()).build());
            tmpIterL.fillMatching(tmpXL.builder().rows(this.countVariables(), (int)tmpXL.count()).build());
        }
        if (!tmpSolvable && this.isDebug()) {
            this.options.debug_appender.println("KKT system unsolvable!");
            this.options.debug_appender.printmtrx("KKT", this.getIterationKKT());
            this.options.debug_appender.printmtrx("RHS", this.getIterationRHS());
        }
        if (tmpSolvable) {
            int i;
            double tmpNormStepX;
            double tmpNormCurrentX;
            tmpIterX.fillMatching((Access1D<Double>)tmpIterX, PrimitiveFunction.SUBTRACT, (Access1D<Double>)this.getX());
            if (this.isDebug()) {
                this.debug("Current: {}", this.getX().asList());
                this.debug("Step: {}", tmpIterX.copy().asList());
            }
            if (!this.options.solution.isSmall(tmpNormCurrentX = ((Double)this.getX().aggregateAll(Aggregator.NORM2)).doubleValue(), tmpNormStepX = tmpIterX.aggregateAll(Aggregator.NORM2).doubleValue())) {
                double tmpStepLength = PrimitiveMath.ONE;
                int[] tmpExcluded = this.myActivator.getExcluded();
                if (tmpExcluded.length > 0) {
                    MatrixStore<Double> tmpNumer = this.getSI(tmpExcluded);
                    MatrixStore<Double> tmpDenom = this.getAI().builder().row(tmpExcluded).build().multiply((Double)((Object)tmpIterX));
                    PhysicalStore<Double> tmpStepLengths = tmpNumer.copy();
                    tmpStepLengths.fillMatching(tmpStepLengths, PrimitiveFunction.DIVIDE, tmpDenom);
                    if (this.isDebug()) {
                        this.debug("Looking for the largest possible step length (smallest positive scalar) among these: {}).", tmpStepLengths.asList());
                    }
                    for (int i2 = 0; i2 < tmpExcluded.length; ++i2) {
                        double tmpVal;
                        double tmpN = tmpNumer.doubleValue(i2);
                        double tmpD = tmpDenom.doubleValue(i2);
                        double d = tmpVal = this.options.slack.isSmall(tmpD, tmpN) ? PrimitiveMath.ZERO : tmpN / tmpD;
                        if (!(tmpD > PrimitiveMath.ZERO) || !(tmpVal >= PrimitiveMath.ZERO) || !(tmpVal < tmpStepLength) || this.options.solution.isSmall(tmpNormStepX, tmpD)) continue;
                        tmpStepLength = tmpVal;
                        this.myConstraintToInclude = tmpExcluded[i2];
                        if (!this.isDebug()) continue;
                        this.debug("Best so far: {} @ {} ({}).", tmpStepLength, i2, this.myConstraintToInclude);
                    }
                }
                if (tmpStepLength > PrimitiveMath.ZERO) {
                    this.getX().maxpy(tmpStepLength, tmpIterX);
                }
                this.setState(Optimisation.State.APPROXIMATE);
            } else if (this.isDebug()) {
                if (this.isDebug()) {
                    this.debug("Step too small!", new Object[0]);
                }
                this.setState(Optimisation.State.FEASIBLE);
            }
            for (i = 0; i < this.countEqualityConstraints(); ++i) {
                this.setLE(i, tmpIterL.doubleValue((long)i));
            }
            for (i = 0; i < tmpIncluded.length; ++i) {
                this.setLI(tmpIncluded[i], tmpIterL.doubleValue((long)(this.countEqualityConstraints() + i)));
            }
        } else if (tmpIncluded.length >= 1) {
            this.shrink();
            this.performIteration();
        } else if (this.checkFeasibility(false)) {
            this.setState(Optimisation.State.FEASIBLE);
        } else {
            this.setState(Optimisation.State.INFEASIBLE);
        }
        if (this.isDebug()) {
            this.debug("Post iteration", new Object[0]);
            this.debug("\tSolution: {}", this.getX().copy().asList());
            if (this.getAE() != null && this.getAE().count() > 0L) {
                this.debug("\tE-slack: {}", this.getSE().copy().asList());
            }
            if (this.getAI() != null && this.getAI().count() > 0L) {
                if (tmpIncluded.length != 0) {
                    this.debug("\tI-included-slack: {}", this.getSI(tmpIncluded).copy().asList());
                }
                if (this.myActivator.getExcluded().length != 0) {
                    this.debug("\tI-excluded-slack: {}", this.getSI(this.myActivator.getExcluded()).copy().asList());
                }
            }
        }
    }

    @Override
    final MatrixStore<Double> getIterationA() {
        return this.getIterationA(this.myActivator.getIncluded());
    }

    abstract MatrixStore<Double> getIterationA(int[] var1);

    @Override
    final MatrixStore<Double> getIterationB() {
        return this.getIterationB(this.myActivator.getIncluded());
    }

    abstract MatrixStore<Double> getIterationB(int[] var1);

    @Override
    final MatrixStore<Double> getIterationC() {
        return this.getC();
    }

    void shrink() {
        int[] tmpIncluded = this.myActivator.getIncluded();
        int tmpToExclude = -1;
        double tmpMaxLagrange = PrimitiveMath.ZERO;
        MatrixStore<Double> tmpLI = this.getLI(tmpIncluded);
        for (int i = 0; i < tmpIncluded.length; ++i) {
            double tmpVal = Math.abs(tmpLI.doubleValue(i));
            if (!(tmpVal >= tmpMaxLagrange)) continue;
            tmpMaxLagrange = tmpVal;
            tmpToExclude = tmpIncluded[i];
        }
        this.myActivator.exclude(tmpToExclude);
    }
}

