/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.integer;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;
import org.ojalgo.access.AccessUtils;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.netio.BasicLogger;
import org.ojalgo.netio.CharacterRing;
import org.ojalgo.optimisation.ExpressionsBasedModel;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.Variable;
import org.ojalgo.optimisation.integer.IntegerSolver;
import org.ojalgo.optimisation.integer.NodeKey;
import org.ojalgo.type.TypeUtils;

public final class OldIntegerSolver
extends IntegerSolver {
    private final Set<NodeKey> myExploredNodes = Collections.synchronizedSet(new HashSet());
    private final int[] myIntegerIndeces;

    OldIntegerSolver(ExpressionsBasedModel model, Optimisation.Options solverOptions) {
        super(model, solverOptions);
        List<Variable> tmpIntegerVariables = model.getIntegerVariables();
        this.myIntegerIndeces = new int[tmpIntegerVariables.size()];
        for (int i = 0; i < this.myIntegerIndeces.length; ++i) {
            Variable tmpVariable = tmpIntegerVariables.get(i);
            this.myIntegerIndeces[i] = model.indexOf(tmpVariable);
        }
    }

    @Override
    public Optimisation.Result solve(Optimisation.Result kickStarter) {
        if (kickStarter != null && kickStarter.getState().isFeasible() && this.getModel().validate(kickStarter)) {
            this.markInteger(null, kickStarter);
        }
        this.resetIterationsCount();
        BranchAndBoundNodeTask tmpNodeTask = new BranchAndBoundNodeTask();
        boolean tmpNormalExit = ForkJoinPool.commonPool().invoke(tmpNodeTask);
        Optimisation.Result retVal = this.getBestResultSoFar();
        retVal = retVal.getState().isFeasible() ? (tmpNormalExit ? new Optimisation.Result(Optimisation.State.OPTIMAL, retVal) : new Optimisation.Result(Optimisation.State.FEASIBLE, retVal)) : (tmpNormalExit ? new Optimisation.Result(Optimisation.State.INFEASIBLE, retVal) : new Optimisation.Result(Optimisation.State.FAILED, retVal));
        return retVal;
    }

    public String toString() {
        return TypeUtils.format("Solutions={} Nodes/Iterations={} {}", this.countIntegerSolutions(), this.countExploredNodes(), this.getBestResultSoFar());
    }

    @Override
    protected MatrixStore<Double> extractSolution() {
        return (MatrixStore)PrimitiveDenseStore.FACTORY.columns(this.getBestResultSoFar());
    }

    @Override
    protected boolean initialise(Optimisation.Result kickStarter) {
        return true;
    }

    @Override
    protected boolean needsAnotherIteration() {
        return !this.getState().isOptimal();
    }

    @Override
    protected boolean validate() {
        boolean retVal = true;
        this.setState(Optimisation.State.VALID);
        try {
            retVal = this.getModel().validate();
            if (!retVal) {
                retVal = false;
                this.setState(Optimisation.State.INVALID);
            }
        }
        catch (Exception ex) {
            retVal = false;
            this.setState(Optimisation.State.FAILED);
        }
        return retVal;
    }

    int countExploredNodes() {
        return this.myExploredNodes.size();
    }

    int getGlobalIndex(int integerIndex) {
        return this.myIntegerIndeces[integerIndex];
    }

    final int[] getIntegerIndeces() {
        return this.myIntegerIndeces;
    }

    int identifyNonIntegerVariable(Optimisation.Result nodeResult, NodeKey nodeKey) {
        MatrixStore<Double> tmpGradient = this.getGradient(AccessUtils.asPrimitive1D(nodeResult));
        int retVal = -1;
        double tmpMaxFraction = PrimitiveMath.ZERO;
        for (int i = 0; i < this.myIntegerIndeces.length; ++i) {
            double tmpFraction = nodeKey.getFraction(i, nodeResult.doubleValue(this.myIntegerIndeces[i]));
            double tmpWeightedFraction = tmpFraction * (PrimitiveMath.ONE + Math.abs(tmpGradient.doubleValue(this.myIntegerIndeces[i])));
            if (!(tmpWeightedFraction > tmpMaxFraction) || this.options.integer.isZero(tmpWeightedFraction)) continue;
            retVal = i;
            tmpMaxFraction = tmpWeightedFraction;
        }
        return retVal;
    }

    boolean isExplored(BranchAndBoundNodeTask aNodeTask) {
        return this.myExploredNodes.contains(aNodeTask.getKey());
    }

    void markAsExplored(BranchAndBoundNodeTask aNodeTask) {
        this.myExploredNodes.add(aNodeTask.getKey());
    }

    final class BranchAndBoundNodeTask
    extends RecursiveTask<Boolean> {
        private final NodeKey myKey;

        private BranchAndBoundNodeTask(NodeKey key) {
            this.myKey = key;
        }

        BranchAndBoundNodeTask() {
            this.myKey = new NodeKey(OldIntegerSolver.this.getModel());
        }

        public String toString() {
            return this.myKey.toString();
        }

        @Override
        protected Boolean compute() {
            if (OldIntegerSolver.this.isDebug()) {
                OldIntegerSolver.this.debug("\nBranch&Bound Node", new Object[0]);
                OldIntegerSolver.this.debug(this.myKey.toString(), new Object[0]);
                OldIntegerSolver.this.debug(OldIntegerSolver.this.toString(), new Object[0]);
            }
            if (!OldIntegerSolver.this.isIterationAllowed() || !OldIntegerSolver.this.isIterationNecessary()) {
                if (OldIntegerSolver.this.isDebug()) {
                    OldIntegerSolver.this.debug("Reached iterations or time limit - stop!", new Object[0]);
                }
                return false;
            }
            if (OldIntegerSolver.this.isExplored(this)) {
                if (OldIntegerSolver.this.isDebug()) {
                    OldIntegerSolver.this.debug("Node previously explored!", new Object[0]);
                }
                return true;
            }
            OldIntegerSolver.this.markAsExplored(this);
            if (!OldIntegerSolver.this.isGoodEnoughToContinueBranching(this.myKey.objective)) {
                if (OldIntegerSolver.this.isDebug()) {
                    OldIntegerSolver.this.debug("No longer a relevant node!", new Object[0]);
                }
                return true;
            }
            ExpressionsBasedModel tmpModel = this.getModel();
            Optimisation.Result tmpResult = tmpModel.solve(OldIntegerSolver.this.getBestResultSoFar());
            OldIntegerSolver.this.incrementIterationsCount();
            if (tmpModel.options.debug_appender != null && tmpModel.options.debug_appender instanceof CharacterRing.PrinterBuffer && OldIntegerSolver.this.getModel().options.debug_appender != null) {
                ((CharacterRing.PrinterBuffer)tmpModel.options.debug_appender).flush(OldIntegerSolver.this.getModel().options.debug_appender);
            }
            if (tmpResult.getState().isOptimal()) {
                if (OldIntegerSolver.this.isDebug()) {
                    OldIntegerSolver.this.debug("Node solved to optimality!", new Object[0]);
                }
                if (OldIntegerSolver.this.options.validate && !tmpModel.validate(tmpResult)) {
                    OldIntegerSolver.this.debug("Node solution marked as OPTIMAL, but is actually INVALID/INFEASIBLE/FAILED. Stop this branch!", new Object[0]);
                    return false;
                }
                int tmpBranchIndex = OldIntegerSolver.this.identifyNonIntegerVariable(tmpResult, this.myKey);
                double tmpSolutionValue = OldIntegerSolver.this.evaluateFunction(tmpResult);
                if (tmpBranchIndex == -1) {
                    if (OldIntegerSolver.this.isDebug()) {
                        OldIntegerSolver.this.debug("Integer solution! Store it among the others, and stop this branch!", new Object[0]);
                    }
                    Optimisation.Result tmpIntegerSolutionResult = new Optimisation.Result(Optimisation.State.FEASIBLE, tmpSolutionValue, tmpResult);
                    OldIntegerSolver.this.markInteger(this.myKey, tmpIntegerSolutionResult);
                    if (OldIntegerSolver.this.isDebug()) {
                        OldIntegerSolver.this.debug(OldIntegerSolver.this.getBestResultSoFar().toString(), new Object[0]);
                        BasicLogger.debug();
                        BasicLogger.debug(OldIntegerSolver.this.toString());
                    }
                } else {
                    if (OldIntegerSolver.this.isDebug()) {
                        OldIntegerSolver.this.debug("Not an Integer Solution: " + tmpSolutionValue, new Object[0]);
                    }
                    double tmpVariableValue = tmpResult.doubleValue(OldIntegerSolver.this.getGlobalIndex(tmpBranchIndex));
                    if (OldIntegerSolver.this.isGoodEnoughToContinueBranching(tmpSolutionValue)) {
                        if (OldIntegerSolver.this.isDebug()) {
                            OldIntegerSolver.this.debug("Still hope, branching on {} @ {} >>> {}", new Object[]{tmpBranchIndex, tmpVariableValue, tmpModel.getVariable(OldIntegerSolver.this.getGlobalIndex(tmpBranchIndex))});
                        }
                        tmpModel.dispose();
                        tmpModel = null;
                        BranchAndBoundNodeTask tmpLowerBranchTask = this.createLowerBranch(tmpBranchIndex, tmpVariableValue, tmpSolutionValue);
                        BranchAndBoundNodeTask tmpUpperBranchTask = this.createUpperBranch(tmpBranchIndex, tmpVariableValue, tmpSolutionValue);
                        tmpUpperBranchTask.fork();
                        boolean tmpLowerBranchValue = tmpLowerBranchTask.compute();
                        if (tmpLowerBranchValue) {
                            return (Boolean)tmpUpperBranchTask.join();
                        }
                        tmpUpperBranchTask.tryUnfork();
                        tmpUpperBranchTask.cancel(true);
                        return false;
                    }
                    if (OldIntegerSolver.this.isDebug()) {
                        OldIntegerSolver.this.debug("Can't find better integer solutions - stop this branch!", new Object[0]);
                    }
                }
            } else if (OldIntegerSolver.this.isDebug()) {
                OldIntegerSolver.this.debug("Failed to solve problem - stop this branch!", new Object[0]);
            }
            return true;
        }

        BranchAndBoundNodeTask createLowerBranch(int branchIndex, double nonIntegerValue, double parentObjectiveValue) {
            NodeKey tmpKey = this.myKey.createLowerBranch(branchIndex, nonIntegerValue, parentObjectiveValue);
            return new BranchAndBoundNodeTask(tmpKey);
        }

        BranchAndBoundNodeTask createUpperBranch(int branchIndex, double nonIntegerValue, double parentObjectiveValue) {
            NodeKey tmpKey = this.myKey.createUpperBranch(branchIndex, nonIntegerValue, parentObjectiveValue);
            return new BranchAndBoundNodeTask(tmpKey);
        }

        NodeKey getKey() {
            return this.myKey;
        }

        ExpressionsBasedModel getModel() {
            ExpressionsBasedModel retVal = OldIntegerSolver.this.getModel().relax(false);
            if (retVal.options.debug_appender != null) {
                retVal.options.debug_appender = new CharacterRing().asPrinter();
            }
            int[] tmpIntegerIndeces = OldIntegerSolver.this.getIntegerIndeces();
            for (int i = 0; i < tmpIntegerIndeces.length; ++i) {
                BigDecimal tmpLowerBound = this.myKey.getLowerBound(i);
                BigDecimal tmpUpperBound = this.myKey.getUpperBound(i);
                Variable tmpVariable = retVal.getVariable(tmpIntegerIndeces[i]);
                tmpVariable.lower(tmpLowerBound);
                tmpVariable.upper(tmpUpperBound);
                BigDecimal tmpValue = tmpVariable.getValue();
                if (tmpValue == null) continue;
                if (tmpLowerBound != null) {
                    tmpValue = tmpValue.max(tmpLowerBound);
                }
                if (tmpUpperBound != null) {
                    tmpValue = tmpValue.min(tmpUpperBound);
                }
                tmpVariable.setValue(tmpValue);
            }
            if (OldIntegerSolver.this.isIntegerSolutionFound()) {
                double tmpBestValue = OldIntegerSolver.this.getBestResultSoFar().getValue();
                double tmpGap = Math.abs(tmpBestValue * OldIntegerSolver.this.options.mip_gap);
                if (retVal.isMinimisation()) {
                    retVal.limitObjective(null, TypeUtils.toBigDecimal(tmpBestValue - tmpGap, OldIntegerSolver.this.options.problem));
                } else {
                    retVal.limitObjective(TypeUtils.toBigDecimal(tmpBestValue + tmpGap, OldIntegerSolver.this.options.problem), null);
                }
            }
            return retVal;
        }
    }
}

