/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.random.AbstractDiscrete;

public class Geometric
extends AbstractDiscrete {
    private static final long serialVersionUID = 1324905651790774444L;
    private final double myProbability;

    public Geometric() {
        this(PrimitiveMath.HALF);
    }

    public Geometric(double aProbability) {
        this.myProbability = aProbability;
    }

    @Override
    public double getExpected() {
        return PrimitiveMath.ONE / this.myProbability;
    }

    @Override
    public double getProbability(int aVal) {
        return this.myProbability * Math.pow(PrimitiveMath.ONE - this.myProbability, (double)aVal - PrimitiveMath.ONE);
    }

    @Override
    public double getVariance() {
        return (PrimitiveMath.ONE - this.myProbability) / (this.myProbability * this.myProbability);
    }

    @Override
    protected double generate() {
        int retVal = 1;
        while (this.random().nextDouble() + this.myProbability <= PrimitiveMath.ONE) {
            ++retVal;
        }
        return retVal;
    }
}

