/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random.process;

import org.ojalgo.access.Access1D;
import org.ojalgo.array.Array1D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.random.LogNormal;
import org.ojalgo.random.RandomUtils;
import org.ojalgo.random.SampleSet;
import org.ojalgo.random.process.AbstractProcess;
import org.ojalgo.random.process.WienerProcess;

public final class GeometricBrownianMotion
extends AbstractProcess<LogNormal> {
    private static final WienerProcess GENERATOR = new WienerProcess();
    private final double myDiffusionFunction;
    private final double myLocalDrift;

    public static GeometricBrownianMotion estimate(Access1D<?> aSeriesOfSamples, double aSamplePeriod) {
        int tmpSizeMinusOne = (int)(aSeriesOfSamples.count() - 1L);
        Access1D tmpLogDiffSeries = Array1D.PRIMITIVE.makeZero(tmpSizeMinusOne);
        for (int i = 0; i < tmpSizeMinusOne; ++i) {
            ((Array1D)tmpLogDiffSeries).set((long)i, Math.log(aSeriesOfSamples.doubleValue(i + 1) / aSeriesOfSamples.doubleValue(i)));
        }
        SampleSet tmpSampleSet = SampleSet.wrap(tmpLogDiffSeries);
        double tmpExp = tmpSampleSet.getMean();
        double tmpVar = tmpSampleSet.getVariance();
        double tmpDiff = Math.sqrt(tmpVar / aSamplePeriod);
        double tmpDrift = tmpExp / aSamplePeriod + tmpDiff * tmpDiff / PrimitiveMath.TWO;
        GeometricBrownianMotion retVal = new GeometricBrownianMotion(tmpDrift, tmpDiff);
        retVal.setValue(aSeriesOfSamples.doubleValue(0L));
        return retVal;
    }

    public static GeometricBrownianMotion make(double aExpected, double aVariance) {
        return GeometricBrownianMotion.make(PrimitiveMath.ONE, aExpected, aVariance, PrimitiveMath.ONE);
    }

    public static GeometricBrownianMotion make(double aExpected, double aVariance, double aHorizon) {
        return GeometricBrownianMotion.make(PrimitiveMath.ONE, aExpected, aVariance, aHorizon);
    }

    public static GeometricBrownianMotion make(double initialValue, double expectedFutureValue, double aVariance, double aHorizon) {
        double tmpDrift = Math.log(expectedFutureValue / initialValue) / aHorizon;
        double tmpDiff = Math.sqrt(Math.log1p(aVariance / (expectedFutureValue * expectedFutureValue)) / aHorizon);
        GeometricBrownianMotion retVal = new GeometricBrownianMotion(tmpDrift, tmpDiff);
        retVal.setValue(initialValue);
        return retVal;
    }

    public GeometricBrownianMotion(double aLocalDrift, double aDiffusionFunction) {
        this.setValue(PrimitiveMath.ONE);
        this.myLocalDrift = aLocalDrift;
        this.myDiffusionFunction = aDiffusionFunction;
    }

    private GeometricBrownianMotion() {
        this(PrimitiveMath.ZERO, PrimitiveMath.ZERO);
    }

    public GeometricBrownianMotion convert(double aConvertionFactor) {
        double tmpDrift = this.myLocalDrift * aConvertionFactor;
        double tmpDiff = this.myDiffusionFunction * Math.sqrt(aConvertionFactor);
        return new GeometricBrownianMotion(tmpDrift, tmpDiff);
    }

    @Override
    public LogNormal getDistribution(double evaluationPoint) {
        double tmpVar = this.getDistributionVariance(evaluationPoint);
        double tmpLocation = this.getDistributionLocation(evaluationPoint, tmpVar);
        double tmpScale = Math.sqrt(tmpVar);
        return new LogNormal(tmpLocation, tmpScale);
    }

    private final double getDistributionLocation(double aStepSize, double aVariance) {
        return Math.log(this.getValue()) + this.myLocalDrift * aStepSize - PrimitiveMath.HALF * aVariance;
    }

    private final double getDistributionVariance(double aStepSize) {
        return this.myDiffusionFunction * this.myDiffusionFunction * aStepSize;
    }

    @Override
    protected double getNormalisedRandomIncrement() {
        return GENERATOR.getNormalisedRandomIncrement();
    }

    @Override
    protected double step(double currentValue, double stepSize, double normalisedRandomIncrement) {
        double tmpDetPart = (this.myLocalDrift - this.myDiffusionFunction * this.myDiffusionFunction / PrimitiveMath.TWO) * stepSize;
        double tmpRandPart = this.myDiffusionFunction * Math.sqrt(stepSize) * normalisedRandomIncrement;
        double retVal = currentValue * Math.exp(tmpDetPart + tmpRandPart);
        this.setValue(retVal);
        return retVal;
    }

    @Override
    double getExpected(double aStepSize) {
        return this.getValue() * Math.exp(this.myLocalDrift * aStepSize);
    }

    @Override
    double getLowerConfidenceQuantile(double aStepSize, double aConfidence) {
        double tmpVar = this.getDistributionVariance(aStepSize);
        double tmpLocation = this.getDistributionLocation(aStepSize, tmpVar);
        double tmpScale = Math.sqrt(tmpVar);
        return Math.exp(tmpLocation - tmpScale * PrimitiveMath.SQRT_TWO * RandomUtils.erfi(aConfidence));
    }

    @Override
    double getStandardDeviation(double aStepSize) {
        return Math.sqrt(this.getVariance(aStepSize));
    }

    @Override
    double getUpperConfidenceQuantile(double aStepSize, double aConfidence) {
        double tmpVar = this.getDistributionVariance(aStepSize);
        double tmpLocation = this.getDistributionLocation(aStepSize, tmpVar);
        double tmpScale = Math.sqrt(tmpVar);
        return Math.exp(tmpLocation + tmpScale * PrimitiveMath.SQRT_TWO * RandomUtils.erfi(aConfidence));
    }

    @Override
    double getVariance(double aStepSize) {
        return this.getValue() * this.getValue() * Math.exp(PrimitiveMath.TWO * this.myLocalDrift * aStepSize) * Math.expm1(this.getDistributionVariance(aStepSize));
    }
}

