/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random.process;

import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.random.Normal;
import org.ojalgo.random.RandomUtils;
import org.ojalgo.random.process.AbstractProcess;

public final class WienerProcess
extends AbstractProcess<Normal> {
    private static final Normal GENERATOR = new Normal();

    public WienerProcess() {
        this.setValue(PrimitiveMath.ZERO);
    }

    private WienerProcess(double initialValue) {
        this.setValue(initialValue);
    }

    @Override
    public Normal getDistribution(double evaluationPoint) {
        return new Normal(this.getValue(), Math.sqrt(evaluationPoint));
    }

    @Override
    protected double getNormalisedRandomIncrement() {
        return GENERATOR.doubleValue();
    }

    @Override
    protected double step(double currentValue, double stepSize, double normalisedRandomIncrement) {
        double retVal = currentValue + Math.sqrt(stepSize) * normalisedRandomIncrement;
        this.setValue(retVal);
        return retVal;
    }

    @Override
    double getExpected(double aStepSize) {
        return this.getValue();
    }

    @Override
    double getLowerConfidenceQuantile(double aStepSize, double aConfidence) {
        return this.getValue() - Math.sqrt(aStepSize) * PrimitiveMath.SQRT_TWO * RandomUtils.erfi(aConfidence);
    }

    @Override
    double getStandardDeviation(double aStepSize) {
        return Math.sqrt(aStepSize);
    }

    @Override
    double getUpperConfidenceQuantile(double aStepSize, double aConfidence) {
        return this.getValue() + Math.sqrt(aStepSize) * PrimitiveMath.SQRT_TWO * RandomUtils.erfi(aConfidence);
    }

    @Override
    double getVariance(double aStepSize) {
        return aStepSize;
    }
}

