/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.series;

import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import org.ojalgo.series.AbstractSeries;
import org.ojalgo.series.primitive.ExplicitTimeSeries;
import org.ojalgo.type.CalendarDate;
import org.ojalgo.type.CalendarDateUnit;

public class CalendarDateSeries<V extends Number>
extends AbstractSeries<CalendarDate, V, CalendarDateSeries<V>> {
    private final CalendarDateUnit myResolution;

    public CalendarDateSeries() {
        this.myResolution = CalendarDateUnit.MILLIS;
    }

    public CalendarDateSeries(CalendarDateUnit aResolution) {
        this.myResolution = aResolution;
    }

    private CalendarDateSeries(Comparator<? super CalendarDate> someC) {
        super(someC);
        this.myResolution = null;
    }

    private CalendarDateSeries(Map<? extends CalendarDate, ? extends V> someM) {
        super(someM);
        this.myResolution = null;
    }

    private CalendarDateSeries(SortedMap<CalendarDate, ? extends V> someM) {
        super(someM);
        this.myResolution = null;
    }

    CalendarDateSeries(SortedMap<CalendarDate, ? extends V> someM, CalendarDateUnit aResolution) {
        super(someM);
        this.myResolution = aResolution;
    }

    public void complete() {
        CalendarDate tmpKey = (CalendarDate)this.firstKey();
        Number tmpVal = null;
        Number tmpPatch = this.firstValue();
        CalendarDate tmpLastKey = (CalendarDate)this.lastKey();
        while (tmpKey.compareTo(tmpLastKey) <= 0) {
            tmpVal = (Number)this.get(tmpKey);
            if (tmpVal != null) {
                tmpPatch = tmpVal;
            } else {
                this.put(tmpKey, (V)tmpPatch);
            }
            tmpKey = this.step(tmpKey);
        }
    }

    public long getAverageStepSize() {
        return (((CalendarDate)this.lastKey()).millis - ((CalendarDate)this.firstKey()).millis) / (long)(this.size() - 1);
    }

    public long[] getPrimitiveKeys() {
        long[] retVal = new long[this.size()];
        int i = 0;
        for (CalendarDate tmpKey : this.keySet()) {
            retVal[i] = tmpKey.millis;
            ++i;
        }
        return retVal;
    }

    public ExplicitTimeSeries getPrimitiveTimeSeries() {
        return new ExplicitTimeSeries(this.getPrimitiveKeys(), this.getDataSeries());
    }

    public CalendarDateUnit getResolution() {
        return this.myResolution;
    }

    public CalendarDateSeries<V> headMap(CalendarDate newToKey) {
        SortedMap tmpMap = super.headMap(newToKey);
        CalendarDateSeries retVal = new CalendarDateSeries(tmpMap, this.getResolution());
        retVal.setColour(this.getColour());
        retVal.setName(this.getName());
        return retVal;
    }

    public CalendarDateSeries<V> headMap(CalendarDate newToKey, boolean newInclusive) {
        NavigableMap tmpMap = super.headMap(newToKey, newInclusive);
        CalendarDateSeries retVal = new CalendarDateSeries(tmpMap, this.getResolution());
        retVal.setColour(this.getColour());
        retVal.setName(this.getName());
        return retVal;
    }

    @Override
    public V put(Calendar aKey, V aValue) {
        return (V)((Number)super.put(CalendarDate.make(aKey, this.myResolution), aValue));
    }

    @Override
    public V put(CalendarDate aKey, V aValue) {
        return (V)((Number)super.put(aKey.filter(this.myResolution), aValue));
    }

    @Override
    public V put(Date aKey, V aValue) {
        return (V)((Number)super.put(CalendarDate.make(aKey, this.myResolution), aValue));
    }

    @Override
    public V put(long aKey, V aValue) {
        return (V)((Number)super.put(CalendarDate.make(aKey, this.myResolution), aValue));
    }

    @Override
    public void putAll(Map<? extends CalendarDate, ? extends V> aMap) {
        for (Map.Entry<CalendarDate, V> tmpEntry : aMap.entrySet()) {
            this.put(tmpEntry.getKey(), (V)((Number)tmpEntry.getValue()));
        }
    }

    public CalendarDateSeries<V> resample(CalendarDate aFirstKey, CalendarDate aLastKey, CalendarDateUnit aResolution) {
        CalendarDateSeries<V> retVal = new CalendarDateSeries<V>(aResolution);
        retVal.setColour(this.getColour());
        retVal.setName(this.getName());
        CalendarDateSeries<V> tmpSubMap = this.subMap(aFirstKey, true, aLastKey, true);
        retVal.putAll(tmpSubMap);
        return retVal;
    }

    public CalendarDateSeries<V> resample(CalendarDateUnit aResolution) {
        CalendarDateSeries<V> retVal = new CalendarDateSeries<V>(aResolution);
        retVal.setColour(this.getColour());
        retVal.setName(this.getName());
        retVal.putAll(this);
        return retVal;
    }

    public CalendarDate step(CalendarDate aKey) {
        return aKey.step(1, this.myResolution);
    }

    public CalendarDateSeries<V> subMap(CalendarDate aFromKey, boolean inclusiveFromKey, CalendarDate aToKey, boolean inclusiveToKey) {
        NavigableMap tmpMap = super.subMap(aFromKey, inclusiveFromKey, aToKey, inclusiveToKey);
        CalendarDateSeries retVal = new CalendarDateSeries(tmpMap, this.getResolution());
        retVal.setColour(this.getColour());
        retVal.setName(this.getName());
        return retVal;
    }

    public CalendarDateSeries<V> subMap(CalendarDate aFromKey, CalendarDate aKeyLimit) {
        SortedMap tmpMap = super.subMap(aFromKey, aKeyLimit);
        CalendarDateSeries retVal = new CalendarDateSeries(tmpMap, this.getResolution());
        retVal.setColour(this.getColour());
        retVal.setName(this.getName());
        return retVal;
    }

    public CalendarDateSeries<V> tailMap(CalendarDate aFromKey) {
        SortedMap tmpMap = super.tailMap(aFromKey);
        CalendarDateSeries retVal = new CalendarDateSeries(tmpMap, this.getResolution());
        retVal.setColour(this.getColour());
        retVal.setName(this.getName());
        return retVal;
    }

    public CalendarDateSeries<V> tailMap(CalendarDate aFromKey, boolean inclusive) {
        NavigableMap tmpMap = super.tailMap(aFromKey, inclusive);
        CalendarDateSeries retVal = new CalendarDateSeries(tmpMap, this.getResolution());
        retVal.setColour(this.getColour());
        retVal.setName(this.getName());
        return retVal;
    }

    @Override
    public String toString() {
        StringBuilder retVal = this.toStringFirstPart();
        retVal.append((Object)this.getResolution());
        retVal.append('\u00a0');
        this.appendLastPartToString(retVal);
        return retVal.toString();
    }
}

