/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class KeyCounter<K> {
    protected static final int INT_ZERO = 0;
    private final HashMap<K, AtomicInteger> myDelegate = new HashMap();

    public int decrement(K aKey) {
        return this.getValue(aKey).decrementAndGet();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyCounter)) {
            return false;
        }
        KeyCounter other = (KeyCounter)obj;
        return !(this.myDelegate == null ? other.myDelegate != null : !this.myDelegate.equals(other.myDelegate));
    }

    public int get(K aKey) {
        return this.getValue(aKey).get();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myDelegate == null ? 0 : this.myDelegate.hashCode());
        return result;
    }

    public int increment(K aKey) {
        return this.getValue(aKey).incrementAndGet();
    }

    public int reset(K aKey) {
        this.getValue(aKey).set(0);
        return 0;
    }

    public int set(K aKey, int aValue) {
        this.getValue(aKey).set(aValue);
        return aValue;
    }

    public String toString() {
        return this.myDelegate.toString();
    }

    private synchronized AtomicInteger getValue(K aKey) {
        AtomicInteger retVal = this.myDelegate.get(aKey);
        if (retVal == null) {
            retVal = new AtomicInteger();
            this.myDelegate.put(aKey, retVal);
        }
        return retVal;
    }
}

