/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.ojalgo.constant.BigMath;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.CalendarDate;
import org.ojalgo.type.context.NumberContext;

public abstract class TypeUtils {
    public static final long HOURS_PER_CENTURY = 876582L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    private static final String HEX = "#";
    private static final char START = '{';

    public static String format(String aMessagePattern, Object ... someArgs) {
        if (aMessagePattern == null) {
            return null;
        }
        int tmpPatternSize = aMessagePattern.length();
        int tmpArgsCount = someArgs.length;
        int tmpFirst = 0;
        int tmpLimit = tmpPatternSize;
        StringBuilder retVal = new StringBuilder(tmpPatternSize + tmpArgsCount * 20);
        for (int a = 0; a < tmpArgsCount; ++a) {
            tmpLimit = aMessagePattern.indexOf(123, tmpFirst);
            if (tmpLimit == -1) {
                retVal.append(' ');
                retVal.append(someArgs[a]);
                continue;
            }
            retVal.append(aMessagePattern.substring(tmpFirst, tmpLimit));
            retVal.append(someArgs[a]);
            tmpFirst = tmpLimit + 2;
        }
        retVal.append(aMessagePattern.substring(tmpFirst, tmpPatternSize));
        return retVal.toString();
    }

    public static final GregorianCalendar getHundredYearsAgo() {
        GregorianCalendar retVal = new GregorianCalendar();
        retVal.add(1, -100);
        return retVal;
    }

    public static final GregorianCalendar getThousandYearsAgo() {
        GregorianCalendar retVal = new GregorianCalendar();
        retVal.add(1, -1000);
        return retVal;
    }

    public static final GregorianCalendar getThousandYearsFromNow() {
        GregorianCalendar retVal = new GregorianCalendar();
        retVal.add(1, 1000);
        return retVal;
    }

    @Deprecated
    public static boolean isZero(double value) {
        return TypeUtils.isZero(value, PrimitiveMath.IS_ZERO);
    }

    @Deprecated
    public static boolean isZero(double value, double tolerance) {
        return Math.abs(value) <= tolerance;
    }

    @Deprecated
    public static Date makeSqlDate(long aTimeInMillis) {
        return new CalendarDate(aTimeInMillis).toSqlDate();
    }

    @Deprecated
    public static Date makeSqlTime(long aTimeInMillis) {
        return new CalendarDate(aTimeInMillis).toSqlTime();
    }

    @Deprecated
    public static Date makeSqlTimestamp(long aTimeInMillis) {
        return new CalendarDate(aTimeInMillis).toSqlTimestamp();
    }

    public static BigDecimal toBigDecimal(Number number) {
        BigDecimal retVal = BigMath.ZERO;
        if (number != null) {
            if (number instanceof BigDecimal) {
                retVal = (BigDecimal)number;
            } else if (number instanceof Scalar) {
                retVal = ((Scalar)((Object)number)).toBigDecimal();
            } else {
                try {
                    retVal = new BigDecimal(number.toString());
                }
                catch (NumberFormatException exception) {
                    double tmpVal = number.doubleValue();
                    retVal = Double.isNaN(tmpVal) ? BigMath.ZERO : (Double.isInfinite(tmpVal) && tmpVal > PrimitiveMath.ZERO ? BigMath.VERY_POSITIVE : (Double.isInfinite(tmpVal) && tmpVal < PrimitiveMath.ZERO ? BigMath.VERY_NEGATIVE : BigDecimal.valueOf(tmpVal)));
                }
            }
        }
        return retVal;
    }

    public static BigDecimal toBigDecimal(Number number, NumberContext context) {
        return context.enforce(TypeUtils.toBigDecimal(number));
    }

    @Deprecated
    public static ComplexNumber toComplexNumber(Number number) {
        return ComplexNumber.valueOf(number);
    }

    public static String toHexString(int colour) {
        return HEX + Integer.toHexString(colour).substring(2);
    }

    @Deprecated
    public static Quaternion toQuaternion(Number number) {
        return Quaternion.valueOf(number);
    }

    @Deprecated
    public static RationalNumber toRationalNumber(Number number) {
        return RationalNumber.valueOf(number);
    }

    static boolean isSameDate(Calendar aCal1, Calendar aCal2) {
        boolean retVal = aCal1.get(1) == aCal2.get(1);
        retVal = retVal && aCal1.get(2) == aCal2.get(2);
        retVal = retVal && aCal1.get(5) == aCal2.get(5);
        return retVal;
    }

    static boolean isSameTime(Calendar aCal1, Calendar aCal2) {
        boolean retVal = aCal1.get(11) == aCal2.get(11);
        retVal = retVal && aCal1.get(12) == aCal2.get(12);
        retVal = retVal && aCal1.get(13) == aCal2.get(13);
        return retVal;
    }

    protected TypeUtils() {
    }
}

