/*
 * Decompiled with CFR 0.152.
 */
package xlinear;

import java.util.function.DoubleUnaryOperator;
import java.util.stream.DoubleStream;
import xlinear.DenseMatrix;
import xlinear.Matrix;
import xlinear.MatrixOperations;
import xlinear.SparseMatrix;
import xlinear.StaticUtils;
import xlinear.internals.JavaUtils;

public class MatrixExtensions {
    public static SparseMatrix copy(SparseMatrix model) {
        return StaticUtils.copy(model);
    }

    public static DenseMatrix copy(DenseMatrix model) {
        return StaticUtils.copy(model);
    }

    public static Matrix copy(Matrix model) {
        Matrix _switchResult = null;
        boolean _matched = false;
        if (!_matched && model instanceof SparseMatrix) {
            _matched = true;
            _switchResult = MatrixExtensions.copy((SparseMatrix)model);
        }
        if (!_matched && model instanceof DenseMatrix) {
            _matched = true;
            _switchResult = MatrixExtensions.copy((DenseMatrix)model);
        }
        if (!_matched) {
            throw StaticUtils.denseOrSparseException;
        }
        return _switchResult;
    }

    public static DenseMatrix denseCopy(Matrix matrix) {
        int _nRows = matrix.nRows();
        int _nCols = matrix.nCols();
        DenseMatrix result = MatrixOperations.dense(_nRows, _nCols);
        result.operator_add(matrix);
        return result;
    }

    public static SparseMatrix sparseCopy(Matrix matrix) {
        int _nRows = matrix.nRows();
        int _nCols = matrix.nCols();
        SparseMatrix result = MatrixOperations.sparse(_nRows, _nCols);
        result.operator_add(matrix);
        return result;
    }

    public static double sum(Matrix m) {
        DoubleStream _nonZeroEntries = m.nonZeroEntries();
        return _nonZeroEntries.sum();
    }

    public static double norm(Matrix m) {
        DoubleStream _nonZeroEntries = m.nonZeroEntries();
        DoubleUnaryOperator _function = value -> value * value;
        DoubleStream _map = _nonZeroEntries.map(_function);
        double sumOfSqrs = _map.sum();
        return Math.sqrt(sumOfSqrs);
    }

    public static double[][] toArray(Matrix m) {
        return JavaUtils.toArray(m);
    }

    public static double[] vectorToArray(Matrix m) {
        return JavaUtils.vectorToArray(m);
    }

    public static DenseMatrix operator_multiply(Number scalar, DenseMatrix m) {
        return m.mul(scalar);
    }

    public static SparseMatrix operator_multiply(Number scalar, SparseMatrix m) {
        return m.mul(scalar);
    }

    public static Matrix operator_multiply(Number scalar, Matrix m) {
        return m.mul(scalar);
    }

    public static double dot(Matrix vector1, Matrix vector2) {
        boolean _isRowVector_1;
        boolean _isColumnVector_1;
        boolean _and = false;
        boolean _isColumnVector = MatrixExtensions.isColumnVector(vector1);
        _and = !_isColumnVector ? false : (_isColumnVector_1 = MatrixExtensions.isColumnVector(vector2));
        if (_and) {
            Matrix _transpose = vector1.transpose();
            Matrix _multiply = _transpose.operator_multiply(vector2);
            return MatrixExtensions.doubleValue(_multiply);
        }
        boolean _and_1 = false;
        boolean _isRowVector = MatrixExtensions.isRowVector(vector1);
        _and_1 = !_isRowVector ? false : (_isRowVector_1 = MatrixExtensions.isRowVector(vector2));
        if (_and_1) {
            Matrix _transpose_1 = vector2.transpose();
            Matrix _multiply_1 = vector1.operator_multiply(_transpose_1);
            return MatrixExtensions.doubleValue(_multiply_1);
        }
        throw new IllegalArgumentException("Dot product should be one two row vectors (or two column vectors). Use * for standard matrix multiplication.");
    }

    public static double doubleValue(Matrix m) {
        int _nCols;
        boolean _greaterThan_1;
        boolean _greaterThan;
        boolean _or = false;
        int _nRows = m.nRows();
        boolean bl = _greaterThan = _nRows > 1;
        _or = _greaterThan ? true : (_greaterThan_1 = (_nCols = m.nCols()) > 1);
        if (_or) {
            throw StaticUtils.notAScalarException;
        }
        return m.get(0, 0);
    }

    public static boolean isColumnVector(Matrix m) {
        int _nCols = m.nCols();
        return _nCols == 1;
    }

    public static boolean isRowVector(Matrix m) {
        int _nRows = m.nRows();
        return _nRows == 1;
    }

    private MatrixExtensions() {
    }
}

