/*
 * Decompiled with CFR 0.152.
 */
package xlinear.internals;

import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;
import xlinear.Matrix;
import xlinear.StaticUtils;

@Data
public abstract class Slice
implements Matrix {
    public final Matrix rootMatrix;
    public final int row0Incl;
    public final int row1Excl;
    public final int col0Incl;
    public final int col1Excl;
    protected final boolean readOnly;

    protected int rowSlice2Root(int sliceRowIndex) {
        return sliceRowIndex + this.row0Incl;
    }

    protected int colSlice2Root(int sliceColIndex) {
        return sliceColIndex + this.col0Incl;
    }

    protected int rowRoot2Slice(int rootRowIndex) {
        return rootRowIndex - this.row0Incl;
    }

    protected int colRoot2Slice(int rootColIndex) {
        return rootColIndex - this.col0Incl;
    }

    @Override
    public Matrix slice(int row0Incl, int row1Excl, int col0Incl, int col1Excl, boolean makeSubSliceReadOnly) {
        StaticUtils.checkValidSlice(this, row0Incl, row1Excl, col0Incl, col1Excl);
        int _rowSlice2Root = this.rowSlice2Root(row0Incl);
        int _rowSlice2Root_1 = this.rowSlice2Root(row1Excl);
        int _colSlice2Root = this.colSlice2Root(col0Incl);
        int _colSlice2Root_1 = this.colSlice2Root(col1Excl);
        return this.rootMatrix.slice(_rowSlice2Root, _rowSlice2Root_1, _colSlice2Root, _colSlice2Root_1, makeSubSliceReadOnly || this.readOnly);
    }

    @Override
    public int nRows() {
        return this.row1Excl - this.row0Incl;
    }

    @Override
    public int nCols() {
        return this.col1Excl - this.col0Incl;
    }

    @Override
    public double get(int row, int col) {
        StaticUtils.checkBounds(this, row, col);
        int _rowSlice2Root = this.rowSlice2Root(row);
        int _colSlice2Root = this.colSlice2Root(col);
        return this.rootMatrix.get(_rowSlice2Root, _colSlice2Root);
    }

    @Override
    public void set(int row, int col, double value) {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        StaticUtils.checkBounds(this, row, col);
        int _rowSlice2Root = this.rowSlice2Root(row);
        int _colSlice2Root = this.colSlice2Root(col);
        this.rootMatrix.set(_rowSlice2Root, _colSlice2Root, value);
    }

    public Slice(Matrix rootMatrix, int row0Incl, int row1Excl, int col0Incl, int col1Excl, boolean readOnly) {
        this.rootMatrix = rootMatrix;
        this.row0Incl = row0Incl;
        this.row1Excl = row1Excl;
        this.col0Incl = col0Incl;
        this.col1Excl = col1Excl;
        this.readOnly = readOnly;
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rootMatrix == null ? 0 : this.rootMatrix.hashCode());
        result = 31 * result + this.row0Incl;
        result = 31 * result + this.row1Excl;
        result = 31 * result + this.col0Incl;
        result = 31 * result + this.col1Excl;
        result = 31 * result + (this.readOnly ? 1231 : 1237);
        return result;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Slice other = (Slice)obj;
        if (this.rootMatrix == null ? other.rootMatrix != null : !this.rootMatrix.equals(other.rootMatrix)) {
            return false;
        }
        if (other.row0Incl != this.row0Incl) {
            return false;
        }
        if (other.row1Excl != this.row1Excl) {
            return false;
        }
        if (other.col0Incl != this.col0Incl) {
            return false;
        }
        if (other.col1Excl != this.col1Excl) {
            return false;
        }
        return other.readOnly == this.readOnly;
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("rootMatrix", (Object)this.rootMatrix);
        b.add("row0Incl", (Object)this.row0Incl);
        b.add("row1Excl", (Object)this.row1Excl);
        b.add("col0Incl", (Object)this.col0Incl);
        b.add("col1Excl", (Object)this.col1Excl);
        b.add("readOnly", (Object)this.readOnly);
        return b.toString();
    }

    @Pure
    public Matrix getRootMatrix() {
        return this.rootMatrix;
    }

    @Pure
    public int getRow0Incl() {
        return this.row0Incl;
    }

    @Pure
    public int getRow1Excl() {
        return this.row1Excl;
    }

    @Pure
    public int getCol0Incl() {
        return this.col0Incl;
    }

    @Pure
    public int getCol1Excl() {
        return this.col1Excl;
    }

    @Pure
    public boolean isReadOnly() {
        return this.readOnly;
    }
}

