'''
Copyright 2009 Milan Tofiloski, Julian Brooke
This file is part of SLSeg.

    Foobar is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Foobar is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with SLSeg.  If not, see <http://www.gnu.org/licenses/>.
'''

'''
usage: python run_all.py input_directory output_directory path_to_Charniak_parser parseIt_option

there is an option to the charniak parseIt: default is -T210
-T50 decreases accuracy by 1% but parses 6 sentences/second (whereas -T210 does 1.4 sentences/second)

see attached readme.txt for further info
'''

import sys, os, shutil

args = sys.argv
list_of_subdirs = ["step0_preprocessed_text", "step1_inserted_paragraph_breaks", "step2_text_broken_into_sentences", "step3_prep_for_charniak", "step4_charniaked", "step5_segmented", "step6_discoursed", "temp_folder_for_charniak_parser"]

os.system("clear")

# check if 1st argument is directory and that it exists
if os.path.isdir(args[1]):
	pass
else:
	sys.exit("1st argument is not a directory")

# check if 2nd argument is a directory that exists
# if it exists then delete it
if os.path.isdir(args[2]):
	shutil.rmtree(args[2])
	print "removed directory before recreating it:", args[2], "\n"

# create output directory along with all subdirectories
print "creating new directory:", args[2]
os.makedirs(args[2])
for d in list_of_subdirs:
	os.makedirs(os.path.join(args[2], d))
print "finished creating all subdirectories\n"

files = os.listdir(args[1])
print " files in indir:\n", files, "\n"

# for each file in input dir
for f in files:
	print "\nFILE:", f
	#	run preprocess script that expands contractions
	outpath0 = args[2] + "/step0_preprocessed_text/" + "out0" + f
	cmd = "python swap.py " + args[1] + "/" + f + " " + outpath0
	os.system(cmd)
	
	print "ran preprocess script"
	
	# 	insert paragraph breaks
	outpath1 = args[2] + "/step1_inserted_paragraph_breaks/" + "out1" + f
	cmd = "python insert_paragraph_breaks_for_breakSent.py " + outpath0  + " " + outpath1
	os.system(cmd)
	
	print "paragraph breaks inserted"
	
	#	break text in2 sentences
	outpath2 = args[2] + "/step2_text_broken_into_sentences/" + "out2" + f
	cmd = "perl ./breakSent-multi.pl " + outpath1 + " " + outpath2
	os.system(cmd)
	
	print "broke text into sentences using breakSent"
	
	#	prep for charniak parser
	outpath3 = args[2] + "/step3_prep_for_charniak/" + "out3" + f
	outpath3_dir = args[2] + "/step3_prep_for_charniak/"
	cmd = "python prep_as_input_to_charniak_parser.py " + outpath2 + " " + outpath3
	os.system(cmd)
	
	print "finished prepping for charniak parser"

	#charniak_path = "/cs/guests/sentimen/sentiment/Charniak/parser05Aug16/PARSE/parseIt -T50 /cs/guests/sentimen/sentiment/Charniak/parser05Aug16/DATA/EN/ " + outpath3
	charniak_path = args[3] + "/PARSE/parseIt " 
	if len(args) == 5: # this checks if the -T is option has been passed
		charniak_path = charniak_path + args[4] + " "
	charniak_path = charniak_path + args[3] + "/DATA/EN/ " + outpath3
	outpath4 = args[2] + "/step4_charniaked/" + "out4" + f
	cmd = charniak_path + " >> " + outpath4
	os.system(cmd)
	
	print "finished charniaking"

	#	segment in2 clauses
	outpath5 = args[2] + "/step5_segmented/" + "out5" + f
	cmd = "python segmenter.py " + outpath4 + " " + outpath5
	os.system(cmd)
	
	print "finished segmenting"
	
	# the following is currently not yet implemented until we finalize the discourse parser
	#	run thru discourse analyzer
	outpath6 = args[2] + "/step6_discoursed/" + "out6" + f
	#cmd = "python ./discourserV0.1/discourser.py " + outpath5 + " " + outpath6
	#print f, "\n", cmd
	#os.system(cmd)
	


print "Finished all.\n"