(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     15307,        419]
NotebookOptionsPosition[     11179,        342]
NotebookOutlinePosition[     11521,        357]
CellTagsIndexPosition[     11478,        354]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Calculate", " ", "the", " ", "annual", " ", "payment", " ", "for", " ", 
    "the", " ", "market", " ", "interest", " ", "rate"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"r", "=", ".0477"}], "\[IndentingNewLine]", 
   RowBox[{"T", "=", "25"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", "r"}], ")"}], "-", 
    RowBox[{"(", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"r", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "r"}], ")"}], "^", "T"}], ")"}]}], ")"}]}], 
     ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.9405422381053195`*^9, 3.940542279501686*^9}, {
  3.9405487253536634`*^9, 
  3.940548749731057*^9}},ExpressionUUID->"37798c6c-7380-40a9-92df-\
3ebd6cc9bb17"],

Cell[BoxData["0.0477`"], "Output",
 CellChangeTimes->{3.9405422811369543`*^9, 3.9405423641968017`*^9, 
  3.940542477816043*^9},
 CellLabel->"Out[52]=",ExpressionUUID->"285dfe16-5ee5-4338-b41a-3f8a1e44628b"],

Cell[BoxData["25"], "Output",
 CellChangeTimes->{3.9405422811369543`*^9, 3.9405423641968017`*^9, 
  3.940542477816043*^9},
 CellLabel->"Out[53]=",ExpressionUUID->"eb1274c6-bfd9-476a-afc8-ba87f42a2227"],

Cell[BoxData["14.424657619214006`"], "Output",
 CellChangeTimes->{3.9405422811369543`*^9, 3.9405423641968017`*^9, 
  3.940542477816043*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"46418a75-a5f3-44d8-a47e-4909b17f7086"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"800000", "/", "%"}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.9405422845626497`*^9, 3.9405422919430437`*^9}},
 CellLabel->"In[55]:=",ExpressionUUID->"9381a971-80d7-4a3d-9173-8edcbd2a3cfc"],

Cell[BoxData["55460.58846723543`"], "Output",
 CellChangeTimes->{3.94054229536875*^9, 3.9405423642754*^9, 
  3.940542477894625*^9},
 CellLabel->"Out[55]=",ExpressionUUID->"5ff95989-a0c8-4185-9e49-6ec90333be50"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Calcuate", " ", "the", " ", "annual", " ", "payment", " ", "for", " ", 
    "the", " ", "concession", " ", "rate"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"r", "=", ".0369"}]}]], "Input",
 CellChangeTimes->{{3.9405423033441973`*^9, 3.9405423217039843`*^9}, {
  3.9405487568311996`*^9, 
  3.9405487807823844`*^9}},ExpressionUUID->"08f6683e-c3b1-41d7-8f03-\
d67b044da0fc"],

Cell[BoxData["0.0369`"], "Output",
 CellChangeTimes->{3.9405423643222704`*^9, 3.940542477925796*^9},
 CellLabel->"Out[56]=",ExpressionUUID->"86a4f707-4b85-476e-b6fb-1326d358ac4b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"T", "=", "25"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "/", "r"}], ")"}], "-", 
  RowBox[{"(", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"r", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "r"}], ")"}], "^", "T"}], ")"}]}], ")"}]}], 
   ")"}]}]}], "Input",
 CellLabel->"In[57]:=",ExpressionUUID->"39f58f2f-1342-4114-9a53-7c17985ac857"],

Cell[BoxData["25"], "Output",
 CellChangeTimes->{{3.940542342023402*^9, 3.94054236437039*^9}, 
   3.9405424779570613`*^9},
 CellLabel->"Out[57]=",ExpressionUUID->"77123d93-d108-4a35-bf59-dcc51486f8d0"],

Cell[BoxData["16.146799772151127`"], "Output",
 CellChangeTimes->{{3.940542342023402*^9, 3.94054236437039*^9}, 
   3.9405424779675794`*^9},
 CellLabel->"Out[58]=",ExpressionUUID->"83f1c7f9-0c59-45b8-8661-4593ceb192e0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"800000", "/", "%"}]], "Input",
 CellChangeTimes->{{3.940542344158837*^9, 3.940542348297205*^9}},
 CellLabel->"In[59]:=",ExpressionUUID->"b9dd9219-c589-4c6c-ac39-be9a20ae950c"],

Cell[BoxData["49545.42146362551`"], "Output",
 CellChangeTimes->{{3.9405423491242332`*^9, 3.940542364434352*^9}, 
   3.9405424779888*^9},
 CellLabel->"Out[59]=",ExpressionUUID->"4104e146-b437-4f6d-a0cc-6ce1b87cfc50"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Calculate", " ", "the", " ", "payment", " ", "savings", " ", "over", " ", 
    "the", " ", "5", " ", "year", " ", "term"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"r", "=", ".0477"}]}]], "Input",
 CellChangeTimes->{{3.9405424065020113`*^9, 3.940542421407711*^9}, {
  3.9405487914387894`*^9, 
  3.940548817124564*^9}},ExpressionUUID->"12bae726-5900-4495-96ad-\
a62235b0f525"],

Cell[BoxData["0.0477`"], "Output",
 CellChangeTimes->{3.940542478020046*^9},
 CellLabel->"Out[60]=",ExpressionUUID->"4181e53d-c897-43d3-ab66-cb97e3803784"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"T", "=", "5"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "/", "r"}], ")"}], "-", 
  RowBox[{"(", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"r", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "r"}], ")"}], "^", "T"}], ")"}]}], ")"}]}], 
   ")"}]}]}], "Input",
 CellChangeTimes->{{3.940542397323271*^9, 3.9405424647509713`*^9}, 
   3.9405425104498177`*^9},
 CellLabel->"In[63]:=",ExpressionUUID->"fca9943a-57cf-497a-a6df-726df5da623b"],

Cell[BoxData["5"], "Output",
 CellChangeTimes->{{3.940542453164255*^9, 3.940542478051283*^9}, 
   3.9405425117227297`*^9},
 CellLabel->"Out[63]=",ExpressionUUID->"9385ec57-1e0a-48ed-b7e4-61ae011d67a6"],

Cell[BoxData["4.357142021180362`"], "Output",
 CellChangeTimes->{{3.940542453164255*^9, 3.940542478051283*^9}, 
   3.9405425117227297`*^9},
 CellLabel->"Out[64]=",ExpressionUUID->"c1aa76cb-893e-4f54-a0ed-67b75a34eb08"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "*", 
  RowBox[{"(", 
   RowBox[{"55460.59", "-", "49545.42"}], ")"}]}]], "Input",
 CellChangeTimes->{{3.9405425144718647`*^9, 3.9405425398863244`*^9}},
 CellLabel->"In[65]:=",ExpressionUUID->"dd3b5f0b-056b-45d4-849e-485fe6a63c58"],

Cell[BoxData["25773.235769425435`"], "Output",
 CellChangeTimes->{3.940542540593213*^9},
 CellLabel->"Out[65]=",ExpressionUUID->"56b1613c-e268-4657-82ba-9b433bb3aecb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Calculate", " ", "the", " ", "savings", " ", "from", " ", "principal", 
    " ", "reduction"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"r", "=", ".0477"}], "\[IndentingNewLine]", 
   RowBox[{"T", "=", "20"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", "r"}], ")"}], "-", 
    RowBox[{"(", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"r", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "r"}], ")"}], "^", "T"}], ")"}]}], ")"}]}], 
     ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.9405425720322623`*^9, 3.9405425732111826`*^9}, {
  3.940548828269384*^9, 
  3.940548855615223*^9}},ExpressionUUID->"25996214-29b8-4980-93e0-\
d4f9bd109c4e"],

Cell[BoxData["0.0477`"], "Output",
 CellChangeTimes->{3.940542576954161*^9},
 CellLabel->"Out[66]=",ExpressionUUID->"60bd9a6a-d627-45f0-a629-a90defb398e8"],

Cell[BoxData["20"], "Output",
 CellChangeTimes->{3.9405425769697027`*^9},
 CellLabel->"Out[67]=",ExpressionUUID->"dfd27ebf-2c73-447f-915c-a12533c23216"],

Cell[BoxData["12.708872733620344`"], "Output",
 CellChangeTimes->{3.9405425769697027`*^9},
 CellLabel->"Out[68]=",ExpressionUUID->"88f5e7b8-65a4-44bd-bf98-15a330e325b9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", 
  RowBox[{"(", "55460.59", ")"}]}]], "Input",
 CellChangeTimes->{{3.9405425810094705`*^9, 3.940542592983805*^9}},
 CellLabel->"In[69]:=",ExpressionUUID->"24219a67-445f-4b21-b7b5-65b42232ae61"],

Cell[BoxData["704841.5800414971`"], "Output",
 CellChangeTimes->{3.94054259449229*^9},
 CellLabel->"Out[69]=",ExpressionUUID->"c468ae3d-e178-45bc-90cc-2b45455ba5b5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"r", "=", ".0369"}], "\[IndentingNewLine]", 
 RowBox[{"T", "=", "20"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "/", "r"}], ")"}], "-", 
  RowBox[{"(", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"r", "*", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "r"}], ")"}], "^", "T"}], ")"}]}], ")"}]}], 
   ")"}]}]}], "Input",
 CellChangeTimes->{{3.940542604870018*^9, 3.9405426187028685`*^9}},
 CellLabel->"In[70]:=",ExpressionUUID->"a9f0bcbb-23c0-4122-adc6-a6d9d59d0cd5"],

Cell[BoxData["0.0369`"], "Output",
 CellChangeTimes->{3.940542621846052*^9},
 CellLabel->"Out[70]=",ExpressionUUID->"17d4fb97-15ed-4481-b5d8-857aeeddb0a3"],

Cell[BoxData["20"], "Output",
 CellChangeTimes->{3.940542621846052*^9},
 CellLabel->"Out[71]=",ExpressionUUID->"68949a2e-ace0-4e17-be9d-982c9f910e5b"],

Cell[BoxData["13.971135086111335`"], "Output",
 CellChangeTimes->{3.940542621846052*^9},
 CellLabel->"Out[72]=",ExpressionUUID->"a2431566-101a-4768-b713-422346539206"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "*", "49545.42"}]], "Input",
 CellChangeTimes->{{3.940542626858808*^9, 3.9405426392196703`*^9}},
 CellLabel->"In[73]:=",ExpressionUUID->"7df52606-9d43-4f10-8ade-264b654a9ab8"],

Cell[BoxData["692205.7557181222`"], "Output",
 CellChangeTimes->{3.9405426400828953`*^9},
 CellLabel->"Out[73]=",ExpressionUUID->"bbca1044-9773-4a19-9ca9-839f09ccd8be"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"704841.58", "-", "%"}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", "1.0477", ")"}], "^", "5"}], ")"}]}]], "Input",
 CellChangeTimes->{{3.9405426497077885`*^9, 3.9405426799334517`*^9}},
 CellLabel->"In[74]:=",ExpressionUUID->"99951bde-d342-49fe-819f-83104b08f471"],

Cell[BoxData["10009.649220523579`"], "Output",
 CellChangeTimes->{3.9405426827740765`*^9},
 CellLabel->"Out[74]=",ExpressionUUID->"6e9b843e-6b9d-4303-8146-2a22f7d39f6b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"Calculate", " ", "the", " ", "total", " ", "savings"}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.940548884603162*^9, 
  3.9405489242011967`*^9}},ExpressionUUID->"37c9276c-d323-4e3e-92a0-\
4d2212c85375"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "+", "25773.24"}]], "Input",
 CellChangeTimes->{{3.940542710605863*^9, 3.940542717599904*^9}},
 CellLabel->"In[75]:=",ExpressionUUID->"9006393b-89cd-4cfe-93a9-f6a414c71de2"],

Cell[BoxData["35782.88922052358`"], "Output",
 CellChangeTimes->{3.9405427195460787`*^9},
 CellLabel->"Out[75]=",ExpressionUUID->"5527c79b-f8e2-4c74-819e-c3161cbd5cf4"]
}, Open  ]]
},
WindowSize->{599, 620},
WindowMargins->{{Automatic, 38}, {Automatic, 36}},
FrontEndVersion->"11.3 for Microsoft Windows (64-bit) (March 6, 2018)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 858, 25, 86, "Input",ExpressionUUID->"37798c6c-7380-40a9-92df-3ebd6cc9bb17"],
Cell[1441, 49, 206, 3, 32, "Output",ExpressionUUID->"285dfe16-5ee5-4338-b41a-3f8a1e44628b"],
Cell[1650, 54, 201, 3, 32, "Output",ExpressionUUID->"eb1274c6-bfd9-476a-afc8-ba87f42a2227"],
Cell[1854, 59, 218, 3, 32, "Output",ExpressionUUID->"46418a75-a5f3-44d8-a47e-4909b17f7086"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2109, 67, 239, 4, 48, "Input",ExpressionUUID->"9381a971-80d7-4a3d-9173-8edcbd2a3cfc"],
Cell[2351, 73, 210, 3, 32, "Output",ExpressionUUID->"5ff95989-a0c8-4185-9e49-6ec90333be50"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2598, 81, 444, 11, 48, "Input",ExpressionUUID->"08f6683e-c3b1-41d7-8f03-d67b044da0fc"],
Cell[3045, 94, 179, 2, 32, "Output",ExpressionUUID->"86a4f707-4b85-476e-b6fb-1326d358ac4b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3261, 101, 444, 14, 48, "Input",ExpressionUUID->"39f58f2f-1342-4114-9a53-7c17985ac857"],
Cell[3708, 117, 201, 3, 32, "Output",ExpressionUUID->"77123d93-d108-4a35-bf59-dcc51486f8d0"],
Cell[3912, 122, 218, 3, 32, "Output",ExpressionUUID->"83f1c7f9-0c59-45b8-8661-4593ceb192e0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4167, 130, 199, 3, 28, "Input",ExpressionUUID->"b9dd9219-c589-4c6c-ac39-be9a20ae950c"],
Cell[4369, 135, 216, 3, 32, "Output",ExpressionUUID->"4104e146-b437-4f6d-a0cc-6ce1b87cfc50"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4622, 143, 447, 11, 48, "Input",ExpressionUUID->"12bae726-5900-4495-96ad-a62235b0f525"],
Cell[5072, 156, 155, 2, 32, "Output",ExpressionUUID->"4181e53d-c897-43d3-ab66-cb97e3803784"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5264, 163, 539, 16, 48, "Input",ExpressionUUID->"fca9943a-57cf-497a-a6df-726df5da623b"],
Cell[5806, 181, 201, 3, 32, "Output",ExpressionUUID->"9385ec57-1e0a-48ed-b7e4-61ae011d67a6"],
Cell[6010, 186, 218, 3, 32, "Output",ExpressionUUID->"c1aa76cb-893e-4f54-a0ed-67b75a34eb08"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6265, 194, 259, 5, 28, "Input",ExpressionUUID->"dd3b5f0b-056b-45d4-849e-485fe6a63c58"],
Cell[6527, 201, 167, 2, 32, "Output",ExpressionUUID->"56b1613c-e268-4657-82ba-9b433bb3aecb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6731, 208, 820, 24, 86, "Input",ExpressionUUID->"25996214-29b8-4980-93e0-d4f9bd109c4e"],
Cell[7554, 234, 155, 2, 32, "Output",ExpressionUUID->"60bd9a6a-d627-45f0-a629-a90defb398e8"],
Cell[7712, 238, 152, 2, 32, "Output",ExpressionUUID->"dfd27ebf-2c73-447f-915c-a12533c23216"],
Cell[7867, 242, 169, 2, 32, "Output",ExpressionUUID->"88f5e7b8-65a4-44bd-bf98-15a330e325b9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8073, 249, 221, 4, 28, "Input",ExpressionUUID->"24219a67-445f-4b21-b7b5-65b42232ae61"],
Cell[8297, 255, 165, 2, 32, "Output",ExpressionUUID->"c468ae3d-e178-45bc-90cc-2b45455ba5b5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8499, 262, 566, 16, 67, "Input",ExpressionUUID->"a9f0bcbb-23c0-4122-adc6-a6d9d59d0cd5"],
Cell[9068, 280, 155, 2, 32, "Output",ExpressionUUID->"17d4fb97-15ed-4481-b5d8-857aeeddb0a3"],
Cell[9226, 284, 150, 2, 32, "Output",ExpressionUUID->"68949a2e-ace0-4e17-be9d-982c9f910e5b"],
Cell[9379, 288, 167, 2, 32, "Output",ExpressionUUID->"a2431566-101a-4768-b713-422346539206"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9583, 295, 203, 3, 28, "Input",ExpressionUUID->"7df52606-9d43-4f10-8ade-264b654a9ab8"],
Cell[9789, 300, 168, 2, 32, "Output",ExpressionUUID->"bbca1044-9773-4a19-9ca9-839f09ccd8be"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9994, 307, 330, 8, 28, "Input",ExpressionUUID->"99951bde-d342-49fe-819f-83104b08f471"],
Cell[10327, 317, 169, 2, 32, "Output",ExpressionUUID->"6e9b843e-6b9d-4303-8146-2a22f7d39f6b"]
}, Open  ]],
Cell[10511, 322, 255, 6, 28, "Input",ExpressionUUID->"37c9276c-d323-4e3e-92a0-4d2212c85375"],
Cell[CellGroupData[{
Cell[10791, 332, 201, 3, 28, "Input",ExpressionUUID->"9006393b-89cd-4cfe-93a9-f6a414c71de2"],
Cell[10995, 337, 168, 2, 32, "Output",ExpressionUUID->"5527c79b-f8e2-4c74-819e-c3161cbd5cf4"]
}, Open  ]]
}
]
*)

