(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      8326,        240]
NotebookOptionsPosition[      6275,        195]
NotebookOutlinePosition[      6620,        210]
CellTagsIndexPosition[      6577,        207]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Solve", " ", "for", " ", "the", " ", "payment", " ", "size", " ", "for", 
    " ", "the", " ", "$900000", " ", "mortgage"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "/", ".0447"}], ")"}], "-", 
   RowBox[{"(", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{".0447", "*", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", "1.0447", ")"}], "^", "25"}], ")"}]}], ")"}]}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.9400986821945677`*^9, 3.9400987461149178`*^9}},
 CellLabel->"In[12]:=",ExpressionUUID->"4ad82552-15f0-4576-ac14-0082f63cfdff"],

Cell[BoxData["14.874104013194998`"], "Output",
 CellChangeTimes->{3.940098747790429*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"0bc1cab4-9c67-4fcf-ba10-b2006d20fa74"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"900000", "/", "%"}]], "Input",
 CellChangeTimes->{{3.9400987515449557`*^9, 3.9400987564150677`*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"f2aa1468-7466-4380-adca-0fe9f2fc685f"],

Cell[BoxData["60507.84633491867`"], "Output",
 CellChangeTimes->{3.940098757285513*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"005ea3ed-9aed-4a70-985c-c2901e70e64a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Solve", " ", "for", " ", "the", " ", "payment", " ", "with", " ", "the", 
    " ", "mortgage", " ", "premium"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(", 
   RowBox[{"900000", "*", "1.031"}], ")"}]}]], "Input",
 CellChangeTimes->{{3.940098772884756*^9, 3.9400988533348637`*^9}, {
  3.940098914265112*^9, 3.940098925494808*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"dbf24069-b3ae-48da-8384-e8ba7ec164e9"],

Cell[BoxData["927899.9999999999`"], "Output",
 CellChangeTimes->{{3.9400989206948752`*^9, 3.9400989272248063`*^9}},
 CellLabel->"Out[15]=",ExpressionUUID->"229715dd-0d6f-4156-aeab-158d982ba2ff"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/", "14.874"}]], "Input",
 CellChangeTimes->{{3.9400989314751625`*^9, 3.940098939314966*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"6270f397-370e-466d-aa04-c744d6494811"],

Cell[BoxData["62384.02581686162`"], "Output",
 CellChangeTimes->{3.9400989402650003`*^9},
 CellLabel->"Out[16]=",ExpressionUUID->"1e071c9e-a734-41fa-b9f4-67145681656a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Solve", " ", "for", " ", "the", " ", "interest", " ", "rate", " ", "with",
     " ", "this", " ", "notional", " ", "payment"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "y_", "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "/", "y"}], ")"}], "-", 
      RowBox[{"(", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"y", "*", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "+", "y"}], ")"}], "^", "25"}], ")"}]}], ")"}]}], 
       ")"}]}], ")"}]}], "\[IndentingNewLine]", 
   RowBox[{"NSolve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", "y", "]"}], "\[Equal]", 
      RowBox[{"(", 
       RowBox[{"900000", "/", "62384.03"}], ")"}]}], ",", "y", ",", "Reals"}],
     "]"}]}]}]], "Input",
 CellChangeTimes->{{3.940098948774708*^9, 3.9400990952250795`*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"26918b5d-ae96-4680-bd9f-5d67af7d642f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", "0.04768557406033498`"}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.940099095676843*^9},
 CellLabel->"Out[18]=",ExpressionUUID->"1dc87170-5dd3-4714-9235-590b6419f6b6"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
  "Add", " ", "in", " ", "the", " ", "transfer", " ", "tax", " ", "to", " ", 
   "the", " ", "mortgage"}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.940099117885166*^9, 
  3.9400991449267383`*^9}},ExpressionUUID->"1e0051bc-0b10-41f7-a14c-\
1d7ac84f1c7f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"200000", "*", ".01"}], ")"}], "+", 
  RowBox[{"(", 
   RowBox[{"800000", "*", ".02"}], ")"}]}]], "Input",
 CellChangeTimes->{{3.940099149829107*^9, 3.9400991753751154`*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"6c925229-4fb3-4fa4-b18e-32d1ddba0913"],

Cell[BoxData["18000.`"], "Output",
 CellChangeTimes->{3.940099176130209*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"58a743a5-a87f-4cd3-8d91-81393948169e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"927900", "+", "18000"}], ")"}], "/", "14.874"}]], "Input",
 CellChangeTimes->{{3.94009918340519*^9, 3.9400991967447424`*^9}, {
  3.9400992494749513`*^9, 3.940099274475142*^9}},
 CellLabel->"In[20]:=",ExpressionUUID->"fcb3bb2f-fa40-4650-bb15-011dbd074750"],

Cell[BoxData["63594.191206131494`"], "Output",
 CellChangeTimes->{3.9400992752853565`*^9},
 CellLabel->"Out[20]=",ExpressionUUID->"7715b70d-4e79-46eb-8317-2efb8aa88ddc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "y", "]"}], "\[Equal]", 
    RowBox[{"(", 
     RowBox[{"900000", "/", "63594.19"}], ")"}]}], ",", "y", ",", "Reals"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.940099279115018*^9, 3.94009932433519*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"800bfc28-f642-487f-aa41-9e7c0f98ce10"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", "0.04958864258589796`"}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.940099325806801*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"8cc6050e-e536-4ca2-b400-2e750bec7617"]
}, Open  ]]
},
WindowSize->{1180, 620},
WindowMargins->{{Automatic, -559}, {Automatic, 29}},
FrontEndVersion->"11.3 for Microsoft Windows (64-bit) (March 6, 2018)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 671, 19, 48, "Input",ExpressionUUID->"4ad82552-15f0-4576-ac14-0082f63cfdff"],
Cell[1254, 43, 167, 2, 32, "Output",ExpressionUUID->"0bc1cab4-9c67-4fcf-ba10-b2006d20fa74"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1458, 50, 203, 3, 28, "Input",ExpressionUUID->"f2aa1468-7466-4380-adca-0fe9f2fc685f"],
Cell[1664, 55, 166, 2, 32, "Output",ExpressionUUID->"005ea3ed-9aed-4a70-985c-c2901e70e64a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1867, 62, 479, 10, 48, "Input",ExpressionUUID->"dbf24069-b3ae-48da-8384-e8ba7ec164e9"],
Cell[2349, 74, 194, 2, 32, "Output",ExpressionUUID->"229715dd-0d6f-4156-aeab-158d982ba2ff"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2580, 81, 201, 3, 28, "Input",ExpressionUUID->"6270f397-370e-466d-aa04-c744d6494811"],
Cell[2784, 86, 168, 2, 32, "Output",ExpressionUUID->"1e071c9e-a734-41fa-b9f4-67145681656a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2989, 93, 1053, 31, 67, "Input",ExpressionUUID->"26918b5d-ae96-4680-bd9f-5d67af7d642f"],
Cell[4045, 126, 243, 5, 32, "Output",ExpressionUUID->"1dc87170-5dd3-4714-9235-590b6419f6b6"]
}, Open  ]],
Cell[4303, 134, 303, 7, 28, "Input",ExpressionUUID->"1e0051bc-0b10-41f7-a14c-1d7ac84f1c7f"],
Cell[CellGroupData[{
Cell[4631, 145, 304, 7, 28, "Input",ExpressionUUID->"6c925229-4fb3-4fa4-b18e-32d1ddba0913"],
Cell[4938, 154, 155, 2, 32, "Output",ExpressionUUID->"58a743a5-a87f-4cd3-8d91-81393948169e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5130, 161, 307, 6, 28, "Input",ExpressionUUID->"fcb3bb2f-fa40-4650-bb15-011dbd074750"],
Cell[5440, 169, 169, 2, 32, "Output",ExpressionUUID->"7715b70d-4e79-46eb-8317-2efb8aa88ddc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5646, 176, 367, 9, 28, "Input",ExpressionUUID->"800bfc28-f642-487f-aa41-9e7c0f98ce10"],
Cell[6016, 187, 243, 5, 89, "Output",ExpressionUUID->"8cc6050e-e536-4ca2-b400-2e750bec7617"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

