// this thing maps a data variable to a visual variable

class Mapping
{
  String  dataVarNm ;
  int     dataVarIdx = -1 ;
  String  visualVarNm ;
  int     visualVarIdx = -1 ;
  DataCollection  dc ;
  PlotContext pc ;

  // hard-code visual map name to slot in the PlotPoint
  String[]  visualNames = { "x", "y", "color", "size", "orientation", "shape" } ;
  String GetVisualNameStat( int visualIdx )
  {
    if( visualIdx >= 0 && visualIdx < 6 )
      return( visualNames[visualIdx] );
   return( "none" );
  }

  Mapping( PlotContext inPC, DataCollection indc, String dataNm, String visualNm )
  {
    pc = inPC ;
    dc = indc ;
    remap( dataNm, visualNm );
  }
  
  void remap( String dataNm, String visualNm )
  {
    int  i ;
    if( dataNm.equals( "none" ) )    // mapping "none" to the visual index: you won't find "none" in the dataset
    {
      dataVarNm = "none" ;
      dataVarIdx = -1 ;
    }
    else
    {
      i = dc.getVarIdx( dataNm );
      if( i < 0 )
        return ;
      dataVarNm = dataNm ;
      dataVarIdx = i ;
    }
    
    i = pc.getVisIdx( visualNm );
    if( i < 0 )
      return ;    // bogus name
    visualVarNm = visualNm ;
    visualVarIdx = i ;
    println( "Map: Data " + dataVarNm + " " + dataVarIdx + "  ::  Visual "
                  + visualVarNm + " " + visualVarIdx );
  }
  int  getVisualIdx()
  {
    return( visualVarIdx );
  }
  int  getDataIdx()
  {
    return( dataVarIdx );
  }
  String  getDataName()
  {
    return( dataVarNm );
  }
  String  getVisualName()
  {
    return( visualVarNm );
  }

}

