import processing.core.PApplet;

class PlotContext
{
  int  minXBdry ;
  int  maxXBdry ;
  int  minYBdry ;
  int  maxYBdry ;
  PApplet papp ;
  
  // this is where the list of visualy-mappable names lives
  String[] visualNames = { "x",  "y",  "color", "size", "orientation" } ;  
  float[]  minVisRange = { 0.0f, 0.0f, 235.0f,    1.0f,   3.14f/2.0f } ;
  float[]  maxVisRange = { 0.0f, 0.0f, 0.0f,     20.0f,    0.0f } ;
  // "shape" has been left off
  
  PlotContext( PApplet p, int minxB, int maxxB, int minyB, int maxyB )
  {
      papp = p ;
      minXBdry = minxB ;
      maxXBdry = maxxB ;
      minYBdry = minyB ;
      maxYBdry = maxyB ;
      maxVisRange[0] = papp.width - minXBdry - maxXBdry  - 20.0f ;
      maxVisRange[1] = papp.height - minYBdry - maxYBdry  - 20.0f ;
      minVisRange[4] = papp.HALF_PI ;
  }
  
  int getMinXB()
  {
    return( minXBdry );
  }
  int getMaxXB()
  {
    return( maxXBdry );
  }
  int getMinYB()
  {
    return( minYBdry );
  }
  int getMaxYB()
  {
    return( maxYBdry );
  }
  PApplet getPApplet()
  {
    return( papp );
  }

  int  getNumVisuals()
  {
    return( visualNames.length );
  }
  int getVisIdx( String visNm )
  {
    for( int i = 0 ; i < visualNames.length ; i++ )
    {
      if( visualNames[i].equals( visNm ) )
      {
        return( i );
      }
    }
    return( -1 );
  }
  
  String getVisName( int vIdx )
  {
    if( vIdx >= 0 && vIdx < visualNames.length )
      return( visualNames[vIdx] );
    return( "" );
  }
  float getMinVisRange( int vIdx )
  {
    if( vIdx >= 0 && vIdx < visualNames.length )
      return( minVisRange[vIdx] );
    return( 0.0f );
  }
  float getMaxVisRange( int vIdx )
  {
    if( vIdx >= 0 && vIdx < visualNames.length )
      return( maxVisRange[vIdx] );
    return( 1.0f );
  }

}

