import processing.core.PApplet;


// store one plottable Point
// This class takes some information from the global variable space 
// to determine things like screen limits and scaling
public class PlotPoint 
{
  private PApplet papp ;
  PlotContext  pc ;
  float[] vData  ;    // visual dimensions
  
  //static String[] visualNames = { "x", "y", "color", "size", "orientation", "shape" } ; // a reminder from PlotContext
  final int  X = 0 ;      // this is how we "translate" visual name to a particular slot in the data array
  final int  Y = 1 ;
  final int  COLOR = 2 ;
  final int  SIZE = 3 ;
  final int  ORIENTATION = 4 ;
  final int  SHP = 5 ;

  public PlotPoint( PlotContext p )
  {
    pc = p ;
    papp = pc.getPApplet();
    int sz = pc.getNumVisuals() ;
    if( sz > SHP +1 )
      sz = SHP+1 ;
    vData = new float[ sz ] ;
    for( int i = 0 ; i < sz ; i++ )
      vData[i] = 0.0f ;
  }

  // set a single data value in the vData array, AND RESCALE IT to the appropriate
  // visual dimension from the original Data scale (which is given as the last 2 parameters)
  public void setData( int idx, float newV, float minV, float maxV )
  {
    if( idx >= vData.length )
      return ;
    if( maxV <= minV )
    {
      maxV = 1.0f ;
      minV = 0.0f ;
    }
    vData[idx] = papp.map( newV, minV, maxV, pc.getMinVisRange( idx ), pc.getMaxVisRange( idx ) );
  }

  public float getData( int idx )
  {
    return( vData[idx] );
  }

  public void draw()
  {
    papp.rectMode( papp.CENTER );
    papp.pushMatrix();
    papp.stroke( vData[COLOR] );
    papp.fill( vData[COLOR] );
    papp.translate( vData[X], vData[Y] );
    papp.rotate( vData[ORIENTATION] );    // with circles, rotating makes little sense
    papp.rect( 0, 0, vData[SIZE], vData[SIZE] /2  );  // enable us to see rotated rectangles with width/2 == height
    papp.popMatrix();
//    println( vData[X] + " " + vData[Y] );
  }
}

