import SpringGUI.*;

int  numVisDims = 0 ;        // number of visual dimensions
Mapping[]  maps ;            // maps of the N visual dimensions

PlotContext  plotCtx ;
PlotPoint[]  pts ;
DataCollection  dc ;
SpringGUI gui ; 

//  Graphics related constants
final int  GUIWIDTH = 225 ;
final int  CHOICEWIDTH = 150 ;
final int  CHOICEHEIGHT = 20 ;
final int  LABELWIDTH = 75 ;

final int  MINXBoundary = 50 ;
final int  MAXXBoundary = GUIWIDTH ;
final int  MINYBoundary = 50 ;
final int  MAXYBoundary = 50 ;

// get the visual dimensions from the PlotContext Object
//  Use these data to populate the list of Choice Boxes
//  There is one Choice box per visual dimension.
//  Each choice box needs all of the data values
void setupGui()
{
int  i ;

  gui = new SpringGUI(this);
 

  for( i = 0 ; i < numVisDims ; i++ )
  {
  String visNm = plotCtx.getVisName( i );
  String labelNm = visNm + "Label" ;
  String choiceNm = visNm + "Choice" ;

    gui.addTextField( labelNm, visNm, width - GUIWIDTH,     (i+1) * CHOICEHEIGHT, LABELWIDTH, CHOICEHEIGHT); 
    gui.addChoice(  choiceNm,         width - CHOICEWIDTH,  (i+1) * CHOICEHEIGHT, CHOICEWIDTH, CHOICEHEIGHT);
    gui.addItem(    choiceNm, "none");      // add Items to the Choice

    for(int j = 0 ; j < dc.getNumVars() ; j++ )
    {
      gui.addItem( choiceNm, dc.getVarName( j ) );
    }
    gui.selectItem( choiceNm, maps[i].getDataName() );
  }
}



//  Handle an event generated by the SpringGUI widgets
void handleEvent( String[] parameters) 
{
  if( ! parameters[0].equals( "Choice" ) )    // object Type must be Choice: ignore others
    return ;
  if( ! parameters[2].equals( "selected" ) )  // respond only to select events: ignore mouseOver, etc
    return ;
    
  int  i, visIdx = -1, dataIdx = -1 ;
  String  visNm = parameters[1] ;    // get the triggering widget name
  if( !visNm.endsWith( "Choice" ) )
    return ;                         // return if not a Choice widget
  visNm = visNm.substring( 0, visNm.indexOf( "Choice" ));    // chop off "Choice"
  println( "Visual choice is <" + visNm + ">" );
  for( i = 0 ; i < numVisDims ; i++ )
  {
    if( maps[i].getVisualName().equalsIgnoreCase( visNm ) )
    {
      visIdx = i ;
      break ;
    }
  }
  if( visIdx == -1 )
    return ;          // didn't find visual dimension
  
  if( parameters[3].equals( "none" ) )    //  handle select == "none"
  {
    maps[visIdx].remap( "none",  maps[visIdx].getVisualName() );
    mapIt();
    loop();
    return ;    // don't search for the data dimension when "none" is selected
  }
  
  // search for the selected data variable in the data collection
  for( i = 0 ; i < dc.getNumVars() ; i++ )
  {
    if( dc.getVarName( i ).equalsIgnoreCase( parameters[3] ) )
    {
      dataIdx = i ;
      break ;
    }
  }
  if( dataIdx == -1 )
    return ;                // did not find data name given by choice box
  maps[visIdx].remap( dc.getVarName( dataIdx ), maps[visIdx].getVisualName() );
  mapIt();
  loop();    // call  draw()
  //  String eventDesc = "type of object: "+parameters[0]+"; object name: "+parameters[1]+"; event: "+parameters[2]; // create a description of the event
  //  for ( i=3; i<parameters.length; i++) {
  //    eventDesc = eventDesc + "; additional info: " + parameters[i];
  //  }
  //  println(eventDesc); // print the current event to the Processing output as well for an event history...

}

void mapIt()    // activate the current mapping
{
int  i, dataIdx ;

  for( i = 0 ; i < dc.getNumCases() ; i++ )
  {
    for( int j = 0 ; j < numVisDims && j < dc.getNumVars() ; j++ )
    {
      dataIdx = maps[j].getDataIdx() ;
      if( dataIdx >= 0 )
        pts[i].setData( j, dc.getData( i, dataIdx ), dc.getMin( dataIdx ), dc.getMax( dataIdx ) );
      else
      {
        pts[i].setData( j, 0.0, 0.0, 0.0 );
        // println( j );
      }
    }
  }

}

void setup()
{
int  i = 0 ;

  size( 1000, 1000 );    // start graphics
  background( 255 );


  // read the data
  dc = new DataCollection( "IrisDataset.csv" );
  if( dc.getNumVars() < 0 )
    exit();
    
  // set up the visual dimensions available
  plotCtx = new PlotContext( this, MINXBoundary, MAXXBoundary, MINYBoundary, MAXYBoundary );

  // set up a single Mapping object per visual dimension
  numVisDims = plotCtx.getNumVisuals();
  maps = new Mapping[numVisDims] ;
  for( i = 0 ; i < dc.getNumVars() && i < numVisDims ; i++ )
  {
    maps[i] = new Mapping( plotCtx, dc, dc.getVarName( i ), plotCtx.getVisName( i ) );
  }
  
  // set up the GUI with one ChoiceBox per visual dimension
  setupGui();

  // create a PlotPoint per data case
  pts = new PlotPoint[dc.getNumCases() ] ;
  for( i = 0 ; i < dc.getNumCases() ; i++ )
  {
    pts[i] = new PlotPoint( plotCtx );
  }
  
  // map data dimensions to visual dimensions
  mapIt();
}

// draw it all once.  noLoop() is used to stop redrawing
void draw()
{
  background( 255 );
  pushMatrix();
  translate( MINXBoundary, height - MINYBoundary );
  scale( 1, -1 );
  for( int i = 0 ; i < pts.length ; i++ )
    pts[i].draw();

  popMatrix();
  noLoop();
}


