dm 'clear log';
dm 'clear output';

* clogit_demo.sas
* demonstrates the use of clogit.sas
* Simon Woodcock
* 9/14/2002


* this iml step simulates some data with known properties;
proc iml;
	nchooser=10000;
	nchoice=6;
	nvar=5;
	nobs=nchooser*nchoice;
	chooseid=char(100000000000000000*(1:nchooser));
	choiceid=char(100000000000000000*(1:nchoice));

	xdat=j(nobs,nvar,0);
	chooser=j(nobs,1,'                 ');
	choice=j(nobs,1,'                 ');
	n=1;
	do i=1 to nchooser;
		do j=1 to nchoice;
			chooser[n,]=chooseid[,i];
			choice[n,]=choiceid[,j];
			do k=1 to nvar;
				xdat[n,k]=rannor(0);
			end;
			n=n+1;
		end;
	end;

	x=xdat;
	beta=(1:nvar)`;
	*beta=j(nvar,1,1);

	e_xb=exp(x*beta);
	s_e_xb=j(nchooser,1,0);
	p=j(nchoice,1,0);
	cp=j(nchoice,1,0);
	d=j(nobs,1,0);
	do i=1 to nchooser;
		m=((i-1)*nchoice)+1;
		n=i*nchoice;
		s_e_xb[i,]=sum(e_xb[m:n,]);
		p=e_xb[m:n,]/s_e_xb[i,];
		u=ranuni(0);
		STOP=0;
		cp[1,]=p[1,];
		if u<cp[1,] then y=1;
		else do k=2 to nchoice;
			cp[k,]=cp[k-1,]+p[k];
			if u<cp[k] & stop=0 then do;
				y=k;
				stop=1;
			end;
		end;
		d[m+y-1,]=1;
	end;

	call symput('nvar',trim(left(char(nvar))));
	%macro split;
		%do k=1 %to &nvar;
			x&k=xdat[,&k.];
		%end;
	%mend;
	%split;
	%macro xnames;
		%do k=1 %to &nvar;
			x&k
		%end;
	%mend;
	create testdat var{chooser choice %xnames d};
	append;
quit;


/*---- now call clogit ----*/
%include 'r:\development\woodcock\estimating\clogit.sas';
%clogit(testdat,betaout,covbout,%xnames,chooser,choice,d);
