;*****************************************************************
;* This absolute assembly application is for tutorials           *
;* Craig Scratchley, ENSC 151, Spring 2007 term                  *
;* Copyright 2005, School of Engineering Science, SFU, Canada    *
;* You may modify this software under the terms of the GNU GPL   *
;*****************************************************************
; Prepared for Metrowerks Codewarrior v3.x
; optimized for tab width of 8 spaces, where a tab does NOT insert spaces
; I (Craig Scratchley) recommend unticking "Enable Virtual Space" in the
; "Editor Settings" pane of the "Preferences..." window in the Edit menu.
; Also, untick "Use Automatic Code Formatting" in "Formatting" pane.

; Conditional assembly definitions
; for subsystems ...
; for unit testing ...
RemainderTest	SET	1
; for system code
System		SET	1

; export symbols
		XDEF	Entry	; export 'Entry' symbol
		ABSENTRY Entry	; for absolute assembly: mark this as application entry point

		NOLIST
		INCLUDE "compatibility.inc"
		INCLUDE "hc912b32.inc"
;		INCLUDE "FpgaBrdEqu.inc"
;		INCLUDE "db12isrTab.inc"
		LIST

; Additional memory map equate (equates fixed for the chip are in b32regs\configsc.asm)
Dbg12Ram	EQU	$0A00	; absolute address for D-Bug12 variable/scratch RAM

StackRes	EQU	40

; port-var.inc can be included to get ports to the debugger's data window, etc.
;		INCLUDE "PortVar.inc"

		ORG RAMBase
; variable/data section
		INCLUDE "RemainderVar.inc"

	IF System
		INCLUDE "SysVar.inc"
	ENDIF
		
; variable definitions for unit tests can be conditionally included here

; code section
Entry:
; external interrupts may have been disabled in the postload.cmd file.

; stack grows down, so location #Dbg12Ram will not be modified.
		lds	#Dbg12Ram	;set up stack pointer

; initialization code can be included here

; unit tests for subsystems can be conditionally included here
	IF RemainderTest
		INCLUDE "RemainderTest.inc"
	ENDIF

; now conditionally include system code
	IF System
		INCLUDE "Sys.inc"
	ENDIF

endOfMain:				; end of program
		swi			; back to D-Bug12
		bra	Entry		; start the program over again
;		bra	endOfMain	; program ends in a tight loop.

;constant definitions
;	IF System
;		INCLUDE "sys-const.inc"
;	ENDIF

;constant definitions for unit tests can be conditionally included here
	IF RemainderTest
		INCLUDE "RemainderTestConst.inc"
	ENDIF

;subroutine libraries
;subroutine libraries in RAM
		INCLUDE	"RemainderLib.inc"

;These lines will abort assembly if too much RAM is being used.
	if * > (Dbg12Ram - StackRes)
		fail "Too much RAM used"
	endif

;These lines will initialize the RAM reserved for stack with $BB,
;and the remaining unused RAM with $EE.  If all the $BB's disappear
;during execution of your program, increase the size of StackRes.
;Remember that an interrupt is triggered (and hence stack space is
;consumed) when a D-Bug12 breakpoint is reached.
		dcb.b	(Dbg12Ram - StackRes - *), $EE
		dcb.b 	(Dbg12Ram - *), $BB		

		ORG EEBase
;subroutine libraries in EEPROM

;These lines will abort assembly if too much EEProm is being used.
	if * > (EEBase + EESize)
		fail "Too much EEProm used"
	endif
		end
		