***************************************************
; TestRoutine 
; The following code will test your Remainder subroutine
; with data from the table at the end of this file.  The
; X register walks through the data in the table.  Using 
; the swi instruction, this testing code instructs the 
; simulator to stop each time it detects an incorrect result 
; being returned by the Remainder subroutine.  When the simulator stops it may report
; some simulation error or exception, but any such error or exception 
; can simply be ignored.  Press the continue (or a step) button to continue
; the testing.  

TestRoutine:
		ldx	#TestTbl	; point to the test data table (TestTbl)
TestLoop:	
		tfr	x,y		; point Y to the divisor

		ldab	1,+x		; load b with length of dividend
		; X now points to dividend length byte followed by it's value bytes (see TestTbl)

		incb			; test for end of table
		beq	EndOfTesting
;		decb			; restore proper value in B (not needed)
		
		pshx
		jsr	Remainder	; call your subroutine
		pulx
		
		leax	($10 - 3),x	; skip over dividend and padding
		cmpa	x		; check the remainder result
		beq	RemainderPass

; If you get to the next two lines, the caculated remainder was wrong
RemainderFail:	swi
		nop

RemainderPass:	
		cmpb	1,+x		; check the accumulator B result
		beq	XPass
		
; If you get to the next two lines, the 0,1 result in accumulator B was wrong
XFail:		swi
		nop
		
XPass:
		inx			; point X to next row of testing table
		bra	TestLoop	; go do another testcase
						 
EndOfTesting: