; Table of testing data
; This table provides testing data.  Each set of data gives testing input and
; corresponding output for the Remainder subroutine you are to write.
; The input for each test is a divisor value, the dividend length and the dividend
; value bytes (corresponding to it's length)


;An $FF in the second byte on a row (normally last row) marks the end of the tests. 
;Each set of data is padded with extra bytes (each with value of $EE) so that
;the length of each set of test data become 16 bytes.
; 
; *** HINT ***
;
; (The hint no longer works in this "tutorial edition" of Remainder testing)
;
; Please add more tests as you need to ensure the correctness of your submission.
;
;		      
;				dividend	dividend
;		divisor		length		bytes		remainder	quotientIsBig

TestTbl:

; row 1	
length:	set			1
	dc.b	$2,		length,		$8
; padding on next line
	dcb.b		$10 - length - 4, $EE
	dc.b							$0,		0

; row 2	
length:	set			2
	dc.b	$2,		length,		$0,$8
	dcb.b		$10 - length - 4, $EE
	dc.b							$0,		0
		
length:	set			1
	dc.b	$3,		length,		$8
	dcb.b		$10 - length - 4, $EE
	dc.b							$2,		0
		
length:	set			2
	dc.b	$2,		length,		$2,$0
	dcb.b		$10 - length - 4, $EE
	dc.b							$0,		1
		
length:	set			2
	dc.b	$3,		length,		$1,$8
	dcb.b		$10 - length - 4, $EE
	dc.b							$0,		0

length:	set			2
	dc.b	$2,		length,		$4,$5
	dcb.b		$10 - length - 4, $EE
	dc.b							$1,		1

length:	set			2
	dc.b	$D,		length,		$B,$71
	dcb.b		$10 - length - 4, $EE
	dc.b							$4,		0
		
length:	set			3
	dc.b	$FF,		length,		$FF,$FF,$FF
	dcb.b		$10 - length - 4, $EE
	dc.b							$0,		1
		
length:	set			4
	dc.b	$FF,		length,		$2,$0,$0,$0
	dcb.b		$10 - length - 4, $EE
	dc.b							$2,		1
		
;ending row
	dc.b	$FF,		$FF	; end of table

