; Created by Craig Scratchley
; Copyright (C) 2004 School of Engineering Science, SFU, Burnaby, BC, Canada
; You can modify this software under the terms of the GNU General Public License

; Macros for assembler compatiblity

; db is used by many assemblers and is equivalent to dc.b

db		macro
		mlist off
		nolist
	ifc "\2",""
		list
		dc.b \1
		nolist
	else
	 ifc "\3",""
		list
		dc.b \1, \2
		nolist
	 else
	  ifc "\4",""
		list
		dc.b \1, \2, \3
		nolist
	  else
	   ifc "\5",""
		list
		dc.b \1, \2, \3, \4
		nolist
	   else
	    ifc "\6",""
		list
		dc.b \1, \2, \3, \4, \5
		nolist
	    else
	     ifc "\7",""
		list
		dc.b \1, \2, \3, \4, \5, \6
		nolist
	     else
	      ifc "\8",""
		list
		dc.b \1, \2, \3, \4, \5, \6, \7
		nolist
	      else
	       ifc "\9",""
		list
		dc.b \1, \2, \3, \4, \5, \6, \7, \8
		nolist
	       else
	        fail "Too many arguments for db macro"
	       endif
	      endif
	     endif
	    endif
	   endif
	  endif
	 endif
	endif
	 	list
	 	mlist on
		endm

; dw is used by many assemblers and is equivalent to dc.w

dw		macro
		mlist off
		nolist
	ifc "\2",""
		list
		dc.w \1
		nolist
	else
	 ifc "\3",""
		list
		dc.w \1, \2
		nolist
	 else
	  ifc "\4",""
		list
		dc.w \1, \2, \3
		nolist
	  else
	   ifc "\5",""
		list
		dc.w \1, \2, \3, \4
		nolist
	   else
	    ifc "\6",""
		list
		dc.w \1, \2, \3, \4, \5
		nolist
	    else
	     ifc "\7",""
		list
		dc.w \1, \2, \3, \4, \5, \6
		nolist
	     else
	      ifc "\8",""
		list
		dc.w \1, \2, \3, \4, \5, \6, \7
		nolist
	      else
	       ifc "\9",""
		list
		dc.w \1, \2, \3, \4, \5, \6, \7, \8
		nolist
	       else
	        fail "Too many arguments for dw macro"
	       endif
	      endif
	     endif
	    endif
	   endif
	  endif
	 endif
	endif
	 	list
	 	mlist on
		endm

;  The following lines will cause an error to be displayed if an 
;  instruction is placed in the label field (left-hand margin).
;  It does this by pre-defining labels for instructions.
;  This means that the user cannot use an instruction name for a
;  label in his/her program if so desired.  Hopefully this will be
;  more useful than it is troublesome.

;       Craig Scratchley

; for above macros

db
dw

; instructions

ldaa
ldab
ldd
lds
ldx
ldy
leas
leax
leay
staa
stab
std
sts
stx
sty
tab
tap
tba
tfr
tpa
tsx
tsy
txs
tys
exg
xgdx
xgdy
sex
movb
movw
aba
abx
aby
adca
adcb
adda
addb
addd
sba
sbca
sbcb
suba
subb
subd
daa
dec
deca
decb
des
dex
dey
inc
inca
incb
ins
inx
iny
cba
cmpa
cmpb
cpd
cps
cpx
cpy
tst
tsta
tstb
anda
andb
andcc
eora
eorb
oraa
orab
orcc
clc
cli
clr
clra
clrb
clv
com
coma
comb
neg
nega
negb
emul
emuls
mul
ediv
edivs
fdiv
idiv
idivs
bclr
bita
bitb
bset
lsl
lsla
lslb
lsld
lsr
lsra
lsrb
lsrd
asl
asla
aslb
asld
asr
asra
asrb
rol
rola
rolb
ror
rora
rorb

; directives

ABSENTRY
ALIGN
BASE
CLIST

DC.B
DC.W
DC.L

DCB.B
DCB.W
DCB.L

DS.B
DS.W
DS.L

ELSE
END
ENDFOR
ENDIF
ENDM
EQU
EVEN
FAIL
FOR
IF
IFEQ
IFNE
IFLT
IFLE
IFGT
IFGE
IFC
IFNC
IFDEF
IFNDEF
INCLUDE
LIST
LLEN
LONGEVEN
MACRO
MEXIT
MLIST
NOLIST
NOPAGE
OFFSET
ORG
;PAGE
PLEN
RAD50
SECTION
SET
SPC
TABS
TITLE
XDEF
XREF
XREFB

; synonms

DCW
DCL
FCB
FDB
FQB

;RMB
;RMD
;RMQ

; MASM compatibility directives

RMB
RMD 
RMQ 
ELSEC 
ENDC 
NOL 
TTL 
GLOBAL
PUBLIC
EXTERNAL 
;XREFB 
SWITCH 
ASCT 
BSCT 
CSCT
DSCT
IDSCT 
IPSCT
PSCT

; misc

FCC
