/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.util;

import com.google.common.base.Strings;
import com.google.common.collect.Ordering;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class TasksCoreUtil {
    public static AbstractTask getTaskByUrl(TaskList taskList, IRepositoryManager repositoryManager, String taskUrl) {
        if (!Strings.isNullOrEmpty((String)taskUrl)) {
            Collection<AbstractTask> tasks = taskList.getAllTasks();
            List<AbstractTask> sortedTasks = TasksCoreUtil.sortTasksByRepositoryUrl(tasks);
            AbstractRepositoryConnector connector = null;
            TaskRepository repository = null;
            for (AbstractTask task : sortedTasks) {
                URL url;
                if (taskUrl.equals(task.getUrl())) {
                    return task;
                }
                String repositoryUrl = task.getRepositoryUrl();
                if (repositoryUrl == null) continue;
                if (repository == null || !repositoryUrl.equals(repository.getUrl())) {
                    connector = repositoryManager.getRepositoryConnector(task.getConnectorKind());
                    repository = repositoryManager.getRepository(task.getConnectorKind(), task.getRepositoryUrl());
                }
                if (connector == null || (url = connector.getBrowserUrl(repository, task)) == null || !taskUrl.equals(url.toString())) continue;
                return task;
            }
        }
        return null;
    }

    private static List<AbstractTask> sortTasksByRepositoryUrl(Collection<AbstractTask> tasks) {
        List sortedTasks = new Ordering<AbstractTask>(){

            public int compare(AbstractTask left, AbstractTask right) {
                if (left.getRepositoryUrl() == null) {
                    return 1;
                }
                if (right.getRepositoryUrl() == null) {
                    return -1;
                }
                return left.getRepositoryUrl().compareTo(right.getRepositoryUrl());
            }
        }.nullsLast().sortedCopy(tasks);
        return sortedTasks;
    }
}

